/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.platform;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.BatteryManager;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import android.webkit.MimeTypeMap;
import io.dyte.core.platform.IDytePlatformUtils;
import io.dyte.core.platform.IDytePlatformUtilsProvider;
import io.dyte.core.platform.PlatformFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u000fH\u0017J\b\u0010(\u001a\u00020\bH\u0017J\b\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u0016\u00101\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u00020+03H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/dyte/core/platform/DyteAndroidPlatform;", "Lio/dyte/core/platform/IDytePlatformUtils;", "activity", "Landroid/app/Activity;", "utilsProvider", "Lio/dyte/core/platform/IDytePlatformUtilsProvider;", "(Landroid/app/Activity;Lio/dyte/core/platform/IDytePlatformUtilsProvider;)V", "decodeAuthToken", "", "authToken", "getActivity", "", "getAndroidApplicationContext", "getBatteryLevel", "getCurrentTime", "", "getDeviceInfo", "getDeviceModel", "getDeviceType", "getDiff", "startTime", "endTime", "getFileContent", "", "filePath", "getJson", "strEncoded", "getOsName", "getOsVersion", "getPlatformFile", "Lio/dyte/core/platform/PlatformFile;", "uri", "Landroid/net/Uri;", "Lio/dyte/core/platform/Uri;", "path", "getSdkType", "getUrlEncodedString", "stringToEncode", "getUserDisplayableTime", "time", "getUtcTimeNow", "getUuid", "listenForCrashes", "", "printThread", "desc", "readFileContent", "contentResolver", "Landroid/content/ContentResolver;", "runOnMainThread", "runnable", "Lkotlin/Function0;", "shared_debug"})
public final class DyteAndroidPlatform
implements IDytePlatformUtils {
    @NotNull
    private final Activity activity;
    @NotNull
    private final IDytePlatformUtilsProvider utilsProvider;

    public DyteAndroidPlatform(@NotNull Activity activity, @NotNull IDytePlatformUtilsProvider utilsProvider) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)utilsProvider, (String)"utilsProvider");
        this.activity = activity;
        this.utilsProvider = utilsProvider;
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    @NotNull
    public String getUuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @Override
    @NotNull
    public Object getAndroidApplicationContext() {
        Application application = this.activity.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"activity.application");
        return application;
    }

    @Override
    @NotNull
    public Object getActivity() {
        return this.activity;
    }

    @Override
    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public String getDiff(@NotNull String startTime, @NotNull String endTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        SimpleDateFormat dates = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
        Date date1 = dates.parse(startTime);
        Date date2 = dates.parse(endTime);
        Date date = date1;
        if (date == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Date date3 = date2;
        if (date3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        int differenceInMillis = (int)Math.abs(date.getTime() - date3.getTime());
        int seconds = differenceInMillis / 1000 % 60;
        int minutes = (differenceInMillis - seconds) / 1000 / 60;
        String newSeconds = String.valueOf(seconds);
        if (seconds < 10) {
            newSeconds = '0' + newSeconds;
        }
        String newMinutes = String.valueOf(minutes);
        if (minutes < 10) {
            newMinutes = '0' + newMinutes;
        }
        return newMinutes + ':' + newSeconds;
    }

    @Override
    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public String getUtcTimeNow() {
        DateFormat m_ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
        m_ISO8601Local.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = m_ISO8601Local.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m_ISO8601Local.format(Date())");
        return string;
    }

    @Override
    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public String getUserDisplayableTime(long time) {
        DateFormat dateFormat = new SimpleDateFormat("HH:mm");
        String string = dateFormat.format(new Date(time));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(Date(time))");
        return string;
    }

    @Override
    @NotNull
    public byte[] getFileContent(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return FilesKt.readBytes((File)new File(filePath));
    }

    @Override
    public void printThread(@Nullable String desc) {
        Log.v((String)"DyteMobileClient", (String)("current thread " + Thread.currentThread().getName() + " for " + desc));
    }

    @Override
    public void listenForCrashes() {
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> DyteAndroidPlatform.listenForCrashes$lambda$0(defaultHandler, arg_0, arg_1));
    }

    @Override
    @NotNull
    public String getOsName() {
        return "android";
    }

    @Override
    @NotNull
    public String getOsVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    @Override
    @NotNull
    public String getDeviceInfo() {
        return Build.MODEL + " | " + Build.MANUFACTURER + " | " + Build.VERSION.SDK_INT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String decodeAuthToken(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String meetingId = null;
        try {
            void $this$toTypedArray$iv;
            Object object = authToken;
            Regex regex = new Regex("\\.");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            JSONObject body = new JSONObject(this.getJson(split[1]));
            if (body.has("meetingId")) {
                meetingId = body.getString("meetingId");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid auth token");
        }
        return meetingId;
    }

    private final String getJson(String strEncoded) throws UnsupportedEncodingException {
        byte[] byArray = Base64.decode((String)strEncoded, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(strEncoded, Base64.URL_SAFE)");
        byte[] decodedBytes = byArray;
        int offset$iv = 0;
        int length$iv = decodedBytes.length;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$String = false;
        return new String(decodedBytes, offset$iv, length$iv, charset$iv);
    }

    @Override
    @NotNull
    public String getUrlEncodedString(@NotNull String stringToEncode) {
        Intrinsics.checkNotNullParameter((Object)stringToEncode, (String)"stringToEncode");
        String string = URLEncoder.encode(stringToEncode, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(stringToEncode, \"UTF-8\")");
        return string;
    }

    @Override
    @Nullable
    public PlatformFile getPlatformFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            File file = new File(path);
            String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(FilesKt.getExtension((File)file));
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return new PlatformFile(string, FilesKt.readBytes((File)file), file.length(), mimeType);
        }
        catch (Exception e) {
            this.utilsProvider.getControllerContainer().getLoggerController().traceError("DyteAndroidPlatform | getPlatformFile | " + e.getMessage() + " | path=" + path);
            PlatformFile platformFile = null;
            return platformFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PlatformFile getPlatformFile(@NotNull Uri uri) {
        block14: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Object object = this.getAndroidApplicationContext();
            Application application = object instanceof Application ? (Application)object : null;
            if (application == null || (application = application.getApplicationContext()) == null) break block14;
            Application context = application;
            boolean bl = false;
            ContentResolver contentResolver = context.getContentResolver();
            try {
                Unit unit;
                Cursor cursor = contentResolver.query(uri, null, null, null, null);
                if (cursor != null) {
                    Closeable closeable = (Closeable)cursor;
                    Throwable throwable = null;
                    try {
                        Cursor cursor2 = (Cursor)closeable;
                        boolean bl2 = false;
                        int nameIndex = cursor2.getColumnIndex("_display_name");
                        int sizeIndex = cursor2.getColumnIndex("_size");
                        if (cursor2.moveToFirst()) {
                            String name = cursor2.getString(nameIndex);
                            long size = cursor2.getLong(sizeIndex);
                            String mimeType = contentResolver.getType(uri);
                            Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"contentResolver");
                            byte[] content = this.readFileContent(contentResolver, uri);
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            PlatformFile platformFile = new PlatformFile(name, content, size, mimeType);
                            return platformFile;
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit3 = unit;
            }
            catch (FileNotFoundException e) {
                this.utilsProvider.getControllerContainer().getLoggerController().traceError("DyteAndroidPlatform | getPlatformFile | " + e.getMessage() + " | uri=" + uri);
                Unit unit = Unit.INSTANCE;
            }
            catch (IOException e) {
                this.utilsProvider.getControllerContainer().getLoggerController().traceError("DyteAndroidPlatform | getPlatformFile | " + e.getMessage() + " | uri=" + uri);
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e) {
                this.utilsProvider.getControllerContainer().getLoggerController().traceError("DyteAndroidPlatform | getPlatformFile | " + e.getMessage() + " | uri=" + uri);
                Unit unit = Unit.INSTANCE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] readFileContent(ContentResolver contentResolver, Uri uri) throws FileNotFoundException, IOException {
        InputStream inputStream = contentResolver.openInputStream(uri);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream2);
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        throw new IOException("Could not open input stream to read file");
    }

    @Override
    @NotNull
    public String getDeviceModel() {
        return Build.MANUFACTURER + " | " + Build.MODEL;
    }

    @Override
    @NotNull
    public String getDeviceType() {
        return "android";
    }

    @Override
    @NotNull
    public String getSdkType() {
        return "android-core";
    }

    @Override
    @NotNull
    public String getBatteryLevel() {
        Object object = this.utilsProvider.getPlatformUtils().getAndroidApplicationContext();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.Context");
        Object object2 = ((Context)object).getSystemService("batterymanager");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.os.BatteryManager");
        return String.valueOf(((BatteryManager)object2).getIntProperty(4));
    }

    @Override
    public void runOnMainThread(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.activity.runOnUiThread(() -> DyteAndroidPlatform.runOnMainThread$lambda$4(runnable));
    }

    private static final void listenForCrashes$lambda$0(Thread.UncaughtExceptionHandler $defaultHandler, Thread thread2, Throwable throwable) {
        if ($defaultHandler != null) {
            $defaultHandler.uncaughtException(thread2, throwable);
        }
    }

    private static final void runOnMainThread$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }
}

