/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.platform;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.CountDownTimer;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import io.dyte.core.controllers.Permission;
import io.dyte.core.controllers.PermissionType;
import io.dyte.core.platform.IDytePlatformPermissionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017J2\u0010\n\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tH\u0017J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\tH\u0002J2\u0010\u0016\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/dyte/core/platform/DyteAndroidPlatformPermissions;", "Lio/dyte/core/platform/IDytePlatformPermissionUtils;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "arePermissionsGranted", "", "permissions", "", "Lio/dyte/core/controllers/Permission;", "askPermissions", "onPermissionsGranted", "Lkotlin/Function0;", "", "onPermissionsDenied", "getPlatformPermission", "", "permission", "isPermissionGranted", "isPermissionGrantedInternal", "context", "Landroid/content/Context;", "pollForPermissions", "onPermissionGranted", "shared_debug"})
public final class DyteAndroidPlatformPermissions
implements IDytePlatformPermissionUtils {
    @NotNull
    private final Activity activity;

    public DyteAndroidPlatformPermissions(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
    }

    @Override
    @RequiresApi(value=23)
    public boolean arePermissionsGranted(@NotNull List<Permission> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        ArrayList<Permission> grantedPermissions = new ArrayList<Permission>();
        ArrayList<Permission> deniedPermissions = new ArrayList<Permission>();
        Iterable $this$forEach$iv = permissions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Permission permission = (Permission)element$iv;
            boolean bl = false;
            if (this.isPermissionGrantedInternal((Context)this.activity, permission)) {
                grantedPermissions.add(permission);
                continue;
            }
            deniedPermissions.add(permission);
        }
        return deniedPermissions.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresApi(value=23)
    public boolean askPermissions(@NotNull List<Permission> permissions, @NotNull Function0<Unit> onPermissionsGranted, @NotNull Function0<Unit> onPermissionsDenied) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(onPermissionsGranted, (String)"onPermissionsGranted");
        Intrinsics.checkNotNullParameter(onPermissionsDenied, (String)"onPermissionsDenied");
        if (Build.VERSION.SDK_INT < 23) {
            ArrayList<Permission> deniedPermissions = new ArrayList<Permission>();
            Iterable $this$forEach$iv = permissions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Permission permission = (Permission)element$iv;
                boolean bl = false;
                if (this.isPermissionGrantedInternal((Context)this.activity, permission)) continue;
                deniedPermissions.add(permission);
            }
            if (!((Collection)deniedPermissions).isEmpty()) {
                onPermissionsDenied.invoke();
            } else {
                onPermissionsGranted.invoke();
            }
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = permissions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Permission permission = (Permission)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getPlatformPermission((Permission)it));
            }
            List platformPermissions = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = platformPermissions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.activity.requestPermissions(thisCollection$iv.toArray(new String[0]), 111);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, permissions, onPermissionsGranted, onPermissionsDenied, null){
                int label;
                final /* synthetic */ DyteAndroidPlatformPermissions this$0;
                final /* synthetic */ List<Permission> $permissions;
                final /* synthetic */ Function0<Unit> $onPermissionsGranted;
                final /* synthetic */ Function0<Unit> $onPermissionsDenied;
                {
                    this.this$0 = $receiver;
                    this.$permissions = $permissions;
                    this.$onPermissionsGranted = $onPermissionsGranted;
                    this.$onPermissionsDenied = $onPermissionsDenied;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DyteAndroidPlatformPermissions.access$pollForPermissions(this.this$0, this.$permissions, this.$onPermissionsGranted, this.$onPermissionsDenied);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private final void pollForPermissions(List<Permission> permissions, Function0<Unit> onPermissionGranted, Function0<Unit> onPermissionsDenied) {
        CountDownTimer timer2 = new CountDownTimer(permissions, this, onPermissionGranted, onPermissionsDenied){
            final /* synthetic */ List<Permission> $permissions;
            final /* synthetic */ DyteAndroidPlatformPermissions this$0;
            final /* synthetic */ Function0<Unit> $onPermissionGranted;
            final /* synthetic */ Function0<Unit> $onPermissionsDenied;
            {
                this.$permissions = $permissions;
                this.this$0 = $receiver;
                this.$onPermissionGranted = $onPermissionGranted;
                this.$onPermissionsDenied = $onPermissionsDenied;
                super(30000L, 1000L);
            }

            /*
             * WARNING - void declaration
             */
            public void onTick(long millisUntilFinished) {
                void $this$forEach$iv;
                Iterable iterable = this.$permissions;
                DyteAndroidPlatformPermissions dyteAndroidPlatformPermissions = this.this$0;
                Function0<Unit> function0 = this.$onPermissionGranted;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Permission it = (Permission)element$iv;
                    boolean bl = false;
                    ArrayList<Permission> deniedPermissions = new ArrayList<Permission>();
                    ArrayList<Permission> grantedPermissions = new ArrayList<Permission>();
                    if (dyteAndroidPlatformPermissions.isPermissionGranted(it)) {
                        grantedPermissions.add(it);
                    } else {
                        deniedPermissions.add(it);
                    }
                    if (!deniedPermissions.isEmpty()) continue;
                    function0.invoke();
                    this.cancel();
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onFinish() {
                void $this$forEach$iv;
                Iterable iterable = this.$permissions;
                DyteAndroidPlatformPermissions dyteAndroidPlatformPermissions = this.this$0;
                Function0<Unit> function0 = this.$onPermissionGranted;
                Function0<Unit> function02 = this.$onPermissionsDenied;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Permission it = (Permission)element$iv;
                    boolean bl = false;
                    ArrayList<Permission> deniedPermissions = new ArrayList<Permission>();
                    ArrayList<Permission> grantedPermissions = new ArrayList<Permission>();
                    if (dyteAndroidPlatformPermissions.isPermissionGranted(it)) {
                        grantedPermissions.add(it);
                    } else {
                        deniedPermissions.add(it);
                    }
                    if (deniedPermissions.isEmpty()) {
                        function0.invoke();
                        continue;
                    }
                    function02.invoke();
                }
            }
        };
        timer2.start();
    }

    @Override
    @RequiresApi(value=23)
    public boolean isPermissionGranted(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return this.isPermissionGrantedInternal((Context)this.activity, permission);
    }

    private final String getPlatformPermission(Permission permission) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[permission.getType().ordinal()]) {
            case 1: {
                string = "android.permission.CAMERA";
                break;
            }
            case 2: {
                string = "android.permission.RECORD_AUDIO";
                break;
            }
            case 3: {
                if (Build.VERSION.SDK_INT >= 30) {
                    string = "android.permission.MANAGE_EXTERNAL_STORAGE";
                    break;
                }
                string = "android.permission.WRITE_EXTERNAL_STORAGE";
                break;
            }
            default: {
                throw new IllegalArgumentException("permission type not supported " + (Object)((Object)permission.getType()));
            }
        }
        return string;
    }

    private final boolean isPermissionGrantedInternal(Context context, Permission permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)this.getPlatformPermission(permission)) == 0;
    }

    @Override
    public boolean askCameraPermissions(@NotNull Function0<Unit> onPermissionsGranted, @NotNull Function0<Unit> onPermissionsDenied) {
        return IDytePlatformPermissionUtils.DefaultImpls.askCameraPermissions(this, onPermissionsGranted, onPermissionsDenied);
    }

    @Override
    public boolean askAudioPermissions(@NotNull Function0<Unit> onPermissionsGranted, @NotNull Function0<Unit> onPermissionsDenied) {
        return IDytePlatformPermissionUtils.DefaultImpls.askAudioPermissions(this, onPermissionsGranted, onPermissionsDenied);
    }

    public static final /* synthetic */ void access$pollForPermissions(DyteAndroidPlatformPermissions $this, List permissions, Function0 onPermissionGranted, Function0 onPermissionsDenied) {
        $this.pollForPermissions(permissions, (Function0<Unit>)onPermissionGranted, (Function0<Unit>)onPermissionsDenied);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionType.values().length];
            try {
                nArray[PermissionType.CAMERA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionType.MICROPHONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionType.STORAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

