/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.platform;

import android.app.Activity;
import io.dyte.core.controllers.IControllerContainer;
import io.dyte.core.platform.DyteAndroidLogger;
import io.dyte.core.platform.DyteAndroidMedia;
import io.dyte.core.platform.DyteAndroidPlatform;
import io.dyte.core.platform.DyteAndroidPlatformPermissions;
import io.dyte.core.platform.DyteAndroidVideoUtils;
import io.dyte.core.platform.DyteAndroidWebView;
import io.dyte.core.platform.IDyteLoggerUtils;
import io.dyte.core.platform.IDyteMediaUtils;
import io.dyte.core.platform.IDytePlatformPermissionUtils;
import io.dyte.core.platform.IDytePlatformUtils;
import io.dyte.core.platform.IDytePlatformUtilsProvider;
import io.dyte.core.platform.IDyteVideoUtils;
import io.dyte.core.platform.IDyteWebView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/dyte/core/platform/DyteAndroidPlatformProvider;", "Lio/dyte/core/platform/IDytePlatformUtilsProvider;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "_controllerContainer", "Lio/dyte/core/controllers/IControllerContainer;", "loggerUtils", "Lio/dyte/core/platform/DyteAndroidLogger;", "mediaUtils", "Lio/dyte/core/platform/DyteAndroidMedia;", "platformPermissionsUtils", "Lio/dyte/core/platform/DyteAndroidPlatformPermissions;", "platformUtils", "Lio/dyte/core/platform/DyteAndroidPlatform;", "videoUtils", "Lio/dyte/core/platform/DyteAndroidVideoUtils;", "createWebView", "Lio/dyte/core/platform/IDyteWebView;", "getControllerContainer", "getLogger", "Lio/dyte/core/platform/IDyteLoggerUtils;", "getMediaUtils", "Lio/dyte/core/platform/IDyteMediaUtils;", "getPermissionUtils", "Lio/dyte/core/platform/IDytePlatformPermissionUtils;", "getPlatformUtils", "Lio/dyte/core/platform/IDytePlatformUtils;", "getVideoUtils", "Lio/dyte/core/platform/IDyteVideoUtils;", "init", "", "controllerContainer", "shared_debug"})
public final class DyteAndroidPlatformProvider
implements IDytePlatformUtilsProvider {
    @NotNull
    private final Activity activity;
    private IControllerContainer _controllerContainer;
    @Nullable
    private DyteAndroidPlatform platformUtils;
    @Nullable
    private DyteAndroidLogger loggerUtils;
    @Nullable
    private DyteAndroidMedia mediaUtils;
    @Nullable
    private DyteAndroidVideoUtils videoUtils;
    @Nullable
    private DyteAndroidPlatformPermissions platformPermissionsUtils;

    public DyteAndroidPlatformProvider(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
    }

    @Override
    public void init(@NotNull IControllerContainer controllerContainer) {
        Intrinsics.checkNotNullParameter((Object)controllerContainer, (String)"controllerContainer");
        this._controllerContainer = controllerContainer;
        this.loggerUtils = new DyteAndroidLogger();
        this.mediaUtils = new DyteAndroidMedia(this);
        this.videoUtils = new DyteAndroidVideoUtils(this);
        this.platformUtils = new DyteAndroidPlatform(this.activity, this);
        this.platformPermissionsUtils = new DyteAndroidPlatformPermissions(this.activity);
    }

    @Override
    @NotNull
    public IDytePlatformUtils getPlatformUtils() {
        DyteAndroidPlatform dyteAndroidPlatform = this.platformUtils;
        if (dyteAndroidPlatform == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return dyteAndroidPlatform;
    }

    @Override
    @NotNull
    public IDyteLoggerUtils getLogger() {
        DyteAndroidLogger dyteAndroidLogger = this.loggerUtils;
        if (dyteAndroidLogger == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return dyteAndroidLogger;
    }

    @Override
    @NotNull
    public IDyteMediaUtils getMediaUtils() {
        DyteAndroidMedia dyteAndroidMedia = this.mediaUtils;
        if (dyteAndroidMedia == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return dyteAndroidMedia;
    }

    @Override
    @NotNull
    public IControllerContainer getControllerContainer() {
        IControllerContainer iControllerContainer = this._controllerContainer;
        if (iControllerContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_controllerContainer");
            iControllerContainer = null;
        }
        return iControllerContainer;
    }

    @Override
    @NotNull
    public IDyteWebView createWebView() {
        return new DyteAndroidWebView(this);
    }

    @Override
    @NotNull
    public IDyteVideoUtils getVideoUtils() {
        DyteAndroidVideoUtils dyteAndroidVideoUtils = this.videoUtils;
        if (dyteAndroidVideoUtils == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return dyteAndroidVideoUtils;
    }

    @Override
    @NotNull
    public IDytePlatformPermissionUtils getPermissionUtils() {
        DyteAndroidPlatformPermissions dyteAndroidPlatformPermissions = this.platformPermissionsUtils;
        if (dyteAndroidPlatformPermissions == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return dyteAndroidPlatformPermissions;
    }
}

