/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.dyte.core.platform.DyteAndroidWebView;
import io.dyte.core.platform.DytePluginFile;
import io.dyte.core.platform.IDytePlatformUtilsProvider;
import io.dyte.core.platform.IDyteWebView;
import io.dyte.core.platform.IDyteWebViewListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\r\u001a\u00060\u000ej\u0002`\u0011H\u0002J\f\u0010\u0012\u001a\u00060\u000ej\u0002`\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/dyte/core/platform/DyteAndroidWebView;", "Lio/dyte/core/platform/IDyteWebView;", "utilsProvider", "Lio/dyte/core/platform/IDytePlatformUtilsProvider;", "(Lio/dyte/core/platform/IDytePlatformUtilsProvider;)V", "filePathCallback", "Landroid/webkit/ValueCallback;", "", "Landroid/net/Uri;", "jsWebViewInterface", "Lio/dyte/core/platform/DyteAndroidWebView$WebViewInterface;", "listener", "Lio/dyte/core/platform/IDyteWebViewListener;", "webView", "Landroid/webkit/WebView;", "bindWebView", "", "Lio/dyte/core/platform/WebView;", "getWebView", "initializeWebView", "loadURL", "url", "", "removeListener", "setListener", "submitEvent", "payload", "Lkotlinx/serialization/json/JsonObject;", "uploadFile", "dytePluginFile", "Lio/dyte/core/platform/DytePluginFile;", "Companion", "WebViewInterface", "shared_debug"})
@SuppressLint(value={"SetJavaScriptEnabled"})
public final class DyteAndroidWebView
implements IDyteWebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDytePlatformUtilsProvider utilsProvider;
    @NotNull
    private WebView webView;
    @Nullable
    private IDyteWebViewListener listener;
    @Nullable
    private ValueCallback<Uri[]> filePathCallback;
    @NotNull
    private final WebViewInterface jsWebViewInterface;
    @NotNull
    private static final String NAME_JS_INTERFACE = "WebViewInterface";
    @NotNull
    private static final String jsListenerScript = "window.parent = {};\nwindow.parent.postMessage = function(message) {\n  var formattedJSON = JSON.stringify(message);\n  WebViewInterface.postMessage(formattedJSON);\n};";

    public DyteAndroidWebView(@NotNull IDytePlatformUtilsProvider utilsProvider) {
        Intrinsics.checkNotNullParameter((Object)utilsProvider, (String)"utilsProvider");
        this.utilsProvider = utilsProvider;
        Object object = this.utilsProvider.getPlatformUtils().getActivity();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.Context");
        this.webView = new WebView((Context)object);
        this.jsWebViewInterface = new WebViewInterface();
    }

    @Override
    public void loadURL(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.webView.loadUrl(url);
    }

    @Override
    public void initializeWebView() {
        this.bindWebView(this.webView);
    }

    @Override
    public void setListener(@NotNull IDyteWebViewListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.jsWebViewInterface.setInterfaceListener(listener);
    }

    @Override
    public void removeListener() {
        this.listener = null;
        this.jsWebViewInterface.removeInterfaceListener();
    }

    @Override
    @NotNull
    public WebView getWebView() {
        return this.webView;
    }

    private final void bindWebView(WebView webView) {
        WebView $this$bindWebView_u24lambda_u240 = webView;
        boolean bl = false;
        $this$bindWebView_u24lambda_u240.getSettings().setJavaScriptEnabled(true);
        $this$bindWebView_u24lambda_u240.getSettings().setDomStorageEnabled(true);
        $this$bindWebView_u24lambda_u240.getSettings().setDatabaseEnabled(true);
        $this$bindWebView_u24lambda_u240.getSettings().setMediaPlaybackRequiresUserGesture(false);
        $this$bindWebView_u24lambda_u240.clearCache(true);
        $this$bindWebView_u24lambda_u240.clearHistory();
        webView.addJavascriptInterface((Object)this.jsWebViewInterface, NAME_JS_INTERFACE);
        webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
                block0: {
                    super.onPageFinished(view, url);
                    WebView webView = view;
                    if (webView == null) break block0;
                    webView.evaluateJavascript(DyteAndroidWebView.access$getJsListenerScript$cp(), bindWebView.1.1::onPageFinished$lambda$0);
                }
            }

            private static final void onPageFinished$lambda$0(String it) {
            }
        });
        $this$bindWebView_u24lambda_u240.setWebChromeClient(new WebChromeClient(this){
            final /* synthetic */ DyteAndroidWebView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onShowFileChooser(@Nullable WebView webView, @Nullable ValueCallback<Uri[]> filePathCallback, @Nullable WebChromeClient.FileChooserParams fileChooserParams) {
                block0: {
                    DyteAndroidWebView.access$setFilePathCallback$p(this.this$0, filePathCallback);
                    IDyteWebViewListener iDyteWebViewListener = DyteAndroidWebView.access$getListener$p(this.this$0);
                    if (iDyteWebViewListener == null) break block0;
                    iDyteWebViewListener.onFileRequest();
                }
                return true;
            }
        });
    }

    @Override
    public void submitEvent(@NotNull JsonObject payload2) {
        Intrinsics.checkNotNullParameter((Object)payload2, (String)"payload");
        this.webView.evaluateJavascript(StringsKt.trimIndent((String)("\n        window.postMessage(" + payload2 + ");\n      ")), null);
    }

    @Override
    public void uploadFile(@NotNull DytePluginFile dytePluginFile) {
        Intrinsics.checkNotNullParameter((Object)dytePluginFile, (String)"dytePluginFile");
        if (dytePluginFile.getResultCode() == -1 && dytePluginFile.getData() != null) {
            ValueCallback<Uri[]> valueCallback = this.filePathCallback;
            if (valueCallback != null) {
                valueCallback.onReceiveValue((Object)WebChromeClient.FileChooserParams.parseResult((int)dytePluginFile.getResultCode(), (Intent)dytePluginFile.getData()));
            }
        } else {
            ValueCallback<Uri[]> valueCallback = this.filePathCallback;
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
        }
        this.filePathCallback = null;
    }

    public static final /* synthetic */ String access$getJsListenerScript$cp() {
        return jsListenerScript;
    }

    public static final /* synthetic */ void access$setFilePathCallback$p(DyteAndroidWebView $this, ValueCallback valueCallback) {
        $this.filePathCallback = valueCallback;
    }

    public static final /* synthetic */ IDyteWebViewListener access$getListener$p(DyteAndroidWebView $this) {
        return $this.listener;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/dyte/core/platform/DyteAndroidWebView$Companion;", "", "()V", "NAME_JS_INTERFACE", "", "jsListenerScript", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/dyte/core/platform/DyteAndroidWebView$WebViewInterface;", "", "()V", "interfaceListener", "Lio/dyte/core/platform/IDyteWebViewListener;", "postMessage", "", "messageJson", "", "removeInterfaceListener", "setInterfaceListener", "listener", "shared_debug"})
    private static final class WebViewInterface {
        @Nullable
        private IDyteWebViewListener interfaceListener;

        public final void setInterfaceListener(@NotNull IDyteWebViewListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.interfaceListener = listener;
        }

        public final void removeInterfaceListener() {
            this.interfaceListener = null;
        }

        @JavascriptInterface
        public final void postMessage(@NotNull String messageJson) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)messageJson, (String)"messageJson");
                IDyteWebViewListener iDyteWebViewListener = this.interfaceListener;
                if (iDyteWebViewListener == null) break block0;
                iDyteWebViewListener.onWebViewMessage(JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(messageJson)));
            }
        }
    }
}

