/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.socket;

import io.dyte.core.network.BaseApiService;
import io.dyte.core.socket.ISocketMessageResponseParser;
import io.dyte.core.socket.events.InboundMeetingEventType;
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel;
import io.dyte.core.socket.events.payloadmodel.InboundMeetingEvent;
import io.dyte.core.socket.events.payloadmodel.ResponseModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketActiveSpeakerModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketChatMessage;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketChatMessagesModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConnectTransportModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerClosedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketConsumerResumedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketEmptyModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketGetPageModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerLeftModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerMuteModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerPinnedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPluginDisabled;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPluginEnabled;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPluginEvent;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPollModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPollsModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketProducerClosedModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketProducerConnectModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketSelectedPeersModel;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWaitlistPeerAccepted;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWaitlistPeerAdded;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWaitlistPeerClosed;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWaitlistPeerRejected;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWebinarPresentRequestAccepted;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWebinarRequestToJoinPeerAdded;
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWebinarStagePeer;
import io.dyte.core.socket.events.payloadmodel.outbound.RouterCapabilitiesModel;
import io.dyte.core.socket.events.payloadmodel.outbound.WebRtcCreateTransportModel;
import io.dyte.core.socket.events.payloadmodel.outbound.WebSocketJoinRoomModel;
import io.dyte.core.socket.events.payloadmodel.outbound.WebSocketRoomStateModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/dyte/core/socket/SocketMessageResponseParser;", "Lio/dyte/core/socket/ISocketMessageResponseParser;", "()V", "jsonParser", "Lkotlinx/serialization/json/Json;", "getEventType", "Lio/dyte/core/socket/events/InboundMeetingEventType;", "type", "", "parsePayloadModel", "Lio/dyte/core/socket/events/payloadmodel/BasePayloadModel;", "eventType", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "parseResponse", "Lio/dyte/core/socket/events/payloadmodel/InboundMeetingEvent;", "response", "shared_debug"})
public final class SocketMessageResponseParser
implements ISocketMessageResponseParser {
    @NotNull
    private final Json jsonParser = BaseApiService.Companion.getJson();

    @Override
    @NotNull
    public InboundMeetingEvent parseResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ResponseModel responseModel = (ResponseModel)this.jsonParser.decodeFromString((DeserializationStrategy)ResponseModel.Companion.serializer(), response);
        String typeStr = responseModel.getType();
        JsonObject payloadObj = responseModel.getPayload();
        InboundMeetingEventType inboundMeetingEventType = this.getEventType(typeStr);
        if (inboundMeetingEventType == null) {
            throw new IllegalArgumentException("event type not supported " + typeStr);
        }
        InboundMeetingEventType eventType = inboundMeetingEventType;
        BasePayloadModel basePayloadModel = this.parsePayloadModel(eventType, payloadObj);
        if (basePayloadModel == null) {
            throw new IllegalArgumentException("payload object not supported " + payloadObj);
        }
        BasePayloadModel payloadModel = basePayloadModel;
        return new InboundMeetingEvent(eventType, payloadModel);
    }

    private final InboundMeetingEventType getEventType(String type) {
        if (type == null) {
            return null;
        }
        for (InboundMeetingEventType event : InboundMeetingEventType.values()) {
            if (!Intrinsics.areEqual((Object)event.getType(), (Object)type)) continue;
            return event;
        }
        return null;
    }

    private final BasePayloadModel parsePayloadModel(InboundMeetingEventType eventType, JsonObject jsonObject) {
        BasePayloadModel basePayloadModel;
        if (jsonObject == null) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
            case 1: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketRoomStateModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 2: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)RouterCapabilitiesModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 3: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebRtcCreateTransportModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 4: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketJoinRoomModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 5: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketMeetingPeerUser.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 6: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketSelectedPeersModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 7: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketConsumerModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 8: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketConnectTransportModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 9: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketProducerConnectModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 10: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPeerMuteModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 11: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPeerMuteModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 12: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketProducerClosedModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 13: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketConsumerResumedModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 14: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketConsumerClosedModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 15: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketConsumerClosedModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 16: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPeerLeftModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 17: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketChatMessage.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 18: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketChatMessagesModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 19: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPollsModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 20: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPollModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 21: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWaitlistPeerAdded.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 22: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWaitlistPeerAccepted.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 23: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWaitlistPeerRejected.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 24: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWaitlistPeerClosed.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 25: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketGetPageModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 26: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketActiveSpeakerModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 27: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPeerPinnedModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 28: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPluginEnabled.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 29: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketPluginDisabled.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 30: 
            case 31: {
                basePayloadModel = new WebSocketPluginEvent(jsonObject);
                break;
            }
            case 32: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWebinarPresentRequestAccepted.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 33: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWebinarStagePeer.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 34: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWebinarStagePeer.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 35: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketWebinarRequestToJoinPeerAdded.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                basePayloadModel = (BasePayloadModel)this.jsonParser.decodeFromJsonElement((DeserializationStrategy)WebSocketEmptyModel.Companion.serializer(), (JsonElement)jsonObject);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return basePayloadModel;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InboundMeetingEventType.values().length];
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ROOM_STATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ROUTER_CAPABILITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_CREATE_TRANSPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_JOIN_ROOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_JOINED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_SELECTED_PEERS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_NEW_CONSUMER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_CONNECT_TRANSPORT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PRODUCER_CONNECT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_MUTED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_UNMUTED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PRODUCER_CLOSED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_RESUME_CONSUMER.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_CLOSE_CONSUMER.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PAUSE_CONSUMER.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_LEFT.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ON_CHAT_MESSAGE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ON_CHAT_MESSAGES.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ON_POLLS.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ON_POLL.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_WAITLIST_PEER_ADDED.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_WAITLIST_PEER_ACCEPTED.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_WAITLIST_PEER_REJECTED.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_WAITLIST_PEER_CLOSED.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_GET_PAGE.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_ACTIVE_SPEAKER.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_PINNED.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PLUGIN_ENABLED.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PLUGIN_DISABLED.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PLUGIN_EVENT.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PLUGIN_DATA.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_REQUEST_TO_JOIN_STAGE_ACCEPTED.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_ADDED_TO_STAGE.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_REJECTED_TO_JOIN_STAGE.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_REQUEST_TO_JOIN_STAGE_PEER_ADDED.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_STARTED_PRESENTING.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_STOPPED_PRESENTING.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_STARTED_PRESENTING.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_STOPPED_PRESENTING.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_PEER_REMOVED_FROM_STAGE.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_MUTE_ALL_VIDEO.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_MUTE_ALL_AUDIO.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_NO_ACTIVE_SPEAKER.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_RECORDING_STARTED.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_RECORDING_STOPPED.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_KICKED.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_DISABLE_AUDIO.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InboundMeetingEventType.WEB_SOCKET_DISABLE_VIDEO.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

