/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.core.socket.socketservice;

import io.dyte.core.socket.socketservice.ResponseTimeoutException;
import io.dyte.core.socket.socketservice.SocketService;
import io.dyte.core.socket.socketservice.SocketServiceConnectionState;
import io.dyte.core.socket.socketservice.SocketServiceConnectionStateListener;
import io.dyte.core.socket.socketservice.SocketServiceEventListener;
import io.dyte.sockrates.client.ConnectFailureReason;
import io.dyte.sockrates.client.RequestResponseFailureReason;
import io.dyte.sockrates.client.SendFailureReason;
import io.dyte.sockrates.client.Sockrates;
import io.dyte.sockrates.client.SockratesConfiguration;
import io.dyte.sockrates.client.SockratesResult;
import io.dyte.sockrates.client.SockratesWSListener;
import io.dyte.sockrates.client.WebSocketConnectionState;
import io.dyte.sockrates.client.WebSocketMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import message.v1.SocketMessage;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0011\u0010\u0018\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J%\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J#\u0010'\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lio/dyte/core/socket/socketservice/DefaultSocketService;", "Lio/dyte/core/socket/socketservice/SocketService;", "baseUrl", "", "peerId", "roomName", "authToken", "workContext", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineDispatcher;)V", "activeEventListeners", "", "", "", "Lio/dyte/core/socket/socketservice/SocketServiceEventListener;", "connectionStateListeners", "Lio/dyte/core/socket/socketservice/SocketServiceConnectionStateListener;", "url", "wsClient", "Lio/dyte/sockrates/client/Sockrates;", "addConnectionStateListener", "", "listener", "clear", "connect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "notifyConnectionStateListeners", "connectionState", "Lio/dyte/core/socket/socketservice/SocketServiceConnectionState;", "notifyEventSubscribers", "socketMessage", "Lmessage/v1/SocketMessage;", "removeConnectionStateListener", "requestResponse", "", "event", "payload", "(I[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "subscribe", "unsubscribe", "Companion", "shared_debug"})
public final class DefaultSocketService
implements SocketService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String peerId;
    @NotNull
    private final CoroutineDispatcher workContext;
    @NotNull
    private final String url;
    @NotNull
    private final Sockrates wsClient;
    @NotNull
    private final Map<Integer, Set<SocketServiceEventListener>> activeEventListeners;
    @NotNull
    private final Set<SocketServiceConnectionStateListener> connectionStateListeners;
    @NotNull
    private static final char[] characterSet;

    public DefaultSocketService(@NotNull String baseUrl, @NotNull String peerId, @NotNull String roomName, @NotNull String authToken, @NotNull CoroutineDispatcher workContext) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.peerId = peerId;
        this.workContext = workContext;
        this.activeEventListeners = new HashMap();
        this.connectionStateListeners = new LinkedHashSet();
        this.url = DefaultSocketService.Companion.createSocketServiceUrl(baseUrl, this.peerId, roomName, authToken);
        this.wsClient = new Sockrates(this.url, new SockratesConfiguration(0L, 0L, 0, false, false, 23, null), null, 4, null);
    }

    public /* synthetic */ DefaultSocketService(String string, String string2, String string3, String string4, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        this(string, string2, string3, string4, coroutineDispatcher);
    }

    @Override
    @Nullable
    public Object connect(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.workContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SockratesResult<? extends Unit, ? extends ConnectFailureReason>>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultSocketService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultSocketService.access$getWsClient$p(this.this$0).connect(new SockratesWSListener(this.this$0){
                            final /* synthetic */ DefaultSocketService this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public void onConnectionStateChanged(@NotNull Sockrates client2, @NotNull WebSocketConnectionState newState) {
                                Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
                                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                                SockratesWSListener.DefaultImpls.onConnectionStateChanged((SockratesWSListener)this, (Sockrates)client2, (WebSocketConnectionState)newState);
                                try {
                                    SocketServiceConnectionState socketServiceConnectionState = SocketServiceConnectionState.Companion.createFromSockratesConnectionState(newState);
                                    DefaultSocketService.access$notifyConnectionStateListeners(this.this$0, socketServiceConnectionState);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }

                            public void onMessage(@NotNull Sockrates client2, @NotNull SocketMessage message) {
                                Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                SockratesWSListener.DefaultImpls.onMessage((SockratesWSListener)this, (Sockrates)client2, (SocketMessage)message);
                                DefaultSocketService.access$notifyEventSubscribers(this.this$0, message);
                            }

                            public void onMessage(@NotNull Sockrates client2, @NotNull WebSocketMessage message) {
                                SockratesWSListener.DefaultImpls.onMessage((SockratesWSListener)this, (Sockrates)client2, (WebSocketMessage)message);
                            }

                            public void onClose(@NotNull Sockrates client2, int code, @NotNull String reason) {
                                SockratesWSListener.DefaultImpls.onClose((SockratesWSListener)this, (Sockrates)client2, (int)code, (String)reason);
                            }

                            public void onError(@NotNull Sockrates client2, @NotNull Exception exception) {
                                SockratesWSListener.DefaultImpls.onError((SockratesWSListener)this, (Sockrates)client2, (Exception)exception);
                            }

                            public void onOpen(@NotNull Sockrates client2) {
                                SockratesWSListener.DefaultImpls.onOpen((SockratesWSListener)this, (Sockrates)client2);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SockratesResult<Unit, ? extends ConnectFailureReason>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object disconnect(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.workContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultSocketService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DefaultSocketService.access$getWsClient$p(this.this$0).disconnect((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        DefaultSocketService.access$clear(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object send(int event, @Nullable byte[] payload2, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.workContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SockratesResult<? extends Unit, ? extends SendFailureReason>>, Object>(this, event, payload2, null){
            int label;
            final /* synthetic */ DefaultSocketService this$0;
            final /* synthetic */ int $event;
            final /* synthetic */ byte[] $payload;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$payload = $payload;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String messageId = io.dyte.core.socket.socketservice.DefaultSocketService$Companion.access$generateMessageId(DefaultSocketService.Companion, DefaultSocketService.access$getPeerId$p(this.this$0));
                        this.label = 1;
                        Object object3 = DefaultSocketService.access$getWsClient$p(this.this$0).send(this.$event, messageId, this.$payload, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SockratesResult<Unit, ? extends SendFailureReason>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object requestResponse(int event, @Nullable byte[] payload2, @NotNull Continuation<? super byte[]> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.workContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, event, payload2, null){
            int label;
            final /* synthetic */ DefaultSocketService this$0;
            final /* synthetic */ int $event;
            final /* synthetic */ byte[] $payload;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$payload = $payload;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        messageId = io.dyte.core.socket.socketservice.DefaultSocketService$Companion.access$generateMessageId(DefaultSocketService.Companion, DefaultSocketService.access$getPeerId$p(this.this$0));
                        this.label = 1;
                        v0 = DefaultSocketService.access$getWsClient$p(this.this$0).requestResponse(this.$event, messageId, this.$payload, (Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if ((var4_5 = (result = (SockratesResult)v0)) instanceof SockratesResult.Success) {
                            v1 = ((SocketMessage)((SockratesResult.Success)result).getValue()).getPayload();
                            return (byte[])(v1 != null ? v1.toByteArray() : null);
                        }
                        if (var4_5 instanceof SockratesResult.Failure) {
                            reason = (RequestResponseFailureReason)((SockratesResult.Failure)result).getReason();
                            var6_7 = reason;
                            if (var6_7 instanceof RequestResponseFailureReason.ResponseTimeout) {
                                throw new ResponseTimeoutException("SocketService response timeout after " + ((RequestResponseFailureReason.ResponseTimeout)reason).getTimeoutInMillis() + "ms");
                            }
                            if (var6_7 instanceof RequestResponseFailureReason.SocketNotConnected) {
                                return null;
                            }
                            if (var6_7 instanceof RequestResponseFailureReason.Other) {
                                return null;
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    public void subscribe(int event, @NotNull SocketServiceEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<SocketServiceEventListener> existingEventListeners = this.activeEventListeners.get(event);
        if (existingEventListeners == null) {
            LinkedHashSet<SocketServiceEventListener> newEventListenersSet = new LinkedHashSet<SocketServiceEventListener>();
            newEventListenersSet.add(listener);
            Integer n = event;
            this.activeEventListeners.put(n, newEventListenersSet);
        } else {
            existingEventListeners.add(listener);
        }
    }

    @Override
    public void unsubscribe(int event, @NotNull SocketServiceEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<SocketServiceEventListener> existingEventListeners = this.activeEventListeners.get(event);
        if (existingEventListeners != null) {
            existingEventListeners.remove(listener);
        }
    }

    @Override
    public void addConnectionStateListener(@NotNull SocketServiceConnectionStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.connectionStateListeners.add(listener);
    }

    @Override
    public void removeConnectionStateListener(@NotNull SocketServiceConnectionStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.connectionStateListeners.remove(listener);
    }

    private final void notifyEventSubscribers(SocketMessage socketMessage) {
        if (this.activeEventListeners.isEmpty()) {
            return;
        }
        Set<SocketServiceEventListener> eventListeners = this.activeEventListeners.get(socketMessage.getEvent());
        if (eventListeners != null && !((Collection)eventListeners).isEmpty()) {
            for (SocketServiceEventListener listener : eventListeners) {
                ByteString byteString = socketMessage.getPayload();
                listener.onEvent(socketMessage.getEvent(), (byte[])(byteString != null ? byteString.toByteArray() : null));
            }
        }
    }

    private final void notifyConnectionStateListeners(SocketServiceConnectionState connectionState) {
        Iterable $this$forEach$iv = this.connectionStateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SocketServiceConnectionStateListener it = (SocketServiceConnectionStateListener)element$iv;
            boolean bl = false;
            it.onConnectionStateChanged(connectionState);
        }
    }

    private final void clear() {
        this.activeEventListeners.clear();
        this.connectionStateListeners.clear();
    }

    public static final /* synthetic */ Sockrates access$getWsClient$p(DefaultSocketService $this) {
        return $this.wsClient;
    }

    public static final /* synthetic */ void access$notifyConnectionStateListeners(DefaultSocketService $this, SocketServiceConnectionState connectionState) {
        $this.notifyConnectionStateListeners(connectionState);
    }

    public static final /* synthetic */ void access$notifyEventSubscribers(DefaultSocketService $this, SocketMessage socketMessage) {
        $this.notifyEventSubscribers(socketMessage);
    }

    public static final /* synthetic */ void access$clear(DefaultSocketService $this) {
        $this.clear();
    }

    public static final /* synthetic */ String access$getPeerId$p(DefaultSocketService $this) {
        return $this.peerId;
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        characterSet = cArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/dyte/core/socket/socketservice/DefaultSocketService$Companion;", "", "()V", "characterSet", "", "createSocketServiceUrl", "", "baseUrl", "peerId", "roomName", "authToken", "generateMessageId", "generateRandomString", "idLength", "", "shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final String createSocketServiceUrl(String baseUrl, String peerId, String roomName, String authToken) {
            return baseUrl + "/ws?roomID=" + roomName + "&peerID=" + peerId + "&authToken=" + authToken;
        }

        private final String generateMessageId(String peerId) {
            String randomSuffix = this.generateRandomString(5);
            return peerId + '-' + randomSuffix;
        }

        private final String generateRandomString(int idLength) {
            StringBuilder idBuilder = new StringBuilder();
            int randomIndex = 0;
            for (int i = 0; i < idLength; ++i) {
                randomIndex = Random.Default.nextInt(characterSet.length);
                idBuilder.append(characterSet[randomIndex]);
            }
            String string = idBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idBuilder.toString()");
            return string;
        }

        static /* synthetic */ String generateRandomString$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 5;
            }
            return companion.generateRandomString(n);
        }

        public static final /* synthetic */ String access$generateMessageId(Companion $this, String peerId) {
            return $this.generateMessageId(peerId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

