/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.decorators;

import org.boon.cache.Cache;
import org.boon.cache.CacheType;
import org.boon.cache.SimpleConcurrentCache;
import org.boon.criteria.ObjectFilter;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Group;
import org.boon.datarepo.Filter;
import org.boon.datarepo.ResultSet;
import org.boon.datarepo.impl.decorators.FilterDecoratorBase;

public class FilterWithSimpleCache
extends FilterDecoratorBase {
    private Cache<Criteria, ResultSet> fifoCache = new SimpleConcurrentCache<Criteria, ResultSet>(50, false, CacheType.FIFO);
    private Cache<Criteria, ResultSet> lruCache = new SimpleConcurrentCache<Criteria, ResultSet>(1000, false, CacheType.LRU);

    @Override
    public ResultSet filter(Criteria ... expressions) {
        Group and = ObjectFilter.and(expressions);
        ResultSet results = this.fifoCache.get(and);
        if (results == null && (results = this.lruCache.get(and)) != null) {
            this.fifoCache.put(and, results);
            return results;
        }
        results = super.filter(expressions);
        this.fifoCache.put(and, results);
        this.lruCache.put(and, results);
        return results;
    }

    @Override
    public void invalidate() {
        this.fifoCache = new SimpleConcurrentCache<Criteria, ResultSet>(50, false, CacheType.FIFO);
        this.lruCache = new SimpleConcurrentCache<Criteria, ResultSet>(1000, false, CacheType.LRU);
        super.invalidate();
    }

    public FilterWithSimpleCache(Filter delegate) {
        super(delegate);
    }
}

