/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.boon.core.reflection.Mapper;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.json.JsonMappingParser;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserEvents;
import org.boon.json.implementation.BaseJsonParserAndMapper;
import org.boon.json.implementation.JsonAsciiParser;
import org.boon.json.implementation.JsonFastParser;
import org.boon.json.implementation.JsonParserCharArray;
import org.boon.json.implementation.JsonParserLax;
import org.boon.json.implementation.JsonParserUsingCharacterSource;
import org.boon.json.implementation.JsonUTF8Parser;
import org.boon.json.implementation.PlistParser;

public class JsonParserFactory {
    private Charset charset = StandardCharsets.UTF_8;
    private boolean lax;
    private boolean chop = false;
    private boolean lazyChop = true;
    private FieldAccessMode fieldAccessType = FieldAccessMode.FIELD;
    private boolean useAnnotations;
    private boolean caseInsensitiveFields;
    private Set<String> ignoreSet;
    private String view;
    private boolean respectIgnore;
    private boolean acceptSingleValueAsArray;

    public FieldAccessMode getFieldAccessType() {
        return this.fieldAccessType;
    }

    public boolean isChop() {
        return this.chop;
    }

    public JsonParserFactory setChop(boolean chop) {
        this.chop = chop;
        return this;
    }

    public boolean isLazyChop() {
        return this.lazyChop;
    }

    public JsonParserFactory setLazyChop(boolean lazyChop) {
        this.lazyChop = lazyChop;
        return this;
    }

    public JsonParserFactory lax() {
        this.lax = true;
        return this;
    }

    public JsonParserFactory strict() {
        this.lax = false;
        return this;
    }

    public JsonParserFactory setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JsonParserAndMapper createFastParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonFastParser(false, this.chop, this.lazyChop), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createFastObjectMapperParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonFastParser(true), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createUTF8DirectByteParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonUTF8Parser(), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(StandardCharsets.UTF_8);
        return jsonParser;
    }

    public JsonParserAndMapper createASCIIParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonAsciiParser(), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(StandardCharsets.US_ASCII);
        return jsonParser;
    }

    public JsonParserAndMapper createLaxParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserLax(false, this.chop, this.lazyChop), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createParserWithEvents(JsonParserEvents events) {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserLax(false, this.chop, this.lazyChop, false, events), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createCharacterSourceParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserUsingCharacterSource(), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createJsonCharArrayParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserCharArray(), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createPlistParser() {
        if (this.charset == null) {
            this.charset = StandardCharsets.US_ASCII;
        }
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new PlistParser(false, this.chop, this.lazyChop), new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray));
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createLazyFinalParser() {
        return this.createFastParser();
    }

    public JsonParserAndMapper createJsonParserForJsonPath() {
        return this.createFastParser();
    }

    public JsonParserAndMapper create() {
        if (this.charset == null) {
            this.charset = StandardCharsets.UTF_8;
        }
        return new JsonMappingParser(new Mapper(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray), this.charset, this.lax, this.chop, this.lazyChop);
    }

    public boolean isUsePropertiesFirst() {
        return this.fieldAccessType == FieldAccessMode.PROPERTY_THEN_FIELD;
    }

    public JsonParserFactory usePropertiesFirst() {
        this.fieldAccessType = FieldAccessMode.PROPERTY_THEN_FIELD;
        return this;
    }

    public boolean isUseFieldsFirst() {
        return this.fieldAccessType == FieldAccessMode.FIELD_THEN_PROPERTY;
    }

    public JsonParserFactory useFieldsFirst() {
        this.fieldAccessType = FieldAccessMode.FIELD_THEN_PROPERTY;
        return this;
    }

    public JsonParserFactory useFieldsOnly() {
        this.fieldAccessType = FieldAccessMode.FIELD;
        return this;
    }

    public JsonParserFactory usePropertyOnly() {
        this.fieldAccessType = FieldAccessMode.PROPERTY;
        return this;
    }

    public JsonParserFactory useAnnotations() {
        this.useAnnotations = true;
        return this;
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public JsonParserFactory setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
        return this;
    }

    public JsonParserFactory caseInsensitiveFields() {
        this.caseInsensitiveFields = true;
        return this;
    }

    public boolean isCaseInsensitiveFields() {
        return this.caseInsensitiveFields;
    }

    public JsonParserFactory setCaseInsensitiveFields(boolean caseInsensitiveFields) {
        this.caseInsensitiveFields = caseInsensitiveFields;
        return this;
    }

    public Set<String> getIgnoreSet() {
        return this.ignoreSet;
    }

    public JsonParserFactory setIgnoreSet(Set<String> ignoreSet) {
        this.ignoreSet = ignoreSet;
        return this;
    }

    public String getView() {
        return this.view;
    }

    public JsonParserFactory setView(String view) {
        this.view = view;
        return this;
    }

    public boolean isRespectIgnore() {
        return this.respectIgnore;
    }

    public JsonParserFactory setRespectIgnore(boolean respectIgnore) {
        this.respectIgnore = respectIgnore;
        return this;
    }

    public JsonParserFactory acceptSingleValueAsArray() {
        this.acceptSingleValueAsArray = true;
        return this;
    }

    public boolean isAcceptSingleValueAsArray() {
        return this.acceptSingleValueAsArray;
    }

    public JsonParserFactory setAcceptSingleValueAsArray(boolean acceptSingleValueAsArray) {
        this.acceptSingleValueAsArray = acceptSingleValueAsArray;
        return this;
    }
}

