/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.boon.IO;
import org.boon.collections.LazyMap;
import org.boon.core.Typ;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.json.JsonException;
import org.boon.json.implementation.BaseJsonParser;
import org.boon.primitive.Byt;
import org.boon.primitive.ByteScanner;
import org.boon.primitive.CharBuf;
import org.boon.primitive.InMemoryInputStream;

public abstract class JsonBaseByteArrayParser
extends BaseJsonParser {
    protected byte[] charArray;
    protected int __index;
    protected int __currentChar;
    protected static final int NEW_LINE = 10;
    protected static final int RETURN = 13;
    protected static final int SPACE = 32;
    protected static final int TAB = 9;
    protected static final int BELL = 8;
    protected static final int FORM_FEED = 12;
    protected static final int COLON = 58;
    protected static final int OPEN_CURLY = 123;
    protected static final int OPEN_BRACKET = 91;
    protected static final int LETTER_N = 110;
    protected static final int LETTER_U = 117;
    protected static final int LETTER_L = 108;
    protected static final int LETTER_T = 116;
    protected static final int LETTER_R = 114;
    protected static final int LETTER_F = 102;
    protected static final int LETTER_A = 97;
    protected static final int LETTER_S = 115;
    protected final CharBuf builder = CharBuf.create(20);
    protected int lastIndex;
    int[] endIndex = new int[1];
    protected static final byte[] NULL = Byt.bytes("null");
    protected static final byte[] TRUE = Byt.bytes("true");
    protected static final byte[] FALSE = Byt.bytes("false");

    protected final boolean hasMore() {
        return this.__index < this.lastIndex;
    }

    protected final boolean hasCurrent() {
        return this.__index <= this.lastIndex;
    }

    protected final void skipWhiteSpaceIfNeeded() {
        int ix = this.__index;
        if (this.hasCurrent()) {
            this.__currentChar = this.charArray[ix];
        }
        if (this.__currentChar <= 32) {
            ix = ByteScanner.skipWhiteSpaceFast(this.charArray, ix);
            this.__currentChar = this.charArray[ix];
            this.__index = ix;
        }
    }

    protected final int nextChar() {
        try {
            if (this.hasMore()) {
                ++this.__index;
                this.__currentChar = this.charArray[this.__index];
                return this.__currentChar;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new JsonException(this.exceptionDetails("unable to advance character"), ex);
        }
    }

    protected String exceptionDetails(String message) {
        return ByteScanner.errorDetails(message, this.charArray, this.__index, this.__currentChar);
    }

    private static int skipWhiteSpaceFastBytes(byte[] array, int index) {
        while (index < array.length) {
            byte c = array[index];
            if (c > 32) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    protected final void skipWhiteSpace() {
        this.__index = JsonBaseByteArrayParser.skipWhiteSpaceFastBytes(this.charArray, this.__index);
        this.__currentChar = this.charArray[this.__index];
    }

    private Object decode(byte[] cs) {
        this.lastIndex = cs.length - 1;
        this.charArray = cs;
        this.__index = 0;
        return this.decodeValue();
    }

    public <T> T parse(Class<T> type, String str) {
        return this.parse(type, str.getBytes(this.charset));
    }

    public <T> T parse(Class<T> type, byte[] bytes) {
        if (type == Map.class || type == List.class || Typ.isBasicType(type)) {
            return (T)this.decode(bytes);
        }
        Map objectMap = (Map)this.decode(bytes);
        return MapObjectConversion.fromMap(objectMap, type);
    }

    @Override
    public Object parse(byte[] bytes) {
        return this.decode(bytes);
    }

    public <T> T parse(Class<T> type, InputStream input) {
        return this.parse(type, IO.input(input));
    }

    public <T> T parse(Class<T> type, CharSequence charSequence) {
        return this.parse(type, charSequence.toString());
    }

    public <T> T parse(Class<T> type, char[] chars) {
        return this.parse(type, new String(chars));
    }

    protected void complain(String complaint) {
        throw new JsonException(this.exceptionDetails(complaint));
    }

    protected final Object decodeJsonObject() {
        if (this.__currentChar == 123) {
            ++this.__index;
        }
        LazyMap map = new LazyMap();
        while (this.__index < this.charArray.length) {
            this.skipWhiteSpaceIfNeeded();
            if (this.__currentChar == 34) {
                String key = this.decodeString();
                if (internKeys) {
                    String keyPrime = (String)internedKeysCache.get(key);
                    if (keyPrime == null) {
                        key = key.intern();
                        internedKeysCache.put(key, key);
                    } else {
                        key = keyPrime;
                    }
                }
                this.skipWhiteSpaceIfNeeded();
                if (this.__currentChar != 58) {
                    this.complain("expecting current character to be " + this.charDescription(this.__currentChar) + "\n");
                }
                ++this.__index;
                this.skipWhiteSpaceIfNeeded();
                Object value = this.decodeValue();
                this.skipWhiteSpaceIfNeeded();
                map.put(key, value);
            }
            if (this.__currentChar == 125) {
                ++this.__index;
                break;
            }
            if (this.__currentChar != 44) {
                this.complain("expecting '}' or ',' but got current char " + this.charDescription(this.__currentChar));
            }
            ++this.__index;
        }
        return map;
    }

    protected final Object decodeValue() {
        Object value = null;
        block12: while (this.__index < this.charArray.length) {
            this.__currentChar = this.charArray[this.__index];
            switch (this.__currentChar) {
                case 10: {
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 32: {
                    break;
                }
                case 34: {
                    value = this.decodeString();
                    break block12;
                }
                case 116: {
                    value = this.decodeTrue();
                    break block12;
                }
                case 102: {
                    value = this.decodeFalse();
                    break block12;
                }
                case 110: {
                    value = this.decodeNull();
                    break block12;
                }
                case 91: {
                    value = this.decodeJsonArray();
                    break block12;
                }
                case 123: {
                    value = this.decodeJsonObject();
                    break block12;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    value = this.decodeNumber();
                    break block12;
                }
                case 45: {
                    value = this.decodeNumber();
                    break block12;
                }
                default: {
                    throw new JsonException(this.exceptionDetails("Unable to determine the current character, it is not a string, number, array, or object"));
                }
            }
            ++this.__index;
        }
        return value;
    }

    private final Object decodeNumber() {
        Number num = ByteScanner.parseJsonNumber(this.charArray, this.__index, this.charArray.length, this.endIndex);
        this.__index = this.endIndex[0];
        return num;
    }

    protected final Object decodeNull() {
        if (this.__index + NULL.length <= this.charArray.length && this.charArray[this.__index] == 110 && this.charArray[++this.__index] == 117 && this.charArray[++this.__index] == 108 && this.charArray[++this.__index] == 108) {
            this.nextChar();
            return null;
        }
        throw new JsonException(this.exceptionDetails("null not parsed properly"));
    }

    protected final boolean decodeTrue() {
        if (this.__index + TRUE.length <= this.charArray.length && this.charArray[this.__index] == 116 && this.charArray[++this.__index] == 114 && this.charArray[++this.__index] == 117 && this.charArray[++this.__index] == 101) {
            this.nextChar();
            return true;
        }
        throw new JsonException(this.exceptionDetails("true not parsed properly"));
    }

    protected final boolean decodeFalse() {
        if (this.__index + FALSE.length <= this.charArray.length && this.charArray[this.__index] == 102 && this.charArray[++this.__index] == 97 && this.charArray[++this.__index] == 108 && this.charArray[++this.__index] == 115 && this.charArray[++this.__index] == 101) {
            this.nextChar();
            return false;
        }
        throw new JsonException(this.exceptionDetails("false not parsed properly"));
    }

    protected abstract String decodeString();

    protected final List decodeJsonArray() {
        boolean foundEnd;
        ArrayList<Object> list;
        block12: {
            list = null;
            foundEnd = false;
            byte[] charArray = this.charArray;
            try {
                if (this.__currentChar == 91) {
                    ++this.__index;
                }
                this.skipWhiteSpaceIfNeeded();
                if (this.__currentChar == 93) {
                    ++this.__index;
                    return Collections.EMPTY_LIST;
                }
                list = new ArrayList<Object>();
                block2: while (this.hasMore()) {
                    byte c;
                    Object arrayItem = this.decodeValue();
                    list.add(arrayItem);
                    while (true) {
                        if ((c = charArray[this.__index]) == 44) {
                            ++this.__index;
                            continue block2;
                        }
                        if (c == 93) {
                            foundEnd = true;
                            ++this.__index;
                            break block12;
                        }
                        if (c > 32) break;
                        ++this.__index;
                    }
                    c = charArray[this.__index];
                    if (c == 44) {
                        ++this.__index;
                        continue;
                    }
                    if (c == 93) {
                        ++this.__index;
                        foundEnd = true;
                        break;
                    }
                    String charString = this.charDescription(c);
                    this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array index of %s \n", charString, list.size()));
                }
            }
            catch (Exception ex) {
                if (ex instanceof JsonException) {
                    JsonException jsonException = (JsonException)ex;
                    throw jsonException;
                }
                throw new JsonException(this.exceptionDetails("issue parsing JSON array"), ex);
            }
        }
        if (!foundEnd) {
            this.complain("Did not find end of Json Array");
        }
        return list;
    }

    protected final List decodeJsonArrayOLD() {
        if (this.__currentChar == 91) {
            this.nextChar();
        }
        this.skipWhiteSpace();
        if (this.__currentChar == 93) {
            this.nextChar();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean foundEnd = false;
        int arrayIndex = 0;
        try {
            while (this.hasMore()) {
                this.skipWhiteSpace();
                Object arrayItem = this.decodeValue();
                list.add(arrayItem);
                ++arrayIndex;
                this.__currentChar = this.charArray[this.__index];
                if (this.__currentChar == 44) {
                    this.nextChar();
                    continue;
                }
                if (this.__currentChar == 93) {
                    this.nextChar();
                    foundEnd = true;
                    break;
                }
                this.skipWhiteSpace();
                if (this.__currentChar == 44) {
                    this.nextChar();
                    continue;
                }
                if (this.__currentChar == 93) {
                    this.nextChar();
                    foundEnd = true;
                    break;
                }
                String charString = this.charDescription(this.__currentChar);
                this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array index of %s \n", charString, arrayIndex));
            }
        }
        catch (Exception ex) {
            throw new JsonException(this.exceptionDetails(ex.getMessage()), ex);
        }
        if (!foundEnd) {
            this.complain("No end bracket found for JSON Array");
        }
        return list;
    }

    public <T> T parseDirect(Class<T> type, byte[] value) {
        return this.parse(type, value);
    }

    public <T> T parseAsStream(Class<T> type, byte[] value) {
        return this.parse(type, new InMemoryInputStream(value));
    }

    public <T> T parse(Class<T> type, byte[] bytes, Charset charset) {
        return this.parse(type, bytes);
    }

    public <T> T parseFile(Class<T> type, String fileName) {
        return this.parse(type, IO.input(fileName));
    }

    @Override
    public Object parse(char[] chars) {
        return this.parse(new String(chars));
    }

    @Override
    public Object parse(String string) {
        return this.parse(string.getBytes(this.charset));
    }

    @Override
    public Object parse(byte[] bytes, Charset charset) {
        return this.parse(bytes);
    }
}

