/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.reflection.Invoker;

public class Lng {
    public static String str(long value) {
        return String.format("%,d", value);
    }

    public static long[] grow(long[] array, int size) {
        Exceptions.requireNonNull(array);
        long[] newArray = new long[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static long[] grow(long[] array) {
        Exceptions.requireNonNull(array);
        long[] newArray = new long[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static long[] shrink(long[] array, int size) {
        Exceptions.requireNonNull(array);
        long[] newArray = new long[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static long[] compact(long[] array) {
        Exceptions.requireNonNull(array);
        int nullCount = 0;
        for (long ch : array) {
            if (ch != 0L) continue;
            ++nullCount;
        }
        long[] newArray = new long[array.length - nullCount];
        int j = 0;
        for (long ch : array) {
            if (ch == 0L) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static long[] arrayOfLong(int size) {
        return new long[size];
    }

    @Universal
    public static long[] array(long ... array) {
        Exceptions.requireNonNull(array);
        return array;
    }

    @Universal
    public static int len(long[] array) {
        return array.length;
    }

    @Universal
    public static int lengthOf(long[] array) {
        return array.length;
    }

    @Universal
    public static long idx(long[] array, int index) {
        int i = Lng.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static long atIndex(long[] array, int index) {
        int i = Lng.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(long[] array, int index, long value) {
        int i = Lng.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static void atIndex(long[] array, int index, long value) {
        int i = Lng.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static long[] slc(long[] array, int startIndex, int endIndex) {
        int start = Lng.calculateIndex(array, startIndex);
        int end = Lng.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] sliceOf(long[] array, int startIndex, int endIndex) {
        int start = Lng.calculateIndex(array, startIndex);
        int end = Lng.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] slc(long[] array, int startIndex) {
        int start = Lng.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] sliceOf(long[] array, int startIndex) {
        int start = Lng.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] slcEnd(long[] array, int endIndex) {
        int end = Lng.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static long[] endSliceOf(long[] array, int endIndex) {
        int end = Lng.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        long[] newArray = new long[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(long value, long[] array) {
        for (long currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static long[] copy(long[] array) {
        Exceptions.requireNonNull(array);
        long[] newArray = new long[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static long[] add(long[] array, long v) {
        Exceptions.requireNonNull(array);
        long[] newArray = new long[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static long[] add(long[] array, long[] array2) {
        Exceptions.requireNonNull(array);
        long[] newArray = new long[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static long[] insert(long[] array, int idx, long v) {
        Exceptions.requireNonNull(array);
        if (idx >= array.length) {
            return Lng.add(array, v);
        }
        int index = Lng.calculateIndex(array, idx);
        long[] newArray = new long[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static long[] insert(long[] array, int fromIndex, long[] values) {
        Exceptions.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Lng.add(array, values);
        }
        int index = Lng.calculateIndex(array, fromIndex);
        long[] newArray = new long[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(long[] array, int originalIndex) {
        int length = array.length;
        Exceptions.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private static int calculateEndIndex(long[] array, int originalIndex) {
        int length = array.length;
        Exceptions.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static long reduceBy(long[] array, ReduceBy reduceBy) {
        long sum = 0L;
        for (long v : array) {
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static long reduceBy(long[] array, int start, int length, ReduceBy reduceBy) {
        long sum = 0L;
        for (int index = start; index < length; ++index) {
            long v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static long reduceBy(long[] array, int length, ReduceBy reduceBy) {
        long sum = 0L;
        for (int index = 0; index < length; ++index) {
            long v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static <T> long reduceBy(long[] array, T object) {
        if (object.getClass().isAnonymousClass()) {
            return Lng.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (long v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Lng.reduceByR(array, object);
        }
    }

    public static <T> long reduceBy(long[] array, T object, String methodName) {
        if (object.getClass().isAnonymousClass()) {
            return Lng.reduceByR(array, object, methodName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object, methodName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (long v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Lng.reduceByR(array, object, methodName);
        }
    }

    private static <T> long reduceByR(long[] array, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            long sum = 0L;
            for (long v : array) {
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    private static <T> long reduceByR(long[] array, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            long sum = 0L;
            for (long v : array) {
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    private static <T> long reduceByR(long[] array, int length, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            long sum = 0L;
            for (int index = 0; index < length; ++index) {
                long v = array[index];
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    private static <T> long reduceByR(long[] array, int length, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            long sum = 0L;
            for (int index = 0; index < length; ++index) {
                long v = array[index];
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    public static long reduceBy(long[] array, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Lng.reduceByR(array, length, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int index = 0; index < length; ++index) {
                    long v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Lng.reduceByR(array, length, object);
        }
    }

    public static long reduceBy(long[] array, int length, Object function, String functionName) {
        if (function.getClass().isAnonymousClass()) {
            return Lng.reduceByR(array, length, function, functionName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(function, functionName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int index = 0; index < length; ++index) {
                    long v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Lng.reduceByR(array, length, function, functionName);
        }
    }

    public static long reduceBy(long[] array, int start, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Lng.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int index = start; index < length; ++index) {
                    long v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Lng.reduceByR(array, object);
        }
    }

    public static boolean equalsOrDie(long expected, long got) {
        if (expected != got) {
            return Exceptions.die(Boolean.class, "Expected was", expected, "but we got ", got);
        }
        return true;
    }

    public static boolean equals(long expected, long got) {
        return expected == got;
    }

    public static long sum(long[] values) {
        return Lng.sum(values, 0, values.length);
    }

    public static long sum(long[] values, int length) {
        return Lng.sum(values, 0, length);
    }

    public static long sum(long[] values, int start, int length) {
        long sum = 0L;
        for (int index = start; index < length; ++index) {
            sum += values[index];
        }
        return sum;
    }

    public static long max(long[] values, int start, int length) {
        long max = Long.MIN_VALUE;
        for (int index = start; index < length; ++index) {
            if (values[index] <= max) continue;
            max = values[index];
        }
        return max;
    }

    public static long max(long[] values) {
        return Lng.max(values, 0, values.length);
    }

    public static long max(long[] values, int length) {
        return Lng.max(values, 0, length);
    }

    public static long min(long[] values, int start, int length) {
        long min = Long.MAX_VALUE;
        for (int index = start; index < length; ++index) {
            if (values[index] >= min) continue;
            min = values[index];
        }
        return min;
    }

    public static long min(long[] values) {
        return Lng.min(values, 0, values.length);
    }

    public static long min(long[] values, int length) {
        return Lng.min(values, 0, length);
    }

    public static long mean(long[] values, int start, int length) {
        return Math.round(Lng.meanDouble(values, start, length));
    }

    public static long mean(long[] values, int length) {
        return Math.round(Lng.meanDouble(values, 0, length));
    }

    public static long mean(long[] values) {
        return Math.round(Lng.meanDouble(values, 0, values.length));
    }

    public static long variance(long[] values, int start, int length) {
        return Math.round(Lng.varianceDouble(values, start, length));
    }

    public static double meanDouble(long[] values, int start, int length) {
        double mean = (double)Lng.sum(values, start, length) / (double)length;
        return mean;
    }

    public static double varianceDouble(long[] values, int start, int length) {
        double mean = Lng.meanDouble(values, start, length);
        double temp = 0.0;
        for (int index = start; index < length; ++index) {
            double a = values[index];
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)length;
    }

    public static long variance(long[] values, int length) {
        return Math.round(Lng.varianceDouble(values, 0, length));
    }

    public static long variance(long[] values) {
        return Math.round(Lng.varianceDouble(values, 0, values.length));
    }

    public static long standardDeviation(long[] values, int start, int length) {
        double variance = Lng.varianceDouble(values, start, length);
        return (int)Math.round(Math.sqrt(variance));
    }

    public static long standardDeviation(long[] values, int length) {
        double variance = Lng.varianceDouble(values, 0, length);
        return Math.round(Math.sqrt(variance));
    }

    public static int standardDeviation(long[] values) {
        double variance = Lng.varianceDouble(values, 0, values.length);
        return (int)Math.round(Math.sqrt(variance));
    }

    public static long median(long[] values, int start, int length) {
        long[] sorted = new long[length];
        System.arraycopy(values, start, sorted, 0, length);
        Arrays.sort(sorted);
        if (length % 2 == 0) {
            int middle = sorted.length / 2;
            double median = (double)(sorted[middle - 1] + sorted[middle]) / 2.0;
            return Math.round(median);
        }
        return sorted[sorted.length / 2];
    }

    public static long median(long[] values, int length) {
        return Lng.median(values, 0, length);
    }

    public static long median(long[] values) {
        return Lng.median(values, 0, values.length);
    }

    public static boolean equalsOrDie(long[] expected, long[] got) {
        if (expected.length != got.length) {
            Exceptions.die("Lengths did not match, expected length", expected.length, "but got", got.length);
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            Exceptions.die("value at index did not match index", index, "expected value", expected[index], "but got", got[index]);
        }
        return true;
    }

    public static boolean equals(long[] expected, long[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int start, int end, long[] expected, long[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = start; index < end; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (long element : array) {
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    public static int hashCode(int start, int end, long[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = start; index < end; ++index) {
            long element = array[index];
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    public static interface ReduceBy {
        public long reduce(long var1, long var3);
    }
}

