/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.readers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.boon.validation.ValidatorMetaData;
import org.boon.validation.ValidatorMetaDataReader;

public class PropertiesFileValidatorMetaDataReader
implements ValidatorMetaDataReader {
    private Map<String, Properties> metaDataPropsCache = new HashMap<String, Properties>();
    private Map<String, List<ValidatorMetaData>> metaDataCache = new HashMap<String, List<ValidatorMetaData>>();

    @Override
    public List<ValidatorMetaData> readMetaData(Class<?> clazz, String propertyName) {
        Properties props = this.loadMetaDataPropsFile(clazz);
        String unparsedString = props.getProperty(propertyName);
        return this.extractMetaDataFromString(clazz, propertyName, unparsedString);
    }

    private Properties loadMetaDataPropsFile(Class<?> clazzWhoseValidationMetaDataWeAreReading) {
        String className = clazzWhoseValidationMetaDataWeAreReading.getName();
        String[] sourceParts = (className = className.split("[$]")[0]).split("[.]");
        String resourceName = sourceParts[sourceParts.length - 1] + ".properties";
        Properties validationMetaDataProps = this.metaDataPropsCache.get(resourceName);
        if (validationMetaDataProps == null) {
            validationMetaDataProps = new Properties();
            try {
                validationMetaDataProps.load(this.getClass().getClassLoader().getResourceAsStream(resourceName));
            }
            catch (IOException ioex) {
                // empty catch block
            }
            this.metaDataPropsCache.put(resourceName, validationMetaDataProps);
        }
        assert (validationMetaDataProps != null) : "Properties for validation meta-data were loaded";
        return validationMetaDataProps;
    }

    private List<ValidatorMetaData> extractMetaDataFromString(Class<?> clazz, String propertyName, String unparsedString) {
        String propertyKey = clazz.getName() + "." + propertyName;
        List<ValidatorMetaData> validatorMetaDataList = this.metaDataCache.get(propertyKey);
        if (validatorMetaDataList == null) {
            String[] validatorsParts;
            validatorMetaDataList = new ArrayList<ValidatorMetaData>();
            for (String validatorString : validatorsParts = unparsedString.split("[;]")) {
                ValidatorMetaData validatorMetaData = new ValidatorMetaData();
                validatorMetaDataList.add(validatorMetaData);
                String[] parts = validatorString.trim().split("[ ,]");
                validatorMetaData.setName(parts[0]);
                if (parts.length <= 1) continue;
                List<String> values = Arrays.asList(parts).subList(1, parts.length);
                for (String value : values) {
                    if (value.indexOf("=") == -1) continue;
                    String[] valueParts = value.split("[=]");
                    validatorMetaData.getProperties().put(valueParts[0], valueParts[1]);
                }
            }
            this.metaDataCache.put(propertyKey, validatorMetaDataList);
        }
        return validatorMetaDataList;
    }
}

