/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.CapabilitiesFactory;
import io.fluentlenium.configuration.CapabilitiesRegistry;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.DesiredCapabilities;

class CapabilitiesConfigurationPropertyRetriever {
    private final Json jsonConverter = new Json();

    CapabilitiesConfigurationPropertyRetriever() {
    }

    Capabilities getCapabilitiesProperty(String capabilities, ConfigurationProperties globalConfiguration) {
        String property = this.readCapabilitiesFromUrl(capabilities);
        return Optional.ofNullable(this.createCapabilitiesFromFactory(property, globalConfiguration)).orElseGet(() -> this.convertJsonObjectToCapabilities(property));
    }

    private String readCapabilitiesFromUrl(String property) {
        try {
            URL url = this.newURL(property);
            try {
                property = IOUtils.toString((URL)url, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new ConfigurationException("Can't read Capabilities defined at " + String.valueOf(url), e);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return property;
    }

    private URL newURL(String url) throws MalformedURLException {
        return new URL(url);
    }

    private Capabilities createCapabilitiesFromFactory(String property, ConfigurationProperties globalConfiguration) {
        CapabilitiesFactory factory = CapabilitiesRegistry.INSTANCE.get(property);
        if (factory != null) {
            return factory.newCapabilities(globalConfiguration);
        }
        return null;
    }

    private Capabilities convertJsonObjectToCapabilities(String property) {
        try {
            return (Capabilities)this.jsonConverter.toType(property, DesiredCapabilities.class);
        }
        catch (JsonException e) {
            throw new ConfigurationException("Can't convert JSON Capabilities to Object.", e);
        }
    }
}

