/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.action;

import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.proxy.LocatorProxies;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class KeyboardElementActions {
    private final WebDriver driver;
    private final WebElement element;
    private Actions actions;

    public KeyboardElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public KeyboardElementActions(WebDriver driver, FluentWebElement fluentWebElement) {
        this(driver, fluentWebElement.getElement());
    }

    public KeyboardElementActions(WebDriver driver, WebElement element, Actions actions) {
        this.driver = driver;
        this.element = element;
        this.actions = actions;
    }

    public KeyboardElementActions(WebDriver driver, FluentWebElement fluentWebElement, Actions actions) {
        this(driver, fluentWebElement.getElement(), actions);
    }

    protected Actions actions() {
        if (this.actions == null) {
            this.actions = new Actions(this.driver);
        }
        return this.actions;
    }

    public KeyboardElementActions keyDown(Keys theKey) {
        this.loadElementAndPerform(this.actions().keyDown(this.element, (CharSequence)theKey));
        return this;
    }

    public KeyboardElementActions keyUp(Keys theKey) {
        this.loadElementAndPerform(this.actions().keyUp(this.element, (CharSequence)theKey));
        return this;
    }

    public KeyboardElementActions sendKeys(CharSequence ... keysToSend) {
        this.loadElementAndPerform(this.actions().sendKeys(this.element, keysToSend));
        return this;
    }

    private void loadElementAndPerform(Actions action) {
        this.loadElement();
        action.perform();
    }

    private void loadElement() {
        LocatorProxies.now(this.element);
    }
}

