/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.events;

import io.fluentlenium.core.events.EventAnnotationsException;
import io.fluentlenium.core.events.GetScreenshotAsListener;
import io.fluentlenium.core.events.ListenerContext;
import io.fluentlenium.core.events.ListenerPriority;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.openqa.selenium.OutputType;

class AnnotationGetScreenshotAsListener
implements GetScreenshotAsListener,
ListenerPriority {
    private final Method method;
    private final Object container;
    private final String annotationName;
    private final int priority;

    AnnotationGetScreenshotAsListener(ListenerContext listenerContext) {
        this.method = listenerContext.getMethod();
        this.container = listenerContext.getContainer();
        this.annotationName = listenerContext.getAnnotationName();
        this.priority = listenerContext.getPriority();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected Function<Class<?>, Object> getArgsFunction(OutputType outputType) {
        return input -> {
            if (input.isAssignableFrom(OutputType.class)) {
                return outputType;
            }
            return null;
        };
    }

    protected Function<Class<?>, Object> getArgsFunction(OutputType outputType, Object o) {
        return input -> {
            if (input.isAssignableFrom(OutputType.class)) {
                return outputType;
            }
            if (input.isAssignableFrom(Object.class)) {
                return o;
            }
            return null;
        };
    }

    public void on(OutputType outputType) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(outputType), parameterTypes);
        this.invokeMethodByReflection(args);
    }

    public void on(OutputType outputType, Object o) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(outputType, o), parameterTypes);
        this.invokeMethodByReflection(args);
    }

    private void invokeMethodByReflection(Object[] args) {
        try {
            ReflectionUtils.invoke(this.method, this.container, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + String.valueOf(this.method), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + String.valueOf(this.method), e);
        }
    }
}

