/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.events;

import io.fluentlenium.core.components.ComponentInstantiator;
import io.fluentlenium.core.domain.FluentWebElement;
import io.fluentlenium.core.events.EventListener;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;

class EventAdapter
implements WebDriverEventListener {
    private final EventListener listener;
    private final ComponentInstantiator instantiator;

    EventAdapter(EventListener listener, ComponentInstantiator instantiator) {
        this.listener = listener;
        this.instantiator = instantiator;
    }

    public void beforeNavigateTo(String url, WebDriver driver) {
        this.listener.beforeNavigateTo(url, driver);
    }

    public void afterNavigateTo(String url, WebDriver driver) {
        this.listener.afterNavigateTo(url, driver);
    }

    public void beforeNavigateBack(WebDriver driver) {
        this.listener.beforeNavigateBack(driver);
    }

    public void afterNavigateBack(WebDriver driver) {
        this.listener.afterNavigateBack(driver);
    }

    public void beforeNavigateForward(WebDriver driver) {
        this.listener.beforeNavigateForward(driver);
    }

    public void afterNavigateForward(WebDriver driver) {
        this.listener.afterNavigateForward(driver);
    }

    public void beforeNavigateRefresh(WebDriver driver) {
        this.listener.beforeNavigateRefresh(driver);
    }

    public void afterNavigateRefresh(WebDriver driver) {
        this.listener.afterNavigateRefresh(driver);
    }

    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        this.listener.beforeFindBy(by, element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void afterFindBy(By by, WebElement element, WebDriver driver) {
        this.listener.afterFindBy(by, element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        this.listener.beforeClickOn(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        this.listener.afterClickOn(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void beforeChangeValueOf(WebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.listener.beforeChangeValueOf(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver, charSequence);
    }

    public void afterChangeValueOf(WebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.listener.afterChangeValueOf(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver, charSequence);
    }

    public void beforeScript(String script, WebDriver driver) {
        this.listener.beforeScript(script, driver);
    }

    public void afterScript(String script, WebDriver driver) {
        this.listener.afterScript(script, driver);
    }

    public void beforeSwitchToWindow(String s, WebDriver webDriver) {
        this.listener.beforeSwitchToWindow(s, webDriver);
    }

    public void afterSwitchToWindow(String s, WebDriver webDriver) {
        this.listener.afterSwitchToWindow(s, webDriver);
    }

    public void onException(Throwable throwable, WebDriver driver) {
        this.listener.onException(throwable, driver);
    }

    public <X> void beforeGetScreenshotAs(OutputType<X> outputType) {
        this.listener.beforeGetScreenshotAs(outputType);
    }

    public <X> void afterGetScreenshotAs(OutputType<X> outputType, X x) {
        this.listener.afterGetScreenshotAs(outputType, x);
    }

    public void beforeAlertAccept(WebDriver driver) {
        this.listener.beforeAlertAccept(driver);
    }

    public void afterAlertAccept(WebDriver driver) {
        this.listener.afterAlertAccept(driver);
    }

    public void beforeAlertDismiss(WebDriver driver) {
        this.listener.beforeAlertDismiss(driver);
    }

    public void afterAlertDismiss(WebDriver driver) {
        this.listener.afterAlertDismiss(driver);
    }

    public void beforeGetText(WebElement webElement, WebDriver webDriver) {
        this.listener.beforeGetText(this.instantiator.newComponent(FluentWebElement.class, webElement), webDriver);
    }

    public void afterGetText(WebElement webElement, WebDriver webDriver, String s) {
        this.listener.afterGetText(this.instantiator.newComponent(FluentWebElement.class, webElement), webDriver, s);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventAdapter that = (EventAdapter)obj;
        return Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hash(this.listener);
    }
}

