/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.filter;

import io.fluentlenium.core.filter.AttributeFilter;
import io.fluentlenium.core.filter.matcher.ContainsMatcher;
import io.fluentlenium.core.filter.matcher.ContainsWordMatcher;
import io.fluentlenium.core.filter.matcher.EndsWithMatcher;
import io.fluentlenium.core.filter.matcher.EqualMatcher;
import io.fluentlenium.core.filter.matcher.NotContainsMatcher;
import io.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import io.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import io.fluentlenium.core.filter.matcher.StartsWithMatcher;
import java.util.regex.Pattern;

public class FilterBuilder {
    private final String attribute;

    public FilterBuilder(String customAttribute) {
        this.attribute = customAttribute;
    }

    public AttributeFilter equalTo(String value) {
        return new AttributeFilter(this.attribute, new EqualMatcher(value));
    }

    public AttributeFilter contains(String value) {
        return new AttributeFilter(this.attribute, new ContainsMatcher(value));
    }

    public AttributeFilter containsWord(String word) {
        return new AttributeFilter(this.attribute, new ContainsWordMatcher(word));
    }

    public AttributeFilter contains(Pattern pattern) {
        return new AttributeFilter(this.attribute, new ContainsMatcher(pattern));
    }

    public AttributeFilter startsWith(String value) {
        return new AttributeFilter(this.attribute, new StartsWithMatcher(value));
    }

    public AttributeFilter startsWith(Pattern pattern) {
        return new AttributeFilter(this.attribute, new StartsWithMatcher(pattern));
    }

    public AttributeFilter endsWith(String value) {
        return new AttributeFilter(this.attribute, new EndsWithMatcher(value));
    }

    public AttributeFilter endsWith(Pattern pattern) {
        return new AttributeFilter(this.attribute, new EndsWithMatcher(pattern));
    }

    public AttributeFilter notContains(String value) {
        return new AttributeFilter(this.attribute, new NotContainsMatcher(value));
    }

    public AttributeFilter notContains(Pattern pattern) {
        return new AttributeFilter(this.attribute, new NotContainsMatcher(pattern));
    }

    public AttributeFilter notStartsWith(String value) {
        return new AttributeFilter(this.attribute, new NotStartsWithMatcher(value));
    }

    public AttributeFilter notStartsWith(Pattern pattern) {
        return new AttributeFilter(this.attribute, new NotStartsWithMatcher(pattern));
    }

    public AttributeFilter notEndsWith(String value) {
        return new AttributeFilter(this.attribute, new NotEndsWithMatcher(value));
    }

    public AttributeFilter notEndsWith(Pattern pattern) {
        return new AttributeFilter(this.attribute, new NotEndsWithMatcher(pattern));
    }
}

