/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.inject;

import io.fluentlenium.core.FluentControl;
import io.fluentlenium.core.inject.ContainerContext;
import io.fluentlenium.core.inject.ContainerFluentControl;
import io.fluentlenium.core.inject.ContainerInstantiator;
import io.fluentlenium.core.inject.FluentInjectException;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class DefaultContainerInstantiator
implements ContainerInstantiator {
    private final FluentControl control;

    public DefaultContainerInstantiator(FluentControl control) {
        this.control = control;
    }

    @Override
    public <T> T newInstance(Class<T> cls, ContainerContext context) {
        try {
            return ReflectionUtils.newInstanceOptionalArgs(cls, new ContainerFluentControl(this.control, context));
        }
        catch (NoSuchMethodException e) {
            throw new FluentInjectException(cls.getName() + " is not a valid component class.", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FluentInjectException(cls.getName() + " can't be instantiated.", e);
        }
    }
}

