/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.proxy;

import io.fluentlenium.core.proxy.AbstractLocatorHandler;
import io.fluentlenium.core.proxy.LocatorHandler;
import io.fluentlenium.core.proxy.LocatorProxies;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public abstract class AbstractLocatorAndInvocationHandler<T>
extends AbstractLocatorHandler<T>
implements InvocationHandler {
    private static final Method TO_STRING = ReflectionUtils.getMethod(Object.class, "toString", new Class[0]);
    private static final Method EQUALS = ReflectionUtils.getMethod(Object.class, "equals", Object.class);
    private static final Method HASH_CODE = ReflectionUtils.getMethod(Object.class, "hashCode", new Class[0]);
    private static final int MAX_RETRY = 5;
    private static final int HASH_CODE_SEED = 2048;

    public AbstractLocatorAndInvocationHandler(ElementLocator locator) {
        super(locator);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object invocationResult = null;
        invocationResult = TO_STRING.equals(method) ? this.proxyToString(this.loaded() ? (String)this.invoke(method, args) : null) : (this.loaded() ? this.invokeEqualsOnLoadedProxy(method, args, invocationResult) : this.invokeMethodOnUnloadedProxy(proxy, method, args, invocationResult));
        if (invocationResult == null) {
            this.getLocatorResult();
            invocationResult = this.invokeWithRetry(method, args);
        }
        return invocationResult;
    }

    private Object invokeEqualsOnLoadedProxy(Method method, Object[] args, Object invocationResult) {
        Object result = invocationResult;
        if (EQUALS.equals(method)) {
            result = this.invokeEqualsWhenResultIsPresent(args[0]);
        }
        return result;
    }

    private Object invokeEqualsWhenResultIsPresent(Object arg) {
        Boolean invocationResult = null;
        LocatorHandler otherLocatorHandler = LocatorProxies.getLocatorHandler(arg);
        if (otherLocatorHandler != null && !otherLocatorHandler.loaded()) {
            otherLocatorHandler.now();
            invocationResult = otherLocatorHandler.equals(this);
        }
        return invocationResult;
    }

    private Object invokeMethodOnUnloadedProxy(Object proxy, Method method, Object[] args, Object invocationResult) {
        Object result = invocationResult;
        if (EQUALS.equals(method)) {
            result = this.invokeEqualsWhenResultIsAbsent(proxy, args);
        } else if (HASH_CODE.equals(method)) {
            result = 2048 + this.locator.hashCode();
        }
        return result;
    }

    private Object invokeEqualsWhenResultIsAbsent(Object proxy, Object[] args) {
        Boolean invocationResult = null;
        LocatorHandler otherLocatorHandler = LocatorProxies.getLocatorHandler(args[0]);
        if (otherLocatorHandler != null) {
            invocationResult = !otherLocatorHandler.loaded() || args[0] == null ? Boolean.valueOf(this.equals(otherLocatorHandler)) : Boolean.valueOf(args[0].equals(proxy));
        }
        return invocationResult;
    }

    private Object invokeWithRetry(Method method, Object[] args) throws Throwable {
        StaleElementReferenceException lastThrowable = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return this.invoke(method, args);
            }
            catch (StaleElementReferenceException e) {
                lastThrowable = e;
                this.reset();
                this.getLocatorResult();
                continue;
            }
        }
        throw lastThrowable;
    }

    private Object invoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.getInvocationTarget(method), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLocatorHandler that = (AbstractLocatorHandler)obj;
        return Objects.equals(this.locator, that.locator);
    }

    public int hashCode() {
        return Objects.hash(this.locator);
    }

    public String toString() {
        return this.proxyToString(null);
    }
}

