/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.proxy;

import io.fluentlenium.core.domain.ElementUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class AtIndexElementLocator
implements ElementLocator {
    private final int index;
    protected ElementLocator listLocator;

    public AtIndexElementLocator(ElementLocator listLocator, int index) {
        this.listLocator = listLocator;
        this.index = index;
    }

    public WebElement findElement() {
        WebElement element = this.getWebElementAtIndex();
        if (element == null) {
            throw ElementUtils.noSuchElementException("Element " + String.valueOf(this));
        }
        return element;
    }

    public List<WebElement> findElements() {
        WebElement element = this.getWebElementAtIndex();
        if (element == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(element);
    }

    public String toString() {
        return this.listLocator.toString() + " (index=" + this.index + ")";
    }

    private WebElement getWebElementAtIndex() {
        List elements = this.listLocator.findElements();
        if (this.index >= elements.size()) {
            return null;
        }
        return (WebElement)elements.get(this.index);
    }
}

