/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.utils;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeleniumVersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeleniumVersionChecker.class);
    static final String FAILED_TO_READ_MESSAGE = "FluentLenium wasn't able to read Selenium version from your pom.xml. Skipped compatibility check. Please make sure you are using correct Selenium version - {}";
    static final String WRONG_VERSION_MESSAGE = "You are using incompatible Selenium version {}. Please change it to {}. You can find example on project main page {}";
    private static final String EXPECTED_VERSION = "4.9.0";
    private static final String SELENIUM_GROUP_ID = "org.seleniumhq.selenium";
    private static final String FL_URL = "https://github.com/FluentLenium/FluentLenium";
    private static final String POM = "pom.xml";
    private static final String PARENT_MODULE_POM = "../pom.xml";
    private static final String VERSION_REGEX = "^\\$\\{.*}$";
    private static boolean notifiedAlready;
    private static boolean isSeleniumVersionFound;

    private SeleniumVersionChecker() {
    }

    public static void checkSeleniumVersion() {
        if (!notifiedAlready) {
            SeleniumVersionChecker.checkVersionFromMaven();
        }
        notifiedAlready = true;
    }

    private static void checkVersionFromMaven() {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        if (new File(POM).exists()) {
            model = SeleniumVersionChecker.readPom(reader, POM);
            SeleniumVersionChecker.logWarningsWhenSeleniumVersionIsWrong(model);
        }
        if (!isSeleniumVersionFound && new File(PARENT_MODULE_POM).exists()) {
            model = SeleniumVersionChecker.readPom(reader, PARENT_MODULE_POM);
            SeleniumVersionChecker.logWarningsWhenSeleniumVersionIsWrong(model);
        }
    }

    static void logWarningsWhenSeleniumVersionIsWrong(Model model) {
        if (model != null) {
            String seleniumVersion = SeleniumVersionChecker.retrieveVersionFromPom(model);
            if (seleniumVersion == null) {
                return;
            }
            isSeleniumVersionFound = true;
            String resolvedSeleniumVersion = SeleniumVersionChecker.isParametrised(seleniumVersion) ? SeleniumVersionChecker.resolveParametrisedVersion(model, seleniumVersion) : seleniumVersion;
            if (!Objects.equals(resolvedSeleniumVersion, EXPECTED_VERSION)) {
                LOGGER.warn(WRONG_VERSION_MESSAGE, new Object[]{resolvedSeleniumVersion, EXPECTED_VERSION, FL_URL});
            }
        }
    }

    private static String resolveParametrisedVersion(Model model, String seleniumVersion) {
        MavenXpp3Reader reader;
        String resolvedSeleniumVersion = SeleniumVersionChecker.resolveParametrisedVersionFromPom(seleniumVersion, model);
        if (resolvedSeleniumVersion == null && (model = SeleniumVersionChecker.readPom(reader = new MavenXpp3Reader(), PARENT_MODULE_POM)) != null) {
            resolvedSeleniumVersion = SeleniumVersionChecker.resolveParametrisedVersionFromPom(seleniumVersion, model);
        }
        return resolvedSeleniumVersion;
    }

    static String retrieveVersionFromPom(Model model) {
        List dependencies = Objects.nonNull(model.getDependencyManagement()) ? Stream.of(model.getDependencies(), model.getDependencyManagement().getDependencies()).flatMap(Collection::stream).collect(Collectors.toList()) : model.getDependencies();
        return dependencies.stream().filter(dep -> dep.getGroupId().contains(SELENIUM_GROUP_ID)).filter(dep -> !dep.getArtifactId().contains("htmlunit-driver")).filter(dep -> dep.getVersion() != null).findFirst().map(Dependency::getVersion).orElse(null);
    }

    private static boolean isParametrised(String version) {
        return version.matches(VERSION_REGEX);
    }

    static String resolveParametrisedVersionFromPom(String seleniumVersion, Model model) {
        String version = SeleniumVersionChecker.getNamePropertyName(seleniumVersion);
        if (Objects.nonNull(model.getProperties())) {
            return model.getProperties().getProperty(version);
        }
        if (Objects.nonNull(System.getProperty(version))) {
            return System.getProperty(version);
        }
        if (Objects.nonNull(model.getProfiles()) && model.getProfiles().size() > 0) {
            return SeleniumVersionChecker.getVersionNameFromProfiles(version, model);
        }
        return null;
    }

    private static String getVersionNameFromProfiles(String version, Model model) {
        return model.getProfiles().stream().filter(prof -> Objects.nonNull(prof.getProperties()) && Objects.nonNull(prof.getProperties().getProperty(version))).findAny().map(prof -> prof.getProperties().getProperty(version)).orElse(null);
    }

    private static String getNamePropertyName(String propertyVersion) {
        return Objects.nonNull(propertyVersion) ? propertyVersion.substring(2, propertyVersion.length() - 1) : "";
    }

    static Model readPom(MavenXpp3Reader reader, String pathToPom) {
        Model result = null;
        try {
            result = reader.read((Reader)Files.newBufferedReader(Paths.get(pathToPom, new String[0])));
        }
        catch (IOException | XmlPullParserException e) {
            LOGGER.info(FAILED_TO_READ_MESSAGE, (Object)EXPECTED_VERSION);
        }
        return result;
    }
}

