/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok;

import io.freefair.gradle.plugins.lombok.LombokExtension;
import io.freefair.gradle.plugins.lombok.tasks.LombokJarTask;
import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class LombokBasePlugin
implements Plugin<Project> {
    private LombokExtension lombokExtension;
    private Configuration lombokConfiguration;

    public void apply(Project project) {
        this.lombokExtension = (LombokExtension)project.getExtensions().create("lombok", LombokExtension.class, new Object[0]);
        this.lombokConfiguration = (Configuration)project.getConfigurations().create("lombok");
        this.lombokConfiguration.defaultDependencies(dependencySet -> dependencySet.add((Object)project.getDependencies().create((Object)("org.projectlombok:lombok:" + (String)this.lombokExtension.getVersion().get()))));
        project.getTasks().withType(LombokTask.class).configureEach(lombokTask -> lombokTask.getLombokClasspath().from(new Object[]{this.lombokConfiguration}));
        project.getTasks().withType(LombokJarTask.class).configureEach(lombokJarTask -> {
            lombokJarTask.getArchiveVersion().convention(this.lombokExtension.getVersion());
            lombokJarTask.getDestinationDirectory().convention(project.getLayout().getBuildDirectory().dir("lombok"));
        });
    }

    @Generated
    public LombokExtension getLombokExtension() {
        return this.lombokExtension;
    }

    @Generated
    public Configuration getLombokConfiguration() {
        return this.lombokConfiguration;
    }
}

