/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

@CacheableTask
public abstract class Delombok
extends DefaultTask
implements LombokTask {
    @Input
    private Map<String, String> format = new HashMap<String, String>();

    @Inject
    protected abstract FileOperations getFileOperations();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Override
    @Nested
    @Optional
    public abstract Property<JavaLauncher> getLauncher();

    @Console
    public abstract Property<Boolean> getVerbose();

    @Console
    public abstract Property<Boolean> getQuiet();

    @Input
    @Optional
    public abstract Property<String> getEncoding();

    @Input
    @Optional
    public abstract Property<Boolean> getPrint();

    @OutputDirectory
    public abstract DirectoryProperty getTarget();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getClasspath();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract ConfigurableFileCollection getSourcepath();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getBootclasspath();

    @Classpath
    @Optional
    public abstract ConfigurableFileCollection getModulePath();

    @Input
    @Optional
    public abstract Property<Boolean> getNocopy();

    @Override
    @Classpath
    public abstract ConfigurableFileCollection getLombokClasspath();

    @Internal
    public abstract ConfigurableFileCollection getInput();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    protected FileTree getFilteredInput() {
        ConfigurableFileTree fileTree = null;
        for (File file : this.getInput().getFiles()) {
            if (!file.isDirectory()) continue;
            if (fileTree == null) {
                fileTree = this.getFileOperations().fileTree((Object)file);
                continue;
            }
            fileTree.from((Object)file);
        }
        return fileTree;
    }

    @TaskAction
    public void delombok() throws IOException {
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{this.getTarget()}).setFollowSymlinks(false));
        LinkedList<Object> args = new LinkedList<Object>();
        if (((Boolean)this.getVerbose().getOrElse((Object)false)).booleanValue()) {
            args.add("--verbose");
        }
        this.getFormat().forEach((key, value) -> {
            String formatValue = key + (String)(value != null && !value.isEmpty() ? ":" + value : "");
            args.add("--format=" + formatValue);
        });
        if (((Boolean)this.getQuiet().getOrElse((Object)false)).booleanValue()) {
            args.add("--quiet");
        }
        if (this.getEncoding().isPresent()) {
            args.add("--encoding=" + (String)this.getEncoding().get());
        }
        if (((Boolean)this.getPrint().getOrElse((Object)false)).booleanValue()) {
            args.add("--print");
        }
        if (this.getTarget().isPresent()) {
            args.add("--target=" + Delombok.escape(((File)this.getTarget().getAsFile().get()).getAbsolutePath()));
        }
        if (!this.getClasspath().isEmpty()) {
            args.add("--classpath=" + Delombok.escape(this.getClasspath().getAsPath()));
        }
        if (!this.getSourcepath().isEmpty()) {
            args.add("--sourcepath=" + Delombok.escape(this.getSourcepath().getAsPath()));
        }
        if (!this.getBootclasspath().isEmpty()) {
            args.add("--bootclasspath=" + Delombok.escape(this.getBootclasspath().getAsPath()));
        }
        if (!this.getModulePath().isEmpty()) {
            args.add("--module-path=" + Delombok.escape(this.getModulePath().getAsPath()));
        }
        if (((Boolean)this.getNocopy().getOrElse((Object)false)).booleanValue()) {
            args.add("--nocopy");
        }
        File optionsFile = new File(this.getTemporaryDir(), "delombok.options");
        Files.write(optionsFile.toPath(), args, new OpenOption[0]);
        this.getExecOperations().javaexec(delombok -> {
            if (this.getLauncher().isPresent()) {
                delombok.setExecutable(((JavaLauncher)this.getLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath());
            }
            delombok.setClasspath((FileCollection)this.getLombokClasspath());
            delombok.getMainClass().set((Object)"lombok.launch.Main");
            delombok.args(new Object[]{"delombok"});
            delombok.args(new Object[]{"@" + String.valueOf(optionsFile)});
            delombok.args((Iterable)this.getInput().getFiles().stream().filter(File::isDirectory).collect(Collectors.toList()));
        });
    }

    private static String escape(String path) {
        return path.replace("\\", "\\\\").replace(" ", "\\ ");
    }

    @Generated
    public Map<String, String> getFormat() {
        return this.format;
    }

    @Generated
    public void setFormat(Map<String, String> format) {
        this.format = format;
    }
}

