/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.LogFileReader$;
import io.gatling.core.cli.GatlingArgs;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.shared.model.assertion.AssertionMessage$;
import io.gatling.shared.model.assertion.AssertionResult;
import io.gatling.shared.model.assertion.AssertionStatsRepository;
import io.gatling.shared.model.assertion.AssertionValidator;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001\u0002\u0006\f\rIA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tE\u0001\u0011\t\u0011)A\u0005G!)\u0011\u0006\u0001C\u0001U!)q\u0006\u0001C\u0001a!)1\b\u0001C\u0005y!)q\t\u0001C\u0005\u0011\")Q\u000b\u0001C\u0005-\")!\f\u0001C\u00057\"9\u0011q\u0001\u0001\u0005\n\u0005%!A\u0005*v]J+7/\u001e7u!J|7-Z:t_JT!\u0001D\u0007\u0002\u0007\u0005\u0004\bO\u0003\u0002\u000f\u001f\u00059q-\u0019;mS:<'\"\u0001\t\u0002\u0005%|7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017aC4bi2LgnZ!sON\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0007\rd\u0017N\u0003\u0002 \u001b\u0005!1m\u001c:f\u0013\t\tCDA\u0006HCRd\u0017N\\4Be\u001e\u001c\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002%O5\tQE\u0003\u0002'=\u000511m\u001c8gS\u001eL!\u0001K\u0013\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u00191&\f\u0018\u0011\u00051\u0002Q\"A\u0006\t\u000be\u0019\u0001\u0019\u0001\u000e\t\u000b\t\u001a\u0001\u0019A\u0012\u0002!A\u0014xnY3tgJ+hNU3tk2$HCA\u00197!\t\u0011D'D\u00014\u0015\ti2\"\u0003\u00026g\tQ1\u000b^1ukN\u001cu\u000eZ3\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\u0013I,hNU3tk2$\bC\u0001\u0017:\u0013\tQ4BA\u0005Sk:\u0014Vm];mi\u0006\u0001\"/Z:vYR\u001cH)\u001b:fGR|'/_\u000b\u0002{A\u0011a(R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005M&dWM\u0003\u0002C\u0007\u0006\u0019a.[8\u000b\u0003\u0011\u000bAA[1wC&\u0011ai\u0010\u0002\u0005!\u0006$\b.A\bj]&$Hj\\4GS2,G)\u0019;b)\tIE\u000bE\u0002\u0015\u00152K!aS\u000b\u0003\r=\u0003H/[8o!\ti%+D\u0001O\u0015\ty\u0005+A\u0003ti\u0006$8O\u0003\u0002R\u001b\u000511\r[1siNL!a\u0015(\u0003\u00171{wMR5mK\u0012\u000bG/\u0019\u0005\u0006o\u0019\u0001\r\u0001O\u0001\u0019e\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>tWI\\1cY\u0016$W#A,\u0011\u0005QA\u0016BA-\u0016\u0005\u001d\u0011un\u001c7fC:\fqbZ3oKJ\fG/\u001a*fa>\u0014Ho\u001d\u000b\u00059~cg\u000e\u0005\u0002\u0015;&\u0011a,\u0006\u0002\u0005+:LG\u000fC\u0003a\u0011\u0001\u0007\u0011-A\u0003sk:LE\r\u0005\u0002cS:\u00111m\u001a\t\u0003IVi\u0011!\u001a\u0006\u0003MF\ta\u0001\u0010:p_Rt\u0014B\u00015\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011!n\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!,\u0002\"B7\t\u0001\u0004a\u0015a\u00037pO\u001aKG.\u001a#bi\u0006DQa\u001c\u0005A\u0002A\f\u0001#Y:tKJ$\u0018n\u001c8SKN,H\u000e^:\u0011\u0007E4\u0018P\u0004\u0002si:\u0011Am]\u0005\u0002-%\u0011Q/F\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bP\u0001\u0003MSN$(BA;\u0016!\rQ\u00181A\u0007\u0002w*\u0011A0`\u0001\nCN\u001cXM\u001d;j_:T!A`@\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u0005Q\"\u0001\u0004tQ\u0006\u0014X\rZ\u0005\u0004\u0003\u000bY(aD!tg\u0016\u0014H/[8o%\u0016\u001cX\u000f\u001c;\u0002\u0013I,hn\u0015;biV\u001cHcA\u0019\u0002\f!)q.\u0003a\u0001a\u0002")
public final class RunResultProcessor {
    private final GatlingArgs gatlingArgs;
    private final GatlingConfiguration configuration;

    public StatusCode processRunResult(RunResult runResult) {
        Option<LogFileData> option = this.initLogFileData(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileData logFileData = (LogFileData)some.value();
            List assertionResults = new AssertionValidator((AssertionStatsRepository)logFileData).validateAssertions(logFileData.assertions());
            this.generateReports(runResult.runId(), logFileData, (List<AssertionResult>)assertionResults);
            return this.runStatus((List<AssertionResult>)assertionResults);
        }
        return StatusCode$Success$.MODULE$;
    }

    private Path resultsDirectory() {
        return (Path)this.gatlingArgs.resultsDirectory().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Can't generate reports if resultsDirectory is not set");
        });
    }

    private Option<LogFileData> initLogFileData(RunResult runResult) {
        if (this.reportsGenerationEnabled() || runResult.hasAssertions()) {
            long start = System.currentTimeMillis();
            Predef$.MODULE$.println((Object)"Parsing log file(s)...");
            LogFileData logFileData = LogFileReader$.MODULE$.apply(runResult.runId(), this.resultsDirectory(), this.configuration).read();
            Predef$.MODULE$.println((Object)("Parsing log file(s) done in " + (System.currentTimeMillis() - start) / 1000L + "s."));
            return new Some((Object)logFileData);
        }
        return None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.gatlingArgs.reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.gatlingArgs.noReports();
    }

    private void generateReports(String runId, LogFileData logFileData, List<AssertionResult> assertionResults) {
        if (this.reportsGenerationEnabled()) {
            Predef$.MODULE$.println((Object)"Generating reports...");
            ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runId, logFileData, assertionResults);
            Path indexFile = new ReportsGenerator(this.configuration.data().zoneId(), this.configuration.core().charset(), this.resultsDirectory(), this.configuration.reports()).generateFor(reportsGenerationInputs);
            Predef$.MODULE$.println((Object)("Reports generated, please open the following file: " + indexFile.toUri()));
            return;
        }
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        if (consolidatedAssertionResult) {
            return StatusCode$Success$.MODULE$;
        }
        return StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        String message = AssertionMessage$.MODULE$.message(assertionResult.assertion());
        AssertionResult assertionResult2 = assertionResult;
        if (assertionResult2 instanceof AssertionResult.Resolved) {
            AssertionResult.Resolved resolved = (AssertionResult.Resolved)assertionResult2;
            boolean success = resolved.success();
            double actualValue = resolved.actualValue();
            Predef$.MODULE$.println((Object)(message + " : " + success + " (actual : " + actualValue + ")"));
        } else if (assertionResult2 instanceof AssertionResult.ResolutionError) {
            AssertionResult.ResolutionError resolutionError = (AssertionResult.ResolutionError)assertionResult2;
            String error = resolutionError.error();
            Predef$.MODULE$.println((Object)(message + " : false (" + error + ")"));
        } else {
            throw new MatchError((Object)assertionResult2);
        }
        return isValid && assertionResult.success();
    }

    public RunResultProcessor(GatlingArgs gatlingArgs, GatlingConfiguration configuration) {
        this.gatlingArgs = gatlingArgs;
        this.configuration = configuration;
    }
}

