/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.stats.RunInfo;
import io.gatling.charts.util.HtmlHelper$;
import io.gatling.charts.util.HtmlHelper$HtmlRichString$;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00193Qa\u0002\u0005\u0003\u0015AA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\t;\u0001\u0011\t\u0011)A\u0005=!)a\u0005\u0001C\u0001O!)1\u0006\u0001C!Y!)!\b\u0001C!Y!)1\b\u0001C!y\t92+[7vY\u0006$\u0018n\u001c8DCJ$7i\\7q_:,g\u000e\u001e\u0006\u0003\u0013)\t\u0011bY8na>tWM\u001c;\u000b\u0005-a\u0011AB2iCJ$8O\u0003\u0002\u000e\u001d\u00059q-\u0019;mS:<'\"A\b\u0002\u0005%|7C\u0001\u0001\u0012!\t\u00112#D\u0001\t\u0013\t!\u0002BA\u0005D_6\u0004xN\\3oi\u00069!/\u001e8J]\u001a|7\u0001\u0001\t\u00031mi\u0011!\u0007\u0006\u00035)\tQa\u001d;biNL!\u0001H\r\u0003\u000fI+h.\u00138g_\u00061!p\u001c8f\u0013\u0012\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\tQLW.\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004[_:,\u0017\nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!J#\u0006\u0005\u0002\u0013\u0001!)Qc\u0001a\u0001/!)Qd\u0001a\u0001=\u0005!\u0001\u000e^7m+\u0005i\u0003C\u0001\u00188\u001d\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u00023-\u00051AH]8pizR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011agM\u0001\u0003UN\fqA[:GS2,7/F\u0001>!\rq4)\f\b\u0003\u007f\u0005s!\u0001\r!\n\u0003QJ!AQ\u001a\u0002\u000fA\f7m[1hK&\u0011A)\u0012\u0002\u0004'\u0016\f(B\u0001\"4\u0001")
public final class SimulationCardComponent
extends Component {
    private final RunInfo runInfo;
    private final ZoneId zoneId;

    @Override
    public String html() {
        String printableRunDateTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss O").withZone(this.zoneId).format(Instant.ofEpochMilli(this.runInfo.injectStart()));
        String printableGatlingReleaseDate = GatlingVersion$.MODULE$.ThisVersion().releaseDate().toLocalDate().toString();
        Duration duration = Duration.ofMillis(this.runInfo.injectEnd() - this.runInfo.injectStart());
        long days = duration.toDays();
        Duration minusDays = duration.minusDays(days);
        long hours = minusDays.toHours();
        Duration minusHours = minusDays.minusHours(hours);
        long minutes = minusHours.toMinutes();
        long seconds = minusHours.minusMinutes(minutes).getSeconds();
        String printableDuration = (String)(days > 0L ? days + "d " : "") + (hours > 0L ? hours + "h " : (days > 0L ? "0h" : "")) + (minutes > 0L ? minutes + "m " : (days > 0L || hours > 0L ? "0m" : "")) + (seconds > 0L ? seconds + "s " : "0s");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<div class=\"simulation-card\">\n       |  <div class=\"simulation-version-information\">\n       |  <span class=\"simulation-information-title\">Gatling Version</span>\n       |    <span class=\"simulation-information-item\">\n       |      <span class=\"simulation-information-label\">Version: </span>\n       |      <span>" + GatlingVersion$.MODULE$.ThisVersion().fullVersion() + "</span>\n       |    </span>\n       |    <span class=\"simulation-information-item\">\n       |      <span class=\"simulation-information-label\">Released: </span>\n       |      <span>" + printableGatlingReleaseDate + "</span>\n       |    </span>\n       |  </div>\n       |  <div id=\"simulation-information\" class=\"simulation-version-information\">\n       |    <span class=\"simulation-information-title\">Run Information</span>\n       |    <div class=\"simulation-information-container\">\n       |      <span class=\"simulation-information-item\">\n       |        <span class=\"simulation-information-label\">Date: </span>\n       |        <span>" + printableRunDateTime + "</span>\n       |      </span>\n       |      <span class=\"simulation-information-item\">\n       |        <span class=\"simulation-information-label\">Duration: </span>\n       |        <span>" + printableDuration + "</span>\n       |      </span>\n       |      " + (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.runInfo.runDescription())) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<span class=\"simulation-tooltip simulation-information-item description\" title=\"Description\" data-content=\"" + HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(this.runInfo.runDescription())) + "\">\n           |        <span class=\"simulation-information-label\">Description: </span>\n           |        <span>" + HtmlHelper$HtmlRichString$.MODULE$.htmlEscape$extension(HtmlHelper$.MODULE$.HtmlRichString(StringHelper.RichString$.MODULE$.truncate$extension(StringHelper$.MODULE$.RichString(this.runInfo.runDescription()), 2300))) + "</span>\n           |      </span>\n           |")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<span class=\"simulation-information-item\">\n          |        <span class=\"simulation-information-label\">Description: </span>\n          |        <span>&mdash;</span>\n          |      </span>\n          |"))) + "\n       |    </div>\n       |  </div>\n       |</div>"));
    }

    @Override
    public String js() {
        return "";
    }

    @Override
    public Seq<String> jsFiles() {
        return Nil$.MODULE$;
    }

    public SimulationCardComponent(RunInfo runInfo, ZoneId zoneId) {
        this.runInfo = runInfo;
        this.zoneId = zoneId;
    }
}

