/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.core.Predef;
import io.gatling.core.body.BodyProcessors;
import io.gatling.core.body.BodyWithBytesExpression;
import io.gatling.core.body.ElFileBodies;
import io.gatling.core.body.PebbleFileBodies;
import io.gatling.core.body.RawFileBodies;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.css.CssCheckType;
import io.gatling.core.check.css.CssSelectors;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jmespath.JmesPaths;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.jsonpath.JsonPaths;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckType;
import io.gatling.core.check.regex.Patterns;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.core.check.xpath.XmlParsers;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.throttle.Hold;
import io.gatling.core.controller.throttle.Jump;
import io.gatling.javaapi.core.Assertion;
import io.gatling.javaapi.core.Body;
import io.gatling.javaapi.core.ChainBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Choice;
import io.gatling.javaapi.core.ClosedInjectionStep;
import io.gatling.javaapi.core.DeploymentInfo;
import io.gatling.javaapi.core.DummyBuilder;
import io.gatling.javaapi.core.FeederBuilder;
import io.gatling.javaapi.core.Filter;
import io.gatling.javaapi.core.OpenInjectionStep;
import io.gatling.javaapi.core.PauseType;
import io.gatling.javaapi.core.ScenarioBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.ThrottleStep;
import io.gatling.javaapi.core.exec.Executable;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.CoreCheckBuilders;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.javaapi.core.internal.Executables;
import io.gatling.javaapi.core.internal.Expressions;
import io.pebbletemplates.pebble.extension.Extension;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jodd.lagarto.dom.NodeSelector;
import org.jspecify.annotations.NonNull;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;

public final class CoreDsl {
    public static final DeploymentInfo deploymentInfo = DeploymentInfo.INSTANCE;
    public static PauseType disabledPauses = PauseType.Disabled;
    public static PauseType constantPauses = PauseType.Constant;
    public static PauseType exponentialPauses = PauseType.Exponential;
    public static final Function<Body, Body.WithBytes> gzipBody = body -> new Body.WithBytes((BodyWithBytesExpression)BodyProcessors.gzip().apply((Object)body.asScala()));

    private CoreDsl() {
    }

    public static @NonNull ScenarioBuilder scenario(@NonNull String string) {
        return new ScenarioBuilder(string);
    }

    public static  @NonNull Filter.AllowList AllowList(String ... stringArray) {
        return CoreDsl.AllowList(Arrays.asList(stringArray));
    }

    public static  @NonNull Filter.AllowList AllowList(@NonNull List<String> list) {
        return new Filter.AllowList(list);
    }

    public static  @NonNull Filter.DenyList DenyList(String ... stringArray) {
        return CoreDsl.DenyList(Arrays.asList(stringArray));
    }

    public static  @NonNull Filter.DenyList DenyList(@NonNull List<String> list) {
        return new Filter.DenyList(list);
    }

    public static @NonNull ChainBuilder exec(@NonNull Function<Session, Session> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(function);
    }

    public static @NonNull ChainBuilder exec(@NonNull Executable executable, Executable ... executableArray) {
        return CoreDsl.exec(Executables.toChainBuilders(executable, executableArray));
    }

    public static @NonNull ChainBuilder exec(@NonNull List<ChainBuilder> list) {
        return (ChainBuilder)ChainBuilder.EMPTY.exec(list);
    }

    public static @NonNull ChainBuilder pause(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l);
    }

    public static @NonNull ChainBuilder pause(long l, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, pauseType);
    }

    public static @NonNull ChainBuilder pause(@NonNull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration);
    }

    public static @NonNull ChainBuilder pause(@NonNull Duration duration, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, pauseType);
    }

    public static @NonNull ChainBuilder pause(@NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string);
    }

    public static @NonNull ChainBuilder pause(@NonNull String string, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, pauseType);
    }

    public static @NonNull ChainBuilder pause(@NonNull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function);
    }

    public static @NonNull ChainBuilder pause(@NonNull Function<Session, Duration> function, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, pauseType);
    }

    public static @NonNull ChainBuilder pause(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2);
    }

    public static @NonNull ChainBuilder pause(long l, long l2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(l, l2, pauseType);
    }

    public static @NonNull ChainBuilder pause(@NonNull Duration duration, @NonNull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2);
    }

    public static @NonNull ChainBuilder pause(@NonNull Duration duration, @NonNull Duration duration2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(duration, duration2, pauseType);
    }

    public static @NonNull ChainBuilder pause(@NonNull String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2);
    }

    public static @NonNull ChainBuilder pause(@NonNull String string, @NonNull String string2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(string, string2, pauseType);
    }

    public static @NonNull ChainBuilder pause(@NonNull Function<Session, Duration> function, @NonNull Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2);
    }

    public static @NonNull ChainBuilder pause(@NonNull Function<Session, Duration> function, @NonNull Function<Session, Duration> function2, @NonNull PauseType pauseType) {
        return (ChainBuilder)ChainBuilder.EMPTY.pause(function, function2, pauseType);
    }

    public static @NonNull ChainBuilder pace(long l) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l);
    }

    public static @NonNull ChainBuilder pace(long l, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, string);
    }

    public static @NonNull ChainBuilder pace(@NonNull Duration duration) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration);
    }

    public static @NonNull ChainBuilder pace(@NonNull Duration duration, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, string);
    }

    public static @NonNull ChainBuilder pace(@NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string);
    }

    public static @NonNull ChainBuilder pace(@NonNull String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2);
    }

    public static @NonNull ChainBuilder pace(@NonNull Function<Session, Duration> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function);
    }

    public static @NonNull ChainBuilder pace(@NonNull Function<Session, Duration> function, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, string);
    }

    public static @NonNull ChainBuilder pace(long l, long l2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2);
    }

    public static @NonNull ChainBuilder pace(long l, long l2, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(l, l2, string);
    }

    public static @NonNull ChainBuilder pace(@NonNull Duration duration, @NonNull Duration duration2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2);
    }

    public static @NonNull ChainBuilder pace(@NonNull Duration duration, @NonNull Duration duration2, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(duration, duration2, string);
    }

    public static @NonNull ChainBuilder pace(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(string, string2, string3);
    }

    public static @NonNull ChainBuilder pace(@NonNull Function<Session, Duration> function, Function<Session, Duration> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2);
    }

    public static @NonNull ChainBuilder pace(@NonNull Function<Session, Duration> function, @NonNull Function<Session, Duration> function2, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.pace(function, function2, string);
    }

    public static @NonNull ChainBuilder rendezVous(int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.rendezVous(n);
    }

    public static @NonNull ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier);
    }

    public static @NonNull ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, n);
    }

    public static @NonNull ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, string);
    }

    public static @NonNull ChainBuilder feed(@NonNull Supplier<Iterator<Map<String, Object>>> supplier, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(supplier, function);
    }

    public static @NonNull ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator);
    }

    public static @NonNull ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, n);
    }

    public static @NonNull ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, string);
    }

    public static @NonNull ChainBuilder feed(@NonNull Iterator<Map<String, Object>> iterator, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(iterator, function);
    }

    public static @NonNull ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder);
    }

    public static @NonNull ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder, int n) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, n);
    }

    public static @NonNull ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder, String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, string);
    }

    public static @NonNull ChainBuilder feed(@NonNull FeederBuilder<?> feederBuilder, Function<Session, Integer> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.feed(feederBuilder, function);
    }

    public static  @NonNull Repeat.On<ChainBuilder> repeat(int n) {
        return ChainBuilder.EMPTY.repeat(n);
    }

    public static  @NonNull Repeat.On<ChainBuilder> repeat(int n, @NonNull String string) {
        return ChainBuilder.EMPTY.repeat(n, string);
    }

    public static  @NonNull Repeat.On<ChainBuilder> repeat(@NonNull String string) {
        return ChainBuilder.EMPTY.repeat(string);
    }

    public static  @NonNull Repeat.On<ChainBuilder> repeat(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.repeat(string, string2);
    }

    public static  @NonNull Repeat.On<ChainBuilder> repeat(@NonNull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.repeat(function);
    }

    public static  @NonNull Repeat.On<ChainBuilder> repeat(@NonNull Function<Session, Integer> function, @NonNull String string) {
        return ChainBuilder.EMPTY.repeat(function, string);
    }

    public static  @NonNull ForEach.On<ChainBuilder> foreach(@NonNull List<?> list, String string) {
        return ChainBuilder.EMPTY.foreach(list, string);
    }

    public static  @NonNull ForEach.On<ChainBuilder> foreach(@NonNull List<?> list, String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.foreach(list, string, string2);
    }

    public static  @NonNull ForEach.On<ChainBuilder> foreach(@NonNull String string, String string2) {
        return ChainBuilder.EMPTY.foreach(string, string2);
    }

    public static  @NonNull ForEach.On<ChainBuilder> foreach(@NonNull String string, String string2, @NonNull String string3) {
        return ChainBuilder.EMPTY.foreach(string, string2, string3);
    }

    public static  @NonNull ForEach.On<ChainBuilder> foreach(@NonNull Function<Session, List<?>> function, @NonNull String string) {
        return ChainBuilder.EMPTY.foreach(function, string);
    }

    public static  @NonNull ForEach.On<ChainBuilder> foreach(@NonNull Function<Session, List<?>> function, @NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.foreach(function, string, string2);
    }

    public static  @NonNull During.On<ChainBuilder> during(long l) {
        return ChainBuilder.EMPTY.during(l);
    }

    public static  @NonNull During.On<ChainBuilder> during(long l, boolean bl) {
        return ChainBuilder.EMPTY.during(l, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(long l, @NonNull String string) {
        return ChainBuilder.EMPTY.during(l, string);
    }

    public static  @NonNull During.On<ChainBuilder> during(long l, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(l, string, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Duration duration) {
        return ChainBuilder.EMPTY.during(duration);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Duration duration, @NonNull String string) {
        return ChainBuilder.EMPTY.during(duration, string);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Duration duration, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(duration, string, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull String string) {
        return ChainBuilder.EMPTY.during(string);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(string, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.during(string, string2);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.during(string, string2, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.during(function);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.during(function, bl);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function, @NonNull String string) {
        return ChainBuilder.EMPTY.during(function, string);
    }

    public static  @NonNull During.On<ChainBuilder> during(@NonNull Function<Session, Duration> function, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.during(function, string, bl);
    }

    public static  @NonNull Forever.On<ChainBuilder> forever() {
        return ChainBuilder.EMPTY.forever();
    }

    public static  @NonNull Forever.On<ChainBuilder> forever(@NonNull String string) {
        return ChainBuilder.EMPTY.forever(string);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string) {
        return ChainBuilder.EMPTY.asLongAs(string);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAs(string, string2);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, bl);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(string, string2, bl);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.asLongAs(function);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAs(function, string);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, bl);
    }

    public static  @NonNull AsLongAs.On<ChainBuilder> asLongAs(@NonNull Function<Session, Boolean> function, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAs(function, string, bl);
    }

    public static  @NonNull DoWhile.On<ChainBuilder> doWhile(@NonNull String string) {
        return ChainBuilder.EMPTY.doWhile(string);
    }

    public static  @NonNull DoWhile.On<ChainBuilder> doWhile(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhile(string, string2);
    }

    public static  @NonNull DoWhile.On<ChainBuilder> doWhile(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doWhile(function);
    }

    public static  @NonNull DoWhile.On<ChainBuilder> doWhile(@NonNull Function<Session, Boolean> function, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhile(function, string);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, string2);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, string2);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, string2);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull String string2, @NonNull String string3, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, string2, string3, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, long l, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, l, string2, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, duration, string2, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(string, function, string2, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, string);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, @NonNull String string) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, string);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, function2, string, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, long l, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, l, string, bl);
    }

    public static  @NonNull AsLongAsDuring.On<ChainBuilder> asLongAsDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, @NonNull String string, boolean bl) {
        return ChainBuilder.EMPTY.asLongAsDuring(function, duration, string, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, string2);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, string2);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, string2);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull String string2, @NonNull String string3, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, string2, string3, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, long l, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, l, string2, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Duration duration, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, duration, string2, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull String string, @NonNull Function<Session, Duration> function, @NonNull String string2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(string, function, string2, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, string);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, @NonNull String string) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, string);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Function<Session, Duration> function2, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, function2, string, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, long l, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, l, string, bl);
    }

    public static  @NonNull DoWhileDuring.On<ChainBuilder> doWhileDuring(@NonNull Function<Session, Boolean> function, @NonNull Duration duration, String string, boolean bl) {
        return ChainBuilder.EMPTY.doWhileDuring(function, duration, string, bl);
    }

    public static  @NonNull DoIf.Then<ChainBuilder> doIf(@NonNull String string) {
        return ChainBuilder.EMPTY.doIf(string);
    }

    public static  @NonNull DoIf.Then<ChainBuilder> doIf(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIf(function);
    }

    public static  @NonNull DoIfOrElse.Then<ChainBuilder> doIfOrElse(@NonNull String string) {
        return ChainBuilder.EMPTY.doIfOrElse(string);
    }

    public static  @NonNull DoIfOrElse.Then<ChainBuilder> doIfOrElse(@NonNull Function<Session, Boolean> function) {
        return ChainBuilder.EMPTY.doIfOrElse(function);
    }

    public static  @NonNull DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.doIfEquals(string, string2);
    }

    public static  @NonNull DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull String string, @NonNull Object object) {
        return ChainBuilder.EMPTY.doIfEquals(string, object);
    }

    public static  @NonNull DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull String string, @NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEquals(string, function);
    }

    public static  @NonNull DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull Function<Session, Object> function, @NonNull String string) {
        return ChainBuilder.EMPTY.doIfEquals(function, string);
    }

    public static  @NonNull DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull Function<Session, Object> function, Object object) {
        return ChainBuilder.EMPTY.doIfEquals(function, object);
    }

    public static  @NonNull DoIfEquals.Then<ChainBuilder> doIfEquals(@NonNull Function<Session, Object> function, @NonNull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEquals(function, function2);
    }

    public static  @NonNull DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(String string, String string2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, string2);
    }

    public static  @NonNull DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull String string, @NonNull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, object);
    }

    public static  @NonNull DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull String string, @NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(string, function);
    }

    public static  @NonNull DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull Function<Session, Object> function, @NonNull String string) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, string);
    }

    public static  @NonNull DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull Function<Session, Object> function, @NonNull Object object) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, object);
    }

    public static  @NonNull DoIfEqualsOrElse.Then<ChainBuilder> doIfEqualsOrElse(@NonNull Function<Session, Object> function, @NonNull Function<Session, Object> function2) {
        return ChainBuilder.EMPTY.doIfEqualsOrElse(function, function2);
    }

    public static  @NonNull DoSwitch.On<ChainBuilder> doSwitch(@NonNull String string) {
        return ChainBuilder.EMPTY.doSwitch(string);
    }

    public static  @NonNull DoSwitch.On<ChainBuilder> doSwitch(@NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitch(function);
    }

    public static  @NonNull DoSwitchOrElse.On<ChainBuilder> doSwitchOrElse(@NonNull String string) {
        return ChainBuilder.EMPTY.doSwitchOrElse(string);
    }

    public static  @NonNull DoSwitchOrElse.On<ChainBuilder> doSwitchOrElse(@NonNull Function<Session, Object> function) {
        return ChainBuilder.EMPTY.doSwitchOrElse(function);
    }

    public static  @NonNull RandomSwitch.On<ChainBuilder> randomSwitch() {
        return ChainBuilder.EMPTY.randomSwitch();
    }

    public static  @NonNull RandomSwitchOrElse.On<ChainBuilder> randomSwitchOrElse() {
        return ChainBuilder.EMPTY.randomSwitchOrElse();
    }

    public static  @NonNull UniformRandomSwitch.On<ChainBuilder> uniformRandomSwitch() {
        return ChainBuilder.EMPTY.uniformRandomSwitch();
    }

    public static  @NonNull RoundRobinSwitch.On<ChainBuilder> roundRobinSwitch() {
        return ChainBuilder.EMPTY.roundRobinSwitch();
    }

    public static  @NonNull Errors.ExitBlockOnFail<ChainBuilder> exitBlockOnFail() {
        return ChainBuilder.EMPTY.exitBlockOnFail();
    }

    public static  @NonNull Errors.TryMax<ChainBuilder> tryMax(int n) {
        return ChainBuilder.EMPTY.tryMax(n);
    }

    public static  @NonNull Errors.TryMax<ChainBuilder> tryMax(int n, @NonNull String string) {
        return ChainBuilder.EMPTY.tryMax(n, string);
    }

    public static  @NonNull Errors.TryMax<ChainBuilder> tryMax(@NonNull String string) {
        return ChainBuilder.EMPTY.tryMax(string);
    }

    public static  @NonNull Errors.TryMax<ChainBuilder> tryMax(@NonNull String string, @NonNull String string2) {
        return ChainBuilder.EMPTY.tryMax(string, string2);
    }

    public static  @NonNull Errors.TryMax<ChainBuilder> tryMax(@NonNull Function<Session, Integer> function) {
        return ChainBuilder.EMPTY.tryMax(function);
    }

    public static  @NonNull Errors.TryMax<ChainBuilder> tryMax(@NonNull Function<Session, Integer> function, @NonNull String string) {
        return ChainBuilder.EMPTY.tryMax(function, string);
    }

    public static @NonNull ChainBuilder exitHereIf(@NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(string);
    }

    public static @NonNull ChainBuilder exitHereIf(@NonNull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIf(function);
    }

    public static @NonNull ChainBuilder exitHere() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHere();
    }

    public static @NonNull ChainBuilder exitHereIfFailed() {
        return (ChainBuilder)ChainBuilder.EMPTY.exitHereIfFailed();
    }

    public static @NonNull ChainBuilder stopLoadGenerator(String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopLoadGenerator(string);
    }

    public static @NonNull ChainBuilder stopLoadGenerator(Function<Session, String> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopLoadGenerator(function);
    }

    public static @NonNull ChainBuilder stopLoadGeneratorIf(Function<Session, String> function, @NonNull Function<Session, Boolean> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopLoadGeneratorIf(function, function2);
    }

    public static @NonNull ChainBuilder stopLoadGeneratorIf(String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopLoadGeneratorIf(string, string2);
    }

    public static @NonNull ChainBuilder stopLoadGeneratorIf(String string, @NonNull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopLoadGeneratorIf(string, function);
    }

    public static @NonNull ChainBuilder stopLoadGeneratorIf(Function<Session, String> function, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.stopLoadGeneratorIf(function, string);
    }

    public static @NonNull ChainBuilder crashLoadGenerator(String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.crashLoadGenerator(string);
    }

    public static @NonNull ChainBuilder crashLoadGenerator(Function<Session, String> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.crashLoadGenerator(function);
    }

    public static @NonNull ChainBuilder crashLoadGeneratorIf(Function<Session, String> function, @NonNull Function<Session, Boolean> function2) {
        return (ChainBuilder)ChainBuilder.EMPTY.crashLoadGeneratorIf(function, function2);
    }

    public static @NonNull ChainBuilder crashLoadGeneratorIf(String string, @NonNull String string2) {
        return (ChainBuilder)ChainBuilder.EMPTY.crashLoadGeneratorIf(string, string2);
    }

    public static @NonNull ChainBuilder crashLoadGeneratorIf(String string, @NonNull Function<Session, Boolean> function) {
        return (ChainBuilder)ChainBuilder.EMPTY.crashLoadGeneratorIf(string, function);
    }

    public static @NonNull ChainBuilder crashLoadGeneratorIf(Function<Session, String> function, @NonNull String string) {
        return (ChainBuilder)ChainBuilder.EMPTY.crashLoadGeneratorIf(function, string);
    }

    public static  @NonNull Groups.On<ChainBuilder> group(@NonNull String string) {
        return ChainBuilder.EMPTY.group(string);
    }

    public static  @NonNull Groups.On<ChainBuilder> group(@NonNull Function<Session, String> function) {
        return ChainBuilder.EMPTY.group(function);
    }

    public static @NonNull PauseType normalPausesWithStdDevDuration(@NonNull Duration duration) {
        return new PauseType.NormalWithStdDevDuration(duration);
    }

    public static @NonNull PauseType normalPausesWithPercentageDuration(double d) {
        return new PauseType.NormalWithPercentageDuration(d);
    }

    public static @NonNull PauseType customPauses(@NonNull Function<Session, Long> function) {
        return new PauseType.Custom(function);
    }

    public static @NonNull PauseType uniformPausesPlusOrMinusPercentage(double d) {
        return new PauseType.UniformPercentage(d);
    }

    public static @NonNull PauseType uniformPausesPlusOrMinusDuration(@NonNull Duration duration) {
        return new PauseType.UniformDuration(duration);
    }

    public static @NonNull CheckBuilder.Find<String> bodyString() {
        return new CheckBuilder.Find.Default(Predef.bodyString(), CoreCheckType.BodyString, String.class, null);
    }

    public static @NonNull CheckBuilder.Find<byte[]> bodyBytes() {
        return new CheckBuilder.Find.Default(Predef.bodyBytes(), CoreCheckType.BodyBytes, byte[].class, null);
    }

    public static @NonNull CheckBuilder.Find<Integer> bodyLength() {
        return CoreCheckBuilders.bodyLength();
    }

    public static @NonNull CheckBuilder.Find<InputStream> bodyStream() {
        return new CheckBuilder.Find.Default(Predef.bodyStream(), CoreCheckType.BodyStream, InputStream.class, null);
    }

    public static @NonNull CheckBuilder.MultipleFind<Integer> substring(@NonNull String string) {
        return CoreCheckBuilders.substring(string);
    }

    public static @NonNull CheckBuilder.MultipleFind<Integer> substring(@NonNull Function<Session, String> function) {
        return CoreCheckBuilders.substring(function);
    }

    public static @NonNull CheckBuilder.MultipleFind<String> xpath(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.toStringExpression(string), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    public static @NonNull CheckBuilder.MultipleFind<String> xpath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.javaFunctionToExpression(function), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    public static @NonNull CheckBuilder.MultipleFind<String> xpath(@NonNull String string, @NonNull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.toStringExpression(string), Converters.toScalaMap(map), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    public static @NonNull CheckBuilder.MultipleFind<String> xpath(@NonNull Function<Session, String> function, @NonNull Map<String, String> map) {
        return new CheckBuilder.MultipleFind.Default(Predef.xpath(Expressions.javaFunctionToExpression(function), Converters.toScalaMap(map), (XmlParsers)Predef.defaultXmlParsers()), (CheckBuilder.CheckType)CoreCheckType.XPath, String.class, null);
    }

    public static @NonNull CheckBuilder.MultipleFind<String> css(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.css(Expressions.toStringExpression(string), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, String.class, null);
    }

    public static @NonNull CheckBuilder.MultipleFind<String> css(@NonNull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.css(Expressions.javaFunctionToExpression(function), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, String.class, null);
    }

    public static @NonNull CheckBuilder.CssOfTypeMultipleFind css(@NonNull String string, @NonNull String string2) {
        return new CheckBuilder.Css((CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String>)Predef.css(Expressions.toStringExpression(string), (String)string2, (CssSelectors)Predef.defaultCssSelectors()));
    }

    public static @NonNull CheckBuilder.CssOfTypeMultipleFind css(@NonNull Function<Session, String> function, @NonNull String string) {
        return new CheckBuilder.Css((CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String>)Predef.css(Expressions.javaFunctionToExpression(function), (String)string, (CssSelectors)Predef.defaultCssSelectors()));
    }

    public static @NonNull CheckBuilder.MultipleFind<Map<String, Object>> form(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.form(Expressions.toStringExpression(string), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Map.class, Converters::toJavaMap);
    }

    public static @NonNull CheckBuilder.MultipleFind<Map<String, Object>> form(@NonNull Function<Session, String> function) {
        return new CheckBuilder.MultipleFind.Default(Predef.form(Expressions.javaFunctionToExpression(function), (CssSelectors)Predef.defaultCssSelectors()), (CheckBuilder.CheckType)CoreCheckType.Css, Map.class, Converters::toJavaMap);
    }

    public static @NonNull CheckBuilder.JsonOfTypeMultipleFind jsonPath(@NonNull String string) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)Predef.jsonPath(Expressions.toStringExpression(string), (JsonPaths)Predef.defaultJsonPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeMultipleFind jsonPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JsonPath((CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String>)Predef.jsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)Predef.defaultJsonPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeFind jmesPath(@NonNull String string) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)Predef.jmesPath(Expressions.toStringExpression(string), (JmesPaths)Predef.defaultJmesPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeFind jmesPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JmesPath((CheckBuilder.Find<JmesPathCheckType, JsonNode, String>)Predef.jmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)Predef.defaultJmesPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@NonNull String string) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)Predef.jsonpJsonPath(Expressions.toStringExpression(string), (JsonPaths)Predef.defaultJsonPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeMultipleFind jsonpJsonPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JsonpJsonPath((CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String>)Predef.jsonpJsonPath(Expressions.javaFunctionToExpression(function), (JsonPaths)Predef.defaultJsonPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeFind jsonpJmesPath(@NonNull String string) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)Predef.jsonpJmesPath(Expressions.toStringExpression(string), (JmesPaths)Predef.defaultJmesPaths()));
    }

    public static @NonNull CheckBuilder.JsonOfTypeFind jsonpJmesPath(@NonNull Function<Session, String> function) {
        return new CheckBuilder.JsonpJmesPath((CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String>)Predef.jsonpJmesPath(Expressions.javaFunctionToExpression(function), (JmesPaths)Predef.defaultJmesPaths()));
    }

    public static @NonNull CheckBuilder.CaptureGroupCheckBuilder regex(@NonNull String string) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)Predef.regex(Expressions.toStringExpression(string), (Patterns)Predef.defaultPatterns()));
    }

    public static @NonNull CheckBuilder.CaptureGroupCheckBuilder regex(@NonNull Function<Session, String> function) {
        return new CheckBuilder.Regex((CheckBuilder.MultipleFind<RegexCheckType, String, String>)Predef.regex(Expressions.javaFunctionToExpression(function), (Patterns)Predef.defaultPatterns()));
    }

    public static void registerJmesPathFunctions(io.burt.jmespath.function.Function ... functionArray) {
        Predef.registerJmesPathFunctions(Converters.toScalaSeq(functionArray));
    }

    public static @NonNull CheckBuilder.Find<String> md5() {
        return new CheckBuilder.Find.Default(Predef.md5(), CoreCheckType.Md5, String.class, null);
    }

    public static @NonNull CheckBuilder.Find<String> sha1() {
        return new CheckBuilder.Find.Default(Predef.sha1(), CoreCheckType.Sha1, String.class, null);
    }

    public static @NonNull CheckBuilder.Find<Integer> responseTimeInMillis() {
        return CoreCheckBuilders.responseTimeInMillis();
    }

    public static @NonNull FeederBuilder.Batchable<String> csv(@NonNull String string) {
        return FeederBuilder.Impl.csv(string);
    }

    public static @NonNull FeederBuilder.Batchable<String> csv(@NonNull String string, char c) {
        return FeederBuilder.Impl.csv(string, c);
    }

    public static @NonNull FeederBuilder.Batchable<String> ssv(@NonNull String string) {
        return FeederBuilder.Impl.ssv(string);
    }

    public static @NonNull FeederBuilder.Batchable<String> ssv(@NonNull String string, char c) {
        return FeederBuilder.Impl.ssv(string, c);
    }

    public static @NonNull FeederBuilder.Batchable<String> tsv(@NonNull String string) {
        return FeederBuilder.Impl.tsv(string);
    }

    public static @NonNull FeederBuilder.Batchable<String> tsv(@NonNull String string, char c) {
        return FeederBuilder.Impl.tsv(string, c);
    }

    public static @NonNull FeederBuilder.Batchable<String> separatedValues(@NonNull String string, char c) {
        return FeederBuilder.Impl.separatedValues(string, c);
    }

    public static @NonNull FeederBuilder.Batchable<String> separatedValues(@NonNull String string, char c, char c2) {
        return FeederBuilder.Impl.separatedValues(string, c, c2);
    }

    public static @NonNull FeederBuilder.FileBased<Object> jsonFile(@NonNull String string) {
        return FeederBuilder.Impl.jsonFile(string);
    }

    public static @NonNull FeederBuilder<Object> jsonUrl(String string) {
        return FeederBuilder.Impl.jsonUrl(string);
    }

    public static @NonNull FeederBuilder<Object> arrayFeeder(@NonNull Map<String, Object>[] mapArray) {
        scala.collection.immutable.Map[] mapArray2 = (scala.collection.immutable.Map[])Arrays.stream(mapArray).map(Converters::toScalaMap).toArray(scala.collection.immutable.Map[]::new);
        return new FeederBuilder.Impl<Object>(Predef.array2FeederBuilder((scala.collection.immutable.Map[])mapArray2, (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull FeederBuilder<Object> listFeeder(@NonNull List<Map<String, Object>> list) {
        Seq seq = Converters.toScalaSeq(list.stream().map(Converters::toScalaMap).collect(Collectors.toList()));
        return new FeederBuilder.Impl<Object>(Predef.seq2FeederBuilder((IndexedSeq)seq.toIndexedSeq(), (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull OpenInjectionStep.Ramp rampUsers(int n) {
        return new OpenInjectionStep.Ramp(n);
    }

    public static @NonNull OpenInjectionStep.StressPeak stressPeakUsers(int n) {
        return new OpenInjectionStep.StressPeak(n);
    }

    public static @NonNull OpenInjectionStep atOnceUsers(int n) {
        return OpenInjectionStep.atOnceUsers(n);
    }

    public static @NonNull OpenInjectionStep.ConstantRate constantUsersPerSec(double d) {
        return new OpenInjectionStep.ConstantRate(d);
    }

    public static @NonNull OpenInjectionStep.RampRate rampUsersPerSec(double d) {
        return new OpenInjectionStep.RampRate(d);
    }

    public static @NonNull OpenInjectionStep nothingFor(long l) {
        return CoreDsl.nothingFor(Duration.ofSeconds(l));
    }

    public static @NonNull OpenInjectionStep nothingFor(@NonNull Duration duration) {
        return OpenInjectionStep.nothingFor(duration);
    }

    public static @NonNull OpenInjectionStep.Stairs incrementUsersPerSec(double d) {
        return new OpenInjectionStep.Stairs(d);
    }

    public static @NonNull ClosedInjectionStep.Constant constantConcurrentUsers(int n) {
        return new ClosedInjectionStep.Constant(n);
    }

    public static @NonNull ClosedInjectionStep.Ramp rampConcurrentUsers(int n) {
        return new ClosedInjectionStep.Ramp(n);
    }

    public static @NonNull ClosedInjectionStep.Stairs incrementConcurrentUsers(int n) {
        return new ClosedInjectionStep.Stairs(n);
    }

    public static @NonNull ThrottleStep.ReachIntermediate reachRps(int n) {
        return new ThrottleStep.ReachIntermediate(n);
    }

    public static @NonNull ThrottleStep holdFor(long l) {
        return CoreDsl.holdFor(Duration.ofSeconds(l));
    }

    public static @NonNull ThrottleStep holdFor(@NonNull Duration duration) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Hold(Converters.toScalaDuration(duration)));
    }

    public static @NonNull ThrottleStep jumpToRps(int n) {
        return new ThrottleStep((io.gatling.core.controller.throttle.ThrottleStep)new Jump(n));
    }

    public static @NonNull Assertion.WithPath global() {
        return new Assertion.WithPath((AssertionPath)AssertionPath.Global$.MODULE$);
    }

    public static @NonNull Assertion.WithPath forAll() {
        return new Assertion.WithPath((AssertionPath)AssertionPath.ForAll$.MODULE$);
    }

    public static @NonNull Assertion.WithPath details(String ... stringArray) {
        Seq seq = Converters.toScalaSeq(stringArray);
        return new Assertion.WithPath((AssertionPath)new AssertionPath.Details(seq.toList()));
    }

    public static @NonNull Body.WithString StringBody(@NonNull String string) {
        return new Body.WithString(Predef.StringBody((String)string, (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull Body.WithString StringBody(@NonNull Function<Session, String> function) {
        return new Body.WithString(Predef.StringBody(Expressions.javaFunctionToExpression(function), (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull Body.WithBytes RawFileBody(@NonNull String string) {
        return new Body.WithBytes(Predef.RawFileBody(Expressions.toStringExpression(string), (RawFileBodies)Predef.rawFileBodies()));
    }

    public static @NonNull Body.WithBytes RawFileBody(@NonNull Function<Session, String> function) {
        return new Body.WithBytes(Predef.RawFileBody(Expressions.javaFunctionToExpression(function), (RawFileBodies)Predef.rawFileBodies()));
    }

    public static @NonNull Body.WithString ElFileBody(@NonNull String string) {
        return new Body.WithString(Predef.ElFileBody(Expressions.toStringExpression(string), (ElFileBodies)Predef.elFileBodies()));
    }

    public static @NonNull Body.WithString ElFileBody(@NonNull Function<Session, String> function) {
        return new Body.WithString(Predef.ElFileBody(Expressions.javaFunctionToExpression(function), (ElFileBodies)Predef.elFileBodies()));
    }

    public static @NonNull Body.WithString PebbleStringBody(@NonNull String string) {
        return new Body.WithString(Predef.PebbleStringBody((String)string, (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull Body.WithString PebbleFileBody(@NonNull String string) {
        return new Body.WithString(Predef.PebbleFileBody(Expressions.toStringExpression(string), (PebbleFileBodies)Predef.pebbleFileBodies(), (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull Body.WithString PebbleFileBody(@NonNull Function<Session, String> function) {
        return new Body.WithString(Predef.PebbleFileBody(Expressions.javaFunctionToExpression(function), (PebbleFileBodies)Predef.pebbleFileBodies(), (GatlingConfiguration)Predef.configuration()));
    }

    public static @NonNull Body.WithBytes ByteArrayBody(byte[] byArray) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.toStaticValueExpression(byArray)));
    }

    public static @NonNull Body.WithBytes ByteArrayBody(@NonNull String string) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.toBytesExpression(string)));
    }

    public static @NonNull Body.WithBytes ByteArrayBody(@NonNull Function<Session, byte[]> function) {
        return new Body.WithBytes(Predef.ByteArrayBody(Expressions.javaFunctionToExpression(function)));
    }

    public static @NonNull Body InputStreamBody(@NonNull Function<Session, InputStream> function) {
        return new Body.Default(Predef.InputStreamBody(Expressions.javaFunctionToExpression(function)));
    }

    public static void registerPebbleExtensions(Extension ... extensionArray) {
        Predef.registerPebbleExtensions(Converters.toScalaSeq(extensionArray));
    }

    public static Choice.WithKey.Then onCase(@NonNull Object object) {
        return new Choice.WithKey.Then(object);
    }

    public static Choice.WithWeight.Then percent(double d) {
        return new Choice.WithWeight.Then(d);
    }

    public static DummyBuilder dummy(@NonNull String string, int n) {
        return new DummyBuilder(Expressions.toStringExpression(string), Expressions.toStaticValueExpression(n));
    }

    public static DummyBuilder dummy(@NonNull String string, @NonNull String string2) {
        return new DummyBuilder(Expressions.toStringExpression(string), Expressions.toIntExpression(string2));
    }

    public static DummyBuilder dummy(@NonNull String string, @NonNull Function<Session, Integer> function) {
        return new DummyBuilder(Expressions.toStringExpression(string), Expressions.javaIntegerFunctionToExpression(function));
    }

    public static DummyBuilder dummy(@NonNull Function<Session, String> function, int n) {
        return new DummyBuilder(Expressions.javaFunctionToExpression(function), Expressions.toStaticValueExpression(n));
    }

    public static DummyBuilder dummy(@NonNull Function<Session, String> function, @NonNull String string) {
        return new DummyBuilder(Expressions.javaFunctionToExpression(function), Expressions.toIntExpression(string));
    }

    public static DummyBuilder dummy(@NonNull Function<Session, String> function, @NonNull Function<Session, Integer> function2) {
        return new DummyBuilder(Expressions.javaFunctionToExpression(function), Expressions.javaIntegerFunctionToExpression(function2));
    }
}

