/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core.loop;

import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.StructureBuilder;
import io.gatling.javaapi.core.exec.Executable;
import io.gatling.javaapi.core.internal.Executables;
import io.gatling.javaapi.core.internal.loop.ScalaDuring;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public interface During<T extends StructureBuilder<T, W>, W extends io.gatling.core.structure.StructureBuilder<W>> {
    public T make(Function<W, W> var1);

    default public @NonNull On<T> during(long l) {
        return this.during(Duration.ofSeconds(l));
    }

    default public @NonNull On<T> during(long l, boolean bl) {
        return this.during(Duration.ofSeconds(l), bl);
    }

    default public @NonNull On<T> during(long l, String string) {
        return this.during(Duration.ofSeconds(l), string);
    }

    default public @NonNull On<T> during(long l, String string, boolean bl) {
        return this.during(Duration.ofSeconds(l), string, bl);
    }

    default public @NonNull On<T> during(@NonNull Duration duration) {
        return this.during((Session session) -> duration);
    }

    default public @NonNull On<T> during(@NonNull Duration duration, boolean bl) {
        return this.during((Session session) -> duration, bl);
    }

    default public @NonNull On<T> during(@NonNull Duration duration, @NonNull String string) {
        return this.during((Session session) -> duration, string, true);
    }

    default public @NonNull On<T> during(@NonNull Duration duration, @NonNull String string, boolean bl) {
        return new On(ScalaDuring.apply(this, duration, string, bl));
    }

    default public @NonNull On<T> during(@NonNull String string) {
        return this.during(string, UUID.randomUUID().toString());
    }

    default public @NonNull On<T> during(@NonNull String string, boolean bl) {
        return this.during(string, UUID.randomUUID().toString(), bl);
    }

    default public @NonNull On<T> during(@NonNull String string, @NonNull String string2) {
        return this.during(string, string2, true);
    }

    default public @NonNull On<T> during(@NonNull String string, @NonNull String string2, boolean bl) {
        return new On(ScalaDuring.apply(this, string, string2, bl));
    }

    default public @NonNull On<T> during(@NonNull Function<Session, Duration> function) {
        return this.during(function, UUID.randomUUID().toString());
    }

    default public @NonNull On<T> during(@NonNull Function<Session, Duration> function, boolean bl) {
        return this.during(function, UUID.randomUUID().toString(), bl);
    }

    default public @NonNull On<T> during(@NonNull Function<Session, Duration> function, @NonNull String string) {
        return this.during(function, string, true);
    }

    default public @NonNull On<T> during(@NonNull Function<Session, Duration> function, @NonNull String string, boolean bl) {
        return new On(ScalaDuring.apply(this, function, string, bl));
    }

    public static final class On<T extends StructureBuilder<T, ?>> {
        private final ScalaDuring.Loop<T, ?> wrapped;

        On(ScalaDuring.Loop<T, ?> loop) {
            this.wrapped = loop;
        }

        public @NonNull T on(@NonNull Executable executable, Executable ... executableArray) {
            return this.wrapped.loop(Executables.toChainBuilder(executable, executableArray));
        }
    }
}

