/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.Resource;
import io.gatling.core.config.Resource$;
import io.gatling.core.feeder.FeederBuilder;
import io.gatling.core.feeder.FeederSupport;
import io.gatling.core.feeder.FeederWrapper;
import io.gatling.core.feeder.JsonFeederFileParser;
import io.gatling.core.feeder.RecordSeqFeederBuilder;
import io.gatling.core.feeder.RecordSeqFeederBuilder$;
import io.gatling.core.feeder.SeparatedValuesParser$;
import io.gatling.core.json.JsonParsers;
import io.gatling.core.validation.Failure;
import io.gatling.core.validation.Success;
import io.gatling.core.validation.Validation;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public abstract class FeederSupport$class {
    public static RecordSeqFeederBuilder seq2FeederBuilder(FeederSupport $this, IndexedSeq data) {
        return new RecordSeqFeederBuilder(data, RecordSeqFeederBuilder$.MODULE$.apply$default$2());
    }

    public static RecordSeqFeederBuilder array2FeederBuilder(FeederSupport $this, Map[] data) {
        return new RecordSeqFeederBuilder(Predef$.MODULE$.wrapRefArray((Object[])data), RecordSeqFeederBuilder$.MODULE$.apply$default$2());
    }

    public static FeederBuilder feeder2FeederBuilder(FeederSupport $this, Iterator feeder) {
        return new FeederWrapper(feeder);
    }

    public static RecordSeqFeederBuilder csv(FeederSupport $this, String fileName, boolean rawSplit, GatlingConfiguration configuration) {
        String x$2 = fileName;
        char x$3 = SeparatedValuesParser$.MODULE$.CommaSeparator();
        boolean x$4 = rawSplit;
        char x$5 = $this.separatedValues$default$3();
        return $this.separatedValues(x$2, x$3, x$5, x$4, configuration);
    }

    public static boolean csv$default$2(FeederSupport $this) {
        return false;
    }

    public static RecordSeqFeederBuilder ssv(FeederSupport $this, String fileName, boolean rawSplit, GatlingConfiguration configuration) {
        String x$6 = fileName;
        char x$7 = SeparatedValuesParser$.MODULE$.SemicolonSeparator();
        boolean x$8 = rawSplit;
        char x$9 = $this.separatedValues$default$3();
        return $this.separatedValues(x$6, x$7, x$9, x$8, configuration);
    }

    public static boolean ssv$default$2(FeederSupport $this) {
        return false;
    }

    public static RecordSeqFeederBuilder tsv(FeederSupport $this, String fileName, boolean rawSplit, GatlingConfiguration configuration) {
        String x$10 = fileName;
        char x$11 = SeparatedValuesParser$.MODULE$.TabulationSeparator();
        boolean x$12 = rawSplit;
        char x$13 = $this.separatedValues$default$3();
        return $this.separatedValues(x$10, x$11, x$13, x$12, configuration);
    }

    public static boolean tsv$default$2(FeederSupport $this) {
        return false;
    }

    public static RecordSeqFeederBuilder separatedValues(FeederSupport $this, String fileName, char separator, char quoteChar, boolean rawSplit, GatlingConfiguration configuration) {
        return $this.separatedValues(Resource$.MODULE$.feeder(fileName, configuration), separator, quoteChar, rawSplit, configuration);
    }

    public static RecordSeqFeederBuilder separatedValues(FeederSupport $this, Validation resource, char separator, char quoteChar, boolean rawSplit, GatlingConfiguration configuration) {
        return $this.feederBuilder(resource, new Serializable($this, separator, quoteChar, rawSplit, configuration){
            public static final long serialVersionUID = 0L;
            private final char separator$1;
            private final char quoteChar$1;
            private final boolean rawSplit$1;
            private final GatlingConfiguration configuration$1;

            public final IndexedSeq<Map<String, String>> apply(Resource x$1) {
                return SeparatedValuesParser$.MODULE$.parse(x$1, this.separator$1, this.quoteChar$1, this.rawSplit$1, this.configuration$1);
            }
            {
                this.separator$1 = separator$1;
                this.quoteChar$1 = quoteChar$1;
                this.rawSplit$1 = rawSplit$1;
                this.configuration$1 = configuration$1;
            }
        });
    }

    public static char separatedValues$default$3(FeederSupport $this) {
        return '\"';
    }

    public static boolean separatedValues$default$4(FeederSupport $this) {
        return false;
    }

    public static RecordSeqFeederBuilder jsonFile(FeederSupport $this, String fileName, GatlingConfiguration configuration, JsonParsers jsonParsers) {
        return $this.jsonFile(Resource$.MODULE$.feeder(fileName, configuration), jsonParsers);
    }

    public static RecordSeqFeederBuilder jsonFile(FeederSupport $this, Validation resource, JsonParsers jsonParsers) {
        JsonFeederFileParser jsonFeederFileParser = new JsonFeederFileParser(jsonParsers);
        return $this.feederBuilder(resource, new Serializable($this, jsonFeederFileParser){
            public static final long serialVersionUID = 0L;
            private final JsonFeederFileParser eta$0$1$1;

            public final IndexedSeq<Map<String, Object>> apply(Resource resource) {
                return this.eta$0$1$1.parse(resource);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public static RecordSeqFeederBuilder feederBuilder(FeederSupport $this, Validation resource, Function1 recordParser) {
        Validation validation = resource;
        if (validation instanceof Success) {
            Success success = (Success)validation;
            Resource res = (Resource)success.value();
            RecordSeqFeederBuilder recordSeqFeederBuilder = new RecordSeqFeederBuilder((IndexedSeq)recordParser.apply((Object)res), RecordSeqFeederBuilder$.MODULE$.apply$default$2());
            return recordSeqFeederBuilder;
        }
        if (validation instanceof Failure) {
            Failure failure = (Failure)validation;
            String message = failure.message();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not locate feeder file; ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
        }
        throw new MatchError((Object)validation);
    }

    public static RecordSeqFeederBuilder jsonUrl(FeederSupport $this, String url2, JsonParsers jsonParsers) {
        return new RecordSeqFeederBuilder<Object>(new JsonFeederFileParser(jsonParsers).url(url2), RecordSeqFeederBuilder$.MODULE$.apply$default$2());
    }

    public static void $init$(FeederSupport $this) {
    }
}

