/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.result.writer;

import akka.actor.ActorRef;
import io.gatling.core.result.message.End$;
import io.gatling.core.result.message.MessageEvent;
import io.gatling.core.result.message.Start$;
import io.gatling.core.result.writer.DataWriter;
import io.gatling.core.result.writer.DataWriterMessage;
import io.gatling.core.result.writer.ErrorMessage;
import io.gatling.core.result.writer.Flush$;
import io.gatling.core.result.writer.GroupMessage;
import io.gatling.core.result.writer.Init;
import io.gatling.core.result.writer.LeakData;
import io.gatling.core.result.writer.LoadEventMessage;
import io.gatling.core.result.writer.RequestMessage;
import io.gatling.core.result.writer.ResponseMessage;
import io.gatling.core.result.writer.UserMessage;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u00015\u0011a\u0003T3bWJ+\u0007o\u001c:uKJ$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u0007\u0011\taa\u001e:ji\u0016\u0014(BA\u0003\u0007\u0003\u0019\u0011Xm];mi*\u0011q\u0001C\u0001\u0005G>\u0014XM\u0003\u0002\n\u0015\u00059q-\u0019;mS:<'\"A\u0006\u0002\u0005%|7\u0001A\n\u0003\u00019\u00012a\u0004\t\u0013\u001b\u0005\u0011\u0011BA\t\u0003\u0005)!\u0015\r^1Xe&$XM\u001d\t\u0003\u001fMI!\u0001\u0006\u0002\u0003\u00111+\u0017m\u001b#bi\u0006DQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtD#\u0001\r\u0011\u0005=\u0001\u0001b\u0002\u000e\u0001\u0005\u0004%IaG\u0001\u000fM2,8\u000f\u001b+j[\u0016\u0014h*Y7f+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u0007'R\u0014\u0018N\\4\t\r\u0015\u0002\u0001\u0015!\u0003\u001d\u0003=1G.^:i)&lWM\u001d(b[\u0016\u0004\u0003\"B\u0014\u0001\t\u0003A\u0013AB8o\u0013:LG\u000fF\u0002\u0013S9BQA\u000b\u0014A\u0002-\nA!\u001b8jiB\u0011q\u0002L\u0005\u0003[\t\u0011A!\u00138ji\")qF\na\u0001a\u0005Q1m\u001c8ue>dG.\u001a:\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!B1di>\u0014(\"A\u001b\u0002\t\u0005\\7.Y\u0005\u0003oI\u0012\u0001\"Q2u_J\u0014VM\u001a\u0005\u0006s\u0001!\tEO\u0001\b_:4E.^:i)\tY\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003V]&$\b\"\u0002\"9\u0001\u0004\u0011\u0012\u0001\u00023bi\u0006DQ\u0001\u0012\u0001\u0005\n\u0015\u000bQb\u001c8Vg\u0016\u0014X*Z:tC\u001e,GcA\u001eG\u0017\")qi\u0011a\u0001\u0011\u0006!Qo]3s!\ty\u0011*\u0003\u0002K\u0005\tYQk]3s\u001b\u0016\u001c8/Y4f\u0011\u0015\u00115\t1\u0001\u0013\u0011\u0015i\u0005\u0001\"\u0003O\u00039ygn\u0012:pkBlUm]:bO\u0016$2aO(U\u0011\u0015\u0001F\n1\u0001R\u0003\u00159'o\\;q!\ty!+\u0003\u0002T\u0005\taqI]8va6+7o]1hK\")!\t\u0014a\u0001%!)a\u000b\u0001C\u0005/\u0006\u0001rN\u001c*fcV,7\u000f^'fgN\fw-\u001a\u000b\u0004wak\u0006\"B-V\u0001\u0004Q\u0016a\u0002:fcV,7\u000f\u001e\t\u0003\u001fmK!\u0001\u0018\u0002\u0003\u001dI+\u0017/^3ti6+7o]1hK\")!)\u0016a\u0001%!)q\f\u0001C\u0005A\u0006\trN\u001c*fgB|gn]3NKN\u001c\u0018mZ3\u0015\u0007m\ng\rC\u0003c=\u0002\u00071-\u0001\u0005sKN\u0004xN\\:f!\tyA-\u0003\u0002f\u0005\ty!+Z:q_:\u001cX-T3tg\u0006<W\rC\u0003C=\u0002\u0007!\u0003C\u0003i\u0001\u0011\u0005\u0013.A\u0005p]6+7o]1hKR\u00191H[8\t\u000b-<\u0007\u0019\u00017\u0002\u000f5,7o]1hKB\u0011q\"\\\u0005\u0003]\n\u0011\u0001\u0003T8bI\u00163XM\u001c;NKN\u001c\u0018mZ3\t\u000b\t;\u0007\u0019\u0001\n\t\u000bE\u0004A\u0011\t:\u0002\u000f=t7I]1tQR\u00191h]>\t\u000bQ\u0004\b\u0019A;\u0002\u000b\r\fWo]3\u0011\u0005YLhB\u0001\u001fx\u0013\tAX(\u0001\u0004Qe\u0016$WMZ\u0005\u0003GiT!\u0001_\u001f\t\u000b\t\u0003\b\u0019\u0001\n\t\u000bu\u0004A\u0011\t@\u0002\u0017=tG+\u001a:nS:\fG/\u001a\u000b\u0003w}DQA\u0011?A\u0002I\u0001")
public class LeakReporterDataWriter
extends DataWriter<LeakData> {
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    public LeakData onInit(Init init, ActorRef controller) {
        FiniteDuration noActivityTimeout = new package.DurationInt(package$.MODULE$.DurationInt(init.configuration().data().leak().noActivityTimeout())).seconds();
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, noActivityTimeout, true);
        return new LeakData(noActivityTimeout, System.currentTimeMillis(), (Map<String, DataWriterMessage>)Map$.MODULE$.empty());
    }

    public void onFlush(LeakData data) {
        long timeSinceLastTouch = (System.currentTimeMillis() - data.lastTouch()) / 1000L;
        if (timeSinceLastTouch > data.noActivityTimeout().toSeconds() && data.events().nonEmpty()) {
            System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Gatling had no activity during last ", ". It could be a virtual user leak, here's their last events:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{data.noActivityTimeout()})));
            data.events().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x$1) {
                    System.err.println(x$1);
                }
            });
        }
    }

    private void onUserMessage(UserMessage user, LeakData data) {
        MessageEvent messageEvent;
        block4: {
            block3: {
                block2: {
                    data.lastTouch_$eq(System.currentTimeMillis());
                    messageEvent = user.event();
                    if (!Start$.MODULE$.equals(messageEvent)) break block2;
                    data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)user.session().userId()), (Object)user));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!End$.MODULE$.equals(messageEvent)) break block4;
                data.events().$minus$eq((Object)user.session().userId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)messageEvent);
    }

    private void onGroupMessage(GroupMessage group, LeakData data) {
        data.lastTouch_$eq(System.currentTimeMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group.userId()), (Object)group));
    }

    private void onRequestMessage(RequestMessage request, LeakData data) {
        data.lastTouch_$eq(System.currentTimeMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)request.userId()), (Object)request));
    }

    private void onResponseMessage(ResponseMessage response, LeakData data) {
        data.lastTouch_$eq(System.currentTimeMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.userId()), (Object)response));
    }

    public void onMessage(LoadEventMessage message, LeakData data) {
        LoadEventMessage loadEventMessage;
        block7: {
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                loadEventMessage = message;
                                if (!(loadEventMessage instanceof UserMessage)) break block2;
                                UserMessage userMessage = (UserMessage)loadEventMessage;
                                this.onUserMessage(userMessage, data);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(loadEventMessage instanceof GroupMessage)) break block4;
                            GroupMessage groupMessage = (GroupMessage)loadEventMessage;
                            this.onGroupMessage(groupMessage, data);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(loadEventMessage instanceof RequestMessage)) break block5;
                        RequestMessage requestMessage = (RequestMessage)loadEventMessage;
                        this.onRequestMessage(requestMessage, data);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(loadEventMessage instanceof ResponseMessage)) break block6;
                    ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
                    this.onResponseMessage(responseMessage, data);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(loadEventMessage instanceof ErrorMessage)) break block7;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)loadEventMessage);
    }

    public void onCrash(String cause, LeakData data) {
    }

    public void onTerminate(LeakData data) {
        this.cancelTimer(this.flushTimerName());
    }

    public LeakReporterDataWriter() {
        super(ClassTag$.MODULE$.apply(LeakData.class));
        this.flushTimerName = "flushTimer";
    }
}

