/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.runner;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.action.UserEnd$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.Protocol;
import io.gatling.core.config.Protocols;
import io.gatling.core.config.Protocols$;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.Run;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.funspec.GatlingFunSpec;
import io.gatling.core.result.writer.DefaultStatsEngineFactory;
import io.gatling.core.result.writer.RunMessage;
import io.gatling.core.result.writer.StatsEngine;
import io.gatling.core.runner.RunResult;
import io.gatling.core.runner.Selection;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.scenario.SimulationDef;
import io.gatling.core.util.TimeHelper$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u0017\t1!+\u001e8oKJT!a\u0001\u0003\u0002\rI,hN\\3s\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u001b\u001b\u0005!\"BA\u000b\u0017\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t9\u0002$\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0012aA2p[&\u00111\u0004\u0006\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0011b]3mK\u000e$\u0018n\u001c8\u0011\u0005}\u0001S\"\u0001\u0002\n\u0005\u0005\u0012!!C*fY\u0016\u001cG/[8o\u0011!\u0019\u0003A!A!\u0002\u0017!\u0013!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511m\u001c8gS\u001eL!!\u000b\u0014\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\u0011Q\u0006\r\u000b\u0003]=\u0002\"a\b\u0001\t\u000b\rR\u00039\u0001\u0013\t\u000buQ\u0003\u0019\u0001\u0010\t\u000bI\u0002A\u0011A\u001a\u0002\u0007I,h.F\u00015!\tyR'\u0003\u00027\u0005\tI!+\u001e8SKN,H\u000e\u001e")
public class Runner
implements StrictLogging {
    private final Selection selection;
    private final GatlingConfiguration configuration;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public RunResult run() {
        Try try_;
        block6: {
            RunResult runResult;
            ActorSystem system = ActorSystem$.MODULE$.apply("GatlingSystem");
            try {
                RunResult runResult2;
                Try res;
                Object object;
                Simulation simulation;
                Class<Simulation> simulationClass = this.selection.simulationClass();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simulation ", " started..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulationClass.getName()})));
                long timeRef = TimeHelper$.MODULE$.NanoTimeReference();
                Simulation simulation2 = simulation = simulationClass.newInstance();
                if (simulation2 instanceof GatlingFunSpec) {
                    GatlingFunSpec gatlingFunSpec = (GatlingFunSpec)simulation2;
                    object = gatlingFunSpec.setupRegisteredSpecs();
                } else {
                    object = BoxedUnit.UNIT;
                }
                simulation._beforeSteps().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function0<BoxedUnit> x$1) {
                        x$1.apply$mcV$sp();
                    }
                });
                RunMessage runMessage = new RunMessage(this.selection.simulationClass().getName(), this.selection.simulationId(), TimeHelper$.MODULE$.nowMillis(), this.selection.description());
                Future<Try<StatsEngine>> statsEngineInit = new DefaultStatsEngineFactory().apply(system, simulation._populationBuilders(), simulation._assertions(), this.selection, runMessage, this.configuration);
                StatsEngine statsEngine = (StatsEngine)((Try)Await$.MODULE$.result(statsEngineInit, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds())).get();
                ActorRef controller = system.actorOf(Controller$.MODULE$.props(this.selection, statsEngine, this.configuration), "gatling-controller");
                ActorRef userEnd = system.actorOf(UserEnd$.MODULE$.props(controller), "userEnd");
                SimulationDef simulationDef = simulation.build(system, controller, statsEngine, userEnd, this.configuration);
                Throttler throttler = Throttler$.MODULE$.apply(system, simulationDef, "throttler");
                ((Protocols)simulationDef.scenarios().foldLeft((Object)Protocols$.MODULE$.apply((Seq<Protocol>)Nil$.MODULE$), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Protocols apply(Protocols protocols, Scenario scenario) {
                        return protocols.$plus$plus(scenario.ctx().protocols());
                    }
                })).warmUp(system, statsEngine, throttler, this.configuration);
                System.gc();
                System.gc();
                System.gc();
                FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
                Future runResult3 = AskableActorRef$.MODULE$.ask$extension(akka.pattern.package$.MODULE$.ask(controller), (Object)new Run(simulationDef), Timeout$.MODULE$.durationToTimeout(timeout)).mapTo(ClassTag$.MODULE$.apply(Try.class));
                try_ = res = (Try)Await$.MODULE$.result((Awaitable)runResult3, (Duration)timeout);
                if (!(try_ instanceof Success)) break block6;
                Predef$.MODULE$.println((Object)"Simulation finished");
                simulation._afterSteps().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function0<BoxedUnit> x$2) {
                        x$2.apply$mcV$sp();
                    }
                });
                runResult = runResult2 = new RunResult(runMessage.runId(), simulationDef.assertions().nonEmpty());
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.shutdown();
                var1_1.awaitTermination();
                throw throwable;
            }
            system.shutdown();
            system.awaitTermination();
            return runResult;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        throw new MatchError((Object)try_);
    }

    public Runner(Selection selection, GatlingConfiguration configuration) {
        this.selection = selection;
        this.configuration = configuration;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

