/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.util;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0003\u0017\tAb)Y:u\u0005V4g-\u001a:fI>+H\u000f];u'R\u0014X-Y7\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\t\r|'/\u001a\u0006\u0003\u000f!\tqaZ1uY&twMC\u0001\n\u0003\tIwn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'ii\u0011\u0001\u0006\u0006\u0003+Y\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0006\r\u0002\u0011QL\b/Z:bM\u0016T\u0011!G\u0001\u0004G>l\u0017BA\u000e\u0015\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011u\u0001!\u0011!Q\u0001\ny\t!a\\:\u0011\u0005}\u0019S\"\u0001\u0011\u000b\u0005%\t#\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I\u0001\u0012AbT;uaV$8\u000b\u001e:fC6D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u000bEV4g-\u001a:TSj,\u0007CA\u0007)\u0013\tIcBA\u0002J]RDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDcA\u00170aA\u0011a\u0006A\u0007\u0002\u0005!)QD\u000ba\u0001=!)aE\u000ba\u0001O!9!\u0007\u0001a\u0001\n\u0013\u0019\u0014A\u00042vM\u001a,'\u000fU8tSRLwN\\\u000b\u0002O!9Q\u0007\u0001a\u0001\n\u00131\u0014A\u00052vM\u001a,'\u000fU8tSRLwN\\0%KF$\"a\u000e\u001e\u0011\u00055A\u0014BA\u001d\u000f\u0005\u0011)f.\u001b;\t\u000fm\"\u0014\u0011!a\u0001O\u0005\u0019\u0001\u0010J\u0019\t\ru\u0002\u0001\u0015)\u0003(\u0003=\u0011WO\u001a4feB{7/\u001b;j_:\u0004\u0003bB \u0001\u0005\u0004%I\u0001Q\u0001\u0007EV4g-\u001a:\u0016\u0003\u0005\u00032!\u0004\"E\u0013\t\u0019eBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000e\u000b&\u0011aI\u0004\u0002\u0005\u0005f$X\r\u0003\u0004I\u0001\u0001\u0006I!Q\u0001\bEV4g-\u001a:!\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u00151G.^:i)\u00059\u0004\"B'\u0001\t\u0003q\u0015!B<sSR,GCA\u001cP\u0011\u0015\u0001F\n1\u0001B\u0003\u0015\u0011\u0017\u0010^3t\u0001")
public final class FastBufferedOutputStream
implements LazyLogging {
    private final OutputStream os;
    private final int bufferSize;
    private int bufferPosition;
    private final byte[] buffer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FastBufferedOutputStream fastBufferedOutputStream = this;
        synchronized (fastBufferedOutputStream) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private int bufferPosition() {
        return this.bufferPosition;
    }

    private void bufferPosition_$eq(int x$1) {
        this.bufferPosition = x$1;
    }

    private byte[] buffer() {
        return this.buffer;
    }

    public void flush() {
        this.os.write(this.buffer(), 0, this.bufferPosition());
        this.bufferPosition_$eq(0);
    }

    public void write(byte[] bytes) {
        if (bytes.length + this.bufferPosition() > this.bufferSize) {
            this.flush();
        }
        if (bytes.length > this.bufferSize) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Buffer size ", " is not sufficient for message of size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.bufferSize), BoxesRunTime.boxToInteger((int)bytes.length)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.os.write(bytes);
        } else {
            System.arraycopy(bytes, 0, this.buffer(), this.bufferPosition(), bytes.length);
            this.bufferPosition_$eq(this.bufferPosition() + bytes.length);
        }
    }

    public FastBufferedOutputStream(OutputStream os, int bufferSize) {
        this.os = os;
        this.bufferSize = bufferSize;
        LazyLogging.class.$init$((LazyLogging)this);
        this.bufferPosition = 0;
        this.buffer = new byte[bufferSize];
    }
}

