/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.check.extractor.xpath;

import io.gatling.commons.validation.package;
import io.gatling.core.check.extractor.CriterionExtractor;
import io.gatling.core.check.extractor.CriterionExtractorFactory;
import io.gatling.core.check.extractor.package$;
import io.gatling.core.check.extractor.package$LiftedSeqOption$;
import io.gatling.core.check.extractor.xpath.Dom;
import io.gatling.core.check.extractor.xpath.JdkDom;
import io.gatling.core.check.extractor.xpath.SaxonDom;
import io.gatling.core.check.extractor.xpath.XmlParsers;
import java.io.Serializable;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.w3c.dom.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;

public final class XPathExtractorFactory$
extends CriterionExtractorFactory<Option<Dom>, Tuple2<String, List<Tuple2<String, String>>>> {
    public static XPathExtractorFactory$ MODULE$;

    static {
        new XPathExtractorFactory$();
    }

    public CriterionExtractor<Option<Dom>, Tuple2<String, List<Tuple2<String, String>>>, String> newXpathSingleExtractor(String path, List<Tuple2<String, String>> namespaces, int occurrence, XmlParsers xmlParsers) {
        return this.newSingleExtractor(new Tuple2((Object)path, namespaces), occurrence, (Function1 & Serializable & scala.Serializable)x$1 -> package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)x$1.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            None$ none$;
            Dom dom = x0$1;
            if (dom instanceof SaxonDom) {
                SaxonDom saxonDom = (SaxonDom)dom;
                XdmNode document = saxonDom.document();
                XdmValue xdmValue = xmlParsers.saxon().evaluateXPath(path, namespaces, document);
                none$ = occurrence < xdmValue.size() ? new Some((Object)xdmValue.itemAt(occurrence).getStringValue()) : None$.MODULE$;
            } else if (dom instanceof JdkDom) {
                JdkDom jdkDom = (JdkDom)dom;
                Document document = jdkDom.document();
                none$ = (Option)xmlParsers.jdk().extractAll(document, path, namespaces).lift().apply((Object)BoxesRunTime.boxToInteger((int)occurrence));
            } else {
                throw new MatchError((Object)dom);
            }
            return none$;
        }))));
    }

    public CriterionExtractor<Option<Dom>, Tuple2<String, List<Tuple2<String, String>>>, Seq<String>> newXpathMultipleExtractor(String path, List<Tuple2<String, String>> namespaces, XmlParsers xmlParsers) {
        return this.newMultipleExtractor(new Tuple2((Object)path, namespaces), (Function1 & Serializable & scala.Serializable)x$2 -> package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)x$2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            None$ none$;
            Dom dom = x0$2;
            if (dom instanceof SaxonDom) {
                SaxonDom saxonDom = (SaxonDom)dom;
                XdmNode document = saxonDom.document();
                Iterable xdmValue = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)xmlParsers.saxon().evaluateXPath(path, namespaces, document)).asScala();
                none$ = xdmValue.nonEmpty() ? new Some((Object)((TraversableOnce)xdmValue.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getStringValue(), Iterable$.MODULE$.canBuildFrom())).toVector()) : None$.MODULE$;
            } else if (dom instanceof JdkDom) {
                JdkDom jdkDom = (JdkDom)dom;
                Document document = jdkDom.document();
                none$ = package$LiftedSeqOption$.MODULE$.liftSeqOption$extension(package$.MODULE$.LiftedSeqOption(xmlParsers.jdk().extractAll(document, path, namespaces)));
            } else {
                throw new MatchError((Object)dom);
            }
            return none$;
        }))));
    }

    public CriterionExtractor<Option<Dom>, Tuple2<String, List<Tuple2<String, String>>>, Object> newXpathCountExtractor(String path, List<Tuple2<String, String>> namespaces, XmlParsers xmlParsers) {
        return this.newCountExtractor(new Tuple2((Object)path, namespaces), (Function1 & Serializable & scala.Serializable)x$4 -> package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)x$4.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)XPathExtractorFactory$.$anonfun$newXpathCountExtractor$2(path, namespaces, xmlParsers, x0$3))).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)0))))));
    }

    public static final /* synthetic */ int $anonfun$newXpathCountExtractor$2(String path$3, List namespaces$3, XmlParsers xmlParsers$3, Dom x0$3) {
        int n;
        Dom dom = x0$3;
        if (dom instanceof SaxonDom) {
            SaxonDom saxonDom = (SaxonDom)dom;
            XdmNode document = saxonDom.document();
            n = xmlParsers$3.saxon().evaluateXPath(path$3, (List<Tuple2<String, String>>)namespaces$3, document).size();
        } else if (dom instanceof JdkDom) {
            JdkDom jdkDom = (JdkDom)dom;
            Document document = jdkDom.document();
            n = xmlParsers$3.jdk().nodeList(document, path$3, (List<Tuple2<String, String>>)namespaces$3).getLength();
        } else {
            throw new MatchError((Object)dom);
        }
        return n;
    }

    private XPathExtractorFactory$() {
        super("xpath");
        MODULE$ = this;
    }
}

