/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.util.Integers;
import io.gatling.core.util.Longs;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%r!B\u0001\u0003\u0011\u0003i\u0011!\u0007\"vM\u001a,'/\u001a3GS2,7\t[1o]\u0016dwK]5uKJT!a\u0001\u0003\u0002\r]\u0014\u0018\u000e^3s\u0015\t)a!A\u0003ti\u0006$8O\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\tI!\"A\u0004hCRd\u0017N\\4\u000b\u0003-\t!![8\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tI\")\u001e4gKJ,GMR5mK\u000eC\u0017M\u001c8fY^\u0013\u0018\u000e^3s'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AQ\u0001H\b\u0005\u0002u\tQ!\u00199qYf$RAHA\u000b\u00033\u0001\"AD\u0010\u0007\tA\u0011!\u0001I\n\u0005?\u0005JC\u0006\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\r=\u0013'.Z2u!\t\u0011#&\u0003\u0002,G\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005E\u0012\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003M\n1aY8n\u0013\t)dFA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\to}\u0011\t\u0011)A\u0005q\u000591\r[1o]\u0016d\u0007CA\u001d?\u001b\u0005Q$BA\u001e=\u0003!\u0019\u0007.\u00198oK2\u001c(BA\u001f&\u0003\rq\u0017n\\\u0005\u0003\u007fi\u00121BR5mK\u000eC\u0017M\u001c8fY\"A\u0011i\bB\u0001B\u0003%!)A\u0004f]\u000e|G-\u001a:\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015c\u0014aB2iCJ\u001cX\r^\u0005\u0003\u000f\u0012\u0013ab\u00115beN,G/\u00128d_\u0012,'\u000f\u0003\u0005J?\t\u0005\t\u0015!\u0003K\u0003\t\u0011'\r\u0005\u0002L\u00196\tA(\u0003\u0002Ny\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000beyB\u0011A(\u0015\ty\u0001\u0016K\u0015\u0005\u0006o9\u0003\r\u0001\u000f\u0005\u0006\u0003:\u0003\rA\u0011\u0005\u0006\u0013:\u0003\rA\u0013\u0005\u0006)~!\t!V\u0001\u0006M2,8\u000f\u001b\u000b\u0002-B\u00111cV\u0005\u00031R\u0011A!\u00168ji\")!l\bC\u00057\u0006qQM\\:ve\u0016\u001c\u0015\r]1dSRLHC\u0001,]\u0011\u0015i\u0016\f1\u0001_\u0003\u0005I\u0007CA\n`\u0013\t\u0001GCA\u0002J]RDQAY\u0010\u0005\u0002\r\f!b\u001e:ji\u0016\u0014\u0015\u0010^3t)\t1F\rC\u0003fC\u0002\u0007a-A\u0003csR,7\u000fE\u0002\u0014O&L!\u0001\u001b\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005MQ\u0017BA6\u0015\u0005\u0011\u0011\u0015\u0010^3\t\u000b5|B\u0011\u00018\u0002\u0017]\u0014\u0018\u000e^3TiJLgn\u001a\u000b\u0003->DQ\u0001\u001d7A\u0002E\faa\u001d;sS:<\u0007C\u0001:z\u001d\t\u0019x\u000f\u0005\u0002u)5\tQO\u0003\u0002w\u0019\u00051AH]8pizJ!\u0001\u001f\u000b\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003qRAQ!`\u0010\u0005\u0002y\f\u0011c\u001e:ji\u0016\u0004vn]5uSZ,Gj\u001c8h)\t1v\u0010C\u0004\u0002\u0002q\u0004\r!a\u0001\u0002\u00031\u00042aEA\u0003\u0013\r\t9\u0001\u0006\u0002\u0005\u0019>tw\rC\u0004\u0002\f}!\t!!\u0004\u0002!]\u0014\u0018\u000e^3Q_NLG/\u001b<f\u0013:$Hc\u0001,\u0002\u0010!1Q,!\u0003A\u0002yCa!a\u0005 \t\u0003*\u0016!B2m_N,\u0007BBA\f7\u0001\u0007\u0011/A\u0003sk:LE\rC\u0004\u0002\u001cm\u0001\r!!\b\u0002\u001b\r|gNZ5hkJ\fG/[8o!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\r\u000511m\u001c8gS\u001eLA!a\n\u0002\"\t!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public final class BufferedFileChannelWriter
implements AutoCloseable,
StrictLogging {
    private final FileChannel channel;
    private final CharsetEncoder encoder;
    private final ByteBuffer bb;
    private final Logger logger;

    public static BufferedFileChannelWriter apply(String string, GatlingConfiguration gatlingConfiguration) {
        return BufferedFileChannelWriter$.MODULE$.apply(string, gatlingConfiguration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void flush() {
        this.bb.flip();
        while (this.bb.hasRemaining()) {
            this.channel.write(this.bb);
        }
        this.bb.clear();
    }

    private void ensureCapacity(int i) {
        block0: {
            if (this.bb.remaining() >= i) break block0;
            this.flush();
        }
    }

    public void writeBytes(byte[] bytes) {
        this.ensureCapacity(bytes.length);
        this.bb.put(bytes);
    }

    public void writeString(String string) {
        block2: {
            BoxedUnit boxedUnit;
            this.ensureCapacity(string.length() * 4);
            CoderResult coderResult = this.encoder.encode(CharBuffer.wrap(string), this.bb, false);
            if (!coderResult.isOverflow()) break block2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Buffer overflow, you shouldn't be logging that much data. Truncating.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void writePositiveLong(long l) {
        int stringSize = Longs.positiveLongStringSize(l);
        this.ensureCapacity(stringSize);
        Longs.writePositiveLongString(l, stringSize, this.bb);
    }

    public void writePositiveInt(int i) {
        int stringSize = Integers.positiveIntStringSize(i);
        this.ensureCapacity(stringSize);
        Integers.writePositiveIntString(i, stringSize, this.bb);
    }

    @Override
    public void close() {
        this.flush();
        this.channel.force(true);
    }

    public BufferedFileChannelWriter(FileChannel channel, CharsetEncoder encoder, ByteBuffer bb) {
        this.channel = channel;
        this.encoder = encoder;
        this.bb = bb;
        StrictLogging.$init$((StrictLogging)this);
    }
}

