/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.util.Longs;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005r!B\b\u0011\u0011\u0003Yb!B\u000f\u0011\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\"B\u0014\u0002\t\u0003Ac\u0001B\u000f\u0011\u0005)B\u0001\u0002\u0011\u0003\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0013\u0012\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0002B\u0001B\u0003%\u0011\u000bC\u0003&\t\u0011\u0005Q\u000bC\u0003Z\t\u0011\u0005!\fC\u0003_\t\u0011%q\fC\u0003f\t\u0011\u0005a\rC\u0003p\t\u0011\u0005\u0001\u000fC\u0003\u007f\t\u0011\u0005q\u0010\u0003\u0004\u0002\f\u0011!\tEW\u0001\u001a\u0005V4g-\u001a:fI\u001aKG.Z\"iC:tW\r\\,sSR,'O\u0003\u0002\u0012%\u00051qO]5uKJT!a\u0005\u000b\u0002\u000bM$\u0018\r^:\u000b\u0005U1\u0012\u0001B2pe\u0016T!a\u0006\r\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011$\u0001\u0002j_\u000e\u0001\u0001C\u0001\u000f\u0002\u001b\u0005\u0001\"!\u0007\"vM\u001a,'/\u001a3GS2,7\t[1o]\u0016dwK]5uKJ\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1$A\u0003baBd\u0017\u0010F\u0003*\u0003\u001b\t\t\u0002\u0005\u0002\u001d\tM!AaK\u001a7!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u00142kK\u000e$\bC\u0001\u00175\u0013\t)TFA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\t\u0003oyj\u0011\u0001\u000f\u0006\u0003si\nAb]2bY\u0006dwnZ4j]\u001eT!a\u000f\u001f\u0002\u0011QL\b/Z:bM\u0016T\u0011!P\u0001\u0004G>l\u0017BA 9\u00055\u0019FO]5di2{wmZ5oO\u000691\r[1o]\u0016d\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003!\u0019\u0007.\u00198oK2\u001c(B\u0001$0\u0003\rq\u0017n\\\u0005\u0003\u0011\u000e\u00131BR5mK\u000eC\u0017M\u001c8fY\u00069QM\\2pI\u0016\u0014\bCA&O\u001b\u0005a%BA'F\u0003\u001d\u0019\u0007.\u0019:tKRL!a\u0014'\u0003\u001d\rC\u0017M]:fi\u0016s7m\u001c3fe\u0006\u0011!M\u0019\t\u0003%Nk\u0011!R\u0005\u0003)\u0016\u0013!BQ=uK\n+hMZ3s)\u0011Ick\u0016-\t\u000b\u0001C\u0001\u0019A!\t\u000b%C\u0001\u0019\u0001&\t\u000bAC\u0001\u0019A)\u0002\u000b\u0019dWo\u001d5\u0015\u0003m\u0003\"\u0001\t/\n\u0005u\u000b#\u0001B+oSR\fa\"\u001a8tkJ,7)\u00199bG&$\u0018\u0010\u0006\u0002\\A\")\u0011M\u0003a\u0001E\u0006\t\u0011\u000e\u0005\u0002!G&\u0011A-\t\u0002\u0004\u0013:$\u0018AC<sSR,')\u001f;fgR\u00111l\u001a\u0005\u0006Q.\u0001\r![\u0001\u0006Ef$Xm\u001d\t\u0004A)d\u0017BA6\"\u0005\u0015\t%O]1z!\t\u0001S.\u0003\u0002oC\t!!)\u001f;f\u0003-9(/\u001b;f'R\u0014\u0018N\\4\u0015\u0005m\u000b\b\"\u0002:\r\u0001\u0004\u0019\u0018AB:ue&tw\r\u0005\u0002uw:\u0011Q/\u001f\t\u0003m\u0006j\u0011a\u001e\u0006\u0003qj\ta\u0001\u0010:p_Rt\u0014B\u0001>\"\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\f\u0013!E<sSR,\u0007k\\:ji&4X\rT8oOR\u00191,!\u0001\t\u000f\u0005\rQ\u00021\u0001\u0002\u0006\u0005\tA\u000eE\u0002!\u0003\u000fI1!!\u0003\"\u0005\u0011auN\\4\u0002\u000b\rdwn]3\t\r\u0005=1\u00011\u0001t\u0003\u0015\u0011XO\\%e\u0011\u001d\t\u0019b\u0001a\u0001\u0003+\tQbY8oM&<WO]1uS>t\u0007\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mA#\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003?\tIB\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c")
public final class BufferedFileChannelWriter
implements AutoCloseable,
StrictLogging {
    private final FileChannel channel;
    private final CharsetEncoder encoder;
    private final ByteBuffer bb;
    private Logger logger;

    public static BufferedFileChannelWriter apply(String runId, GatlingConfiguration configuration) {
        return BufferedFileChannelWriter$.MODULE$.apply(runId, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void flush() {
        this.bb.flip();
        while (this.bb.hasRemaining()) {
            this.channel.write(this.bb);
        }
        this.bb.clear();
    }

    private void ensureCapacity(int i) {
        if (this.bb.remaining() < i) {
            this.flush();
            return;
        }
    }

    public void writeBytes(byte[] bytes) {
        this.ensureCapacity(bytes.length);
        this.bb.put(bytes);
    }

    public void writeString(String string) {
        this.ensureCapacity(string.length() * 4);
        CoderResult coderResult = this.encoder.encode(CharBuffer.wrap(string), this.bb, false);
        if (coderResult.isOverflow()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Buffer overflow, you shouldn't be logging that much data. Truncating.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void writePositiveLong(long l) {
        int stringSize = Longs.positiveLongStringSize(l);
        this.ensureCapacity(stringSize);
        Longs.writePositiveLongString(l, stringSize, this.bb);
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.channel.force(true);
        }
        finally {
            this.channel.close();
        }
    }

    public BufferedFileChannelWriter(FileChannel channel, CharsetEncoder encoder, ByteBuffer bb) {
        this.channel = channel;
        this.encoder = encoder;
        this.bb = bb;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

