/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.AssertionSerializer;
import io.gatling.core.stats.writer.BufferedFileChannelWriter;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessageSerializer;
import io.gatling.core.stats.writer.FileData;
import io.gatling.core.stats.writer.GroupMessageSerializer;
import io.gatling.core.stats.writer.LogFileDataWriter$;
import io.gatling.core.stats.writer.ResponseMessageSerializer;
import io.gatling.core.stats.writer.RunMessageSerializer;
import io.gatling.core.stats.writer.UserEndMessageSerializer;
import io.gatling.core.stats.writer.UserStartMessageSerializer;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005e<Q!\u0004\b\t\u0002e1Qa\u0007\b\t\u0002qAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u00192Aa\u0007\b\u0003\u000b\"A!\u0007\u0002B\u0001B\u0003%q\u0005\u0003\u0005M\t\t\u0005\t\u0015!\u0003N\u0011\u0015\u0019C\u0001\"\u0001T\u0011\u00159F\u0001\"\u0011Y\u0011\u0015\u0011G\u0001\"\u0011d\u0011\u0015IG\u0001\"\u0011k\u0011\u0015\tH\u0001\"\u0011s\u0011\u00151H\u0001\"\u0011x\u0003Eaun\u001a$jY\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u001fA\taa\u001e:ji\u0016\u0014(BA\t\u0013\u0003\u0015\u0019H/\u0019;t\u0015\t\u0019B#\u0001\u0003d_J,'BA\u000b\u0017\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aF\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\u001b\u00035\taBA\tM_\u001e4\u0015\u000e\\3ECR\fwK]5uKJ\u001c\"!A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011$A\u0004m_\u001e4\u0015\u000e\\3\u0015\t\u001d\n4\u0007\u0011\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nAAZ5mK*\u0011A&L\u0001\u0004]&|'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a%\u0012A\u0001U1uQ\")!g\u0001a\u0001O\u0005\u0001\"/Z:vYR\u001cH)\u001b:fGR|'/\u001f\u0005\u0006i\r\u0001\r!N\u0001\u0006eVt\u0017\n\u001a\t\u0003mur!aN\u001e\u0011\u0005azR\"A\u001d\u000b\u0005iB\u0012A\u0002\u001fs_>$h(\u0003\u0002=?\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\tat\u0004C\u0003B\u0007\u0001\u0007!)\u0001\u0004de\u0016\fG/\u001a\t\u0003=\rK!\u0001R\u0010\u0003\u000f\t{w\u000e\\3b]N\u0011AA\u0012\t\u00045\u001dK\u0015B\u0001%\u000f\u0005)!\u0015\r^1Xe&$XM\u001d\t\u00035)K!a\u0013\b\u0003\u0011\u0019KG.\u001a#bi\u0006\fQbY8oM&<WO]1uS>t\u0007C\u0001(R\u001b\u0005y%B\u0001)\u0013\u0003\u0019\u0019wN\u001c4jO&\u0011!k\u0014\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0007Q+f\u000b\u0005\u0002\u001b\t!)!g\u0002a\u0001O!)Aj\u0002a\u0001\u001b\u00061qN\\%oSR$\"!S-\t\u000biC\u0001\u0019A.\u0002\t%t\u0017\u000e\u001e\t\u00039~s!AG/\n\u0005ys\u0011!\u0005#bi\u0006<&/\u001b;fe6+7o]1hK&\u0011\u0001-\u0019\u0002\u0005\u0013:LGO\u0003\u0002_\u001d\u00059qN\u001c$mkNDGC\u00013h!\tqR-\u0003\u0002g?\t!QK\\5u\u0011\u0015A\u0017\u00021\u0001J\u0003\u0011!\u0017\r^1\u0002\u0013=tW*Z:tC\u001e,Gc\u00013la\")AN\u0003a\u0001[\u00069Q.Z:tC\u001e,\u0007C\u0001/o\u0013\ty\u0017MA\u0005M_\u0006$WI^3oi\")\u0001N\u0003a\u0001\u0013\u00069qN\\\"sCNDGc\u00013tk\")Ao\u0003a\u0001k\u0005)1-Y;tK\")\u0001n\u0003a\u0001\u0013\u00061qN\\*u_B$\"\u0001\u001a=\t\u000b!d\u0001\u0019A%")
public final class LogFileDataWriter
extends DataWriter<FileData> {
    private final Path resultsDirectory;
    private final GatlingConfiguration configuration;

    public static Path logFile(Path resultsDirectory, String runId, boolean create) {
        return LogFileDataWriter$.MODULE$.logFile(resultsDirectory, runId, create);
    }

    @Override
    public FileData onInit(DataWriterMessage.Init init2) {
        Path simulationLog = LogFileDataWriter$.MODULE$.logFile(this.resultsDirectory, init2.runMessage().runId(), true);
        FileChannel channel = new RandomAccessFile(simulationLog.toFile(), "rw").getChannel();
        ByteBuffer bb = ByteBuffer.allocate(this.configuration.data().file().bufferSize());
        CharsetEncoder encoder = this.configuration.core().charset().newEncoder();
        BufferedFileChannelWriter writer = new BufferedFileChannelWriter(channel, encoder, bb);
        AssertionSerializer assertionSerializer = new AssertionSerializer(writer);
        init2.assertions().foreach((Function1 & Serializable)assertion -> {
            assertionSerializer.serialize(assertion);
            return BoxedUnit.UNIT;
        });
        new RunMessageSerializer(writer).serialize(init2.runMessage());
        return new FileData(new UserStartMessageSerializer(writer), new UserEndMessageSerializer(writer), new ResponseMessageSerializer(writer), new GroupMessageSerializer(writer), new ErrorMessageSerializer(writer), writer);
    }

    @Override
    public void onFlush(FileData data) {
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, FileData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserStart) {
            DataWriterMessage.LoadEvent.UserStart userStart = (DataWriterMessage.LoadEvent.UserStart)loadEvent;
            data.userStartMessageSerializer().serialize(userStart);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserEnd) {
            DataWriterMessage.LoadEvent.UserEnd userEnd = (DataWriterMessage.LoadEvent.UserEnd)loadEvent;
            data.userEndMessageSerializer().serialize(userEnd);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Group) {
            DataWriterMessage.LoadEvent.Group group = (DataWriterMessage.LoadEvent.Group)loadEvent;
            data.groupMessageSerializer().serialize(group);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            data.responseMessageSerializer().serialize(response);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            data.errorMessageSerializer().serialize(error);
            return;
        }
    }

    @Override
    public void onCrash(String cause, FileData data) {
    }

    @Override
    public void onStop(FileData data) {
        data.writer().close();
    }

    public LogFileDataWriter(Path resultsDirectory, GatlingConfiguration configuration) {
        this.resultsDirectory = resultsDirectory;
        this.configuration = configuration;
        super("file-data-writer");
    }
}

