/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.check.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.jsonpath.JsonFilter;
import io.gatling.core.check.jsonpath.JsonFilter$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.util.cache.Cache$;
import io.gatling.jsonpath.JPError;
import io.gatling.jsonpath.JsonPath;
import io.gatling.jsonpath.JsonPath$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001}4Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003-1\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\r=\u0003\u0001\u0015!\u0003*\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015a\b\u0001\"\u0001~\u0005%Q5o\u001c8QCRD7O\u0003\u0002\n\u0015\u0005A!n]8oa\u0006$\bN\u0003\u0002\f\u0019\u0005)1\r[3dW*\u0011QBD\u0001\u0005G>\u0014XM\u0003\u0002\u0010!\u00059q-\u0019;mS:<'\"A\t\u0002\u0005%|7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\u0019\u000511m\u001c8gS\u001eL!\u0001I\u000f\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0006\u0002%MA\u0011Q\u0005A\u0007\u0002\u0011!)!D\u0001a\u00027\u0005i!n]8o!\u0006$\bnQ1dQ\u0016,\u0012!\u000b\t\u0005UU:$)D\u0001,\u0015\taS&A\u0003dC\u000eDWM\u0003\u0002/_\u0005A1-\u00194gK&tWM\u0003\u00021c\u0005A!-\u001a8nC:,7O\u0003\u00023g\u00051q-\u001b;ik\nT\u0011\u0001N\u0001\u0004G>l\u0017B\u0001\u001c,\u00051au.\u00193j]\u001e\u001c\u0015m\u00195f!\tAtH\u0004\u0002:{A\u0011!HF\u0007\u0002w)\u0011AHE\u0001\u0007yI|w\u000e\u001e \n\u0005y2\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\f\u0011\u0007\rC%*D\u0001E\u0015\t)e)\u0001\u0006wC2LG-\u0019;j_:T!a\u0012\b\u0002\u000f\r|W.\\8og&\u0011\u0011\n\u0012\u0002\u000b-\u0006d\u0017\u000eZ1uS>t\u0007CA&N\u001b\u0005a%BA\u0005\u000f\u0013\tqEJ\u0001\u0005Kg>t\u0007+\u0019;i\u00039Q7o\u001c8QCRD7)Y2iK\u0002\n!\"\u001a=ue\u0006\u001cG/\u00117m+\t\u0011\u0006\rF\u0002T]j$\"\u0001V5\u0011\u0007\rCU\u000bE\u0002W7zs!aV-\u000f\u0005iB\u0016\"A\f\n\u0005i3\u0012a\u00029bG.\fw-Z\u0005\u00039v\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u00035Z\u0001\"a\u00181\r\u0001\u0011)\u0011-\u0002b\u0001E\n\t\u0001,\u0005\u0002dMB\u0011Q\u0003Z\u0005\u0003KZ\u0011qAT8uQ&tw\r\u0005\u0002\u0016O&\u0011\u0001N\u0006\u0002\u0004\u0003:L\bb\u00026\u0006\u0003\u0003\u0005\u001da[\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA\u0013m=&\u0011Q\u000e\u0003\u0002\u000b\u0015N|gNR5mi\u0016\u0014\b\"B8\u0006\u0001\u0004\u0001\u0018\u0001\u00026t_:\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0011\u0011\fG/\u00192j]\u0012T!!\u001e<\u0002\u000f)\f7m[:p]*\u0011qoM\u0001\nM\u0006\u001cH/\u001a:y[2L!!\u001f:\u0003\u0011)\u001bxN\u001c(pI\u0016DQa_\u0003A\u0002]\n!\"\u001a=qe\u0016\u001c8/[8o\u0003=\u0019w.\u001c9jY\u0016T5o\u001c8QCRDGC\u0001\"\u007f\u0011\u0015Yh\u00011\u00018\u0001")
public class JsonPaths {
    private final LoadingCache<String, Validation<JsonPath>> jsonPathCache;

    private LoadingCache<String, Validation<JsonPath>> jsonPathCache() {
        return this.jsonPathCache;
    }

    public <X> Validation<Iterator<X>> extractAll(JsonNode json, String expression, JsonFilter<X> evidence$1) {
        return this.compileJsonPath(expression).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.query(json).collect(JsonFilter$.MODULE$.apply(evidence$1).filter()));
    }

    public Validation<JsonPath> compileJsonPath(String expression) {
        return (Validation)this.jsonPathCache().get((Object)expression);
    }

    private static final Validation compile$1(String expression) {
        Failure failure;
        Either either = JsonPath$.MODULE$.compile(expression);
        if (either instanceof Left) {
            Left left = (Left)either;
            JPError error = (JPError)left.value();
            failure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(error.reason()));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            JsonPath path = (JsonPath)right.value();
            failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)path));
        } else {
            throw new MatchError((Object)either);
        }
        return failure;
    }

    public JsonPaths(GatlingConfiguration configuration) {
        this.jsonPathCache = Cache$.MODULE$.newConcurrentLoadingCache(configuration.core().extract().jsonPath().cacheMaxCapacity(), (Function1 & Serializable & scala.Serializable)expression -> JsonPaths.compile$1(expression));
    }
}

