/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.pkg;

import io.gatling.internal.asm.ClassReader;
import io.gatling.internal.asm.ClassVisitor;
import io.gatling.internal.asm.ClassWriter;
import io.gatling.internal.asm.tree.AbstractInsnNode;
import io.gatling.internal.asm.tree.ClassNode;
import io.gatling.internal.asm.tree.InsnNode;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.pkg.Dependency;
import io.gatling.plugin.pkg.ExtraManifestEntries;
import io.gatling.plugin.pkg.Git;
import io.gatling.plugin.util.IOUtil;
import io.gatling.plugin.util.ZipUtil;
import io.gatling.scanner.SimulationScanResult;
import io.gatling.scanner.SimulationScanner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public final class EnterprisePackager {
    private static final String GATLING_ENTERPRISE_BUILDER_PACKAGE_PATH_ENV_KEY = "GATLING_ENTERPRISE_BUILDER_PACKAGE_PATH";
    private final PluginLogger logger;
    private static final Set<String> POPULAR_FRAMEWORK_GROUPID_PREFIXES = Set.of("ch.qos.logback", "com.amazonaws", "com.azure", "com.github.javafaker", "com.google", "com.opencsv", "com.vladmihalcea", "groovy", "io.micrometer", "io.vavr", "joda-time", "junit", "kotlin", "lombok", "mysql", "net.datafaker", "org.apache", "org.assertj", "org.aspectj", "com.fasterxml", "org.flywaydb", "org.hibernate", "org.jsoup", "org.mockito", "org.postgresql", "org.scala-lang", "org.seleniumhq", "org.slf4j", "org.springframework", "org.reflections", "org.testcontainers", "software.amazon");
    private static final Set<String> gatlingExtraProtocolsArtifactIds = Set.of("gatling-grpc", "gatling-mqtt");

    public EnterprisePackager(PluginLogger pluginLogger) {
        this.logger = pluginLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEnterprisePackage(List<File> list, Set<Dependency> set, Set<Dependency> set2, String string2, String string3, String string4, String string5, String string6, File file, File file2) throws IOException {
        Git.Metadata metadata;
        String string7 = EnterprisePackager.gatlingVersion(set);
        List<String> list2 = EnterprisePackager.gatlingExtraProtocols(set);
        File file3 = Files.createTempDirectory("gatling-" + string5, new FileAttribute[0]).toFile();
        Set<Dependency> set3 = EnterprisePackager.shippedDependencies(set2);
        SimulationScanResult simulationScanResult = SimulationScanner.scan(EnterprisePackager.scannedDependencies(set3), list);
        if (simulationScanResult.getSimulationClasses().isEmpty()) {
            throw EnterprisePackager.newStacklessIllegalArgumentException("Your project doesn't contain any Simulation");
        }
        try {
            metadata = Git.getMetadata(file2.toPath());
        }
        catch (IOException iOException) {
            this.logger.info("Failed to compute git metadata: " + iOException.getMessage());
            metadata = null;
        }
        try {
            for (Dependency object2 : set3) {
                ZipUtil.unpack(object2.file, file3, EnterprisePackager::excludeJarEntry, EnterprisePackager::mergeConflictingTextFiles);
            }
            EnterprisePackager.disableBcFipsCheck(file3);
            for (File file4 : list) {
                if (!file4.exists() || !file4.isDirectory()) continue;
                IOUtil.copyDirectory(file4, file3);
            }
            File file4 = new File(file3, "META-INF");
            EnterprisePackager.mkdirs(file4);
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, string3);
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, string4);
            attributes.put(Attributes.Name.IMPLEMENTATION_VENDOR, "GatlingCorp");
            attributes.put(Attributes.Name.SPECIFICATION_VENDOR, "GatlingCorp");
            attributes.put(ExtraManifestEntries.GatlingVersion, string7);
            attributes.put(ExtraManifestEntries.GatlingPackager, string5);
            attributes.put(ExtraManifestEntries.GatlingPackagerVersion, string6);
            attributes.put(ExtraManifestEntries.GatlingSimulations, ExtraManifestEntries.serializeMultiValued(simulationScanResult.getSimulationClasses()));
            attributes.put(ExtraManifestEntries.GatlingExtraProtocols, ExtraManifestEntries.serializeMultiValued(list2));
            attributes.put(ExtraManifestEntries.JavaVersion, String.valueOf(simulationScanResult.getHighestJavaVersionClass().javaVersion));
            if (metadata != null) {
                attributes.put(ExtraManifestEntries.GitBranch, metadata.branch);
                attributes.put(ExtraManifestEntries.GitHeadCommit, metadata.headCommit);
            }
            try (Object object = new FileOutputStream(new File(file4, "MANIFEST.MF"));){
                manifest.write((OutputStream)object);
            }
            object = new File(new File(new File(file4, "maven"), string2), string3);
            EnterprisePackager.mkdirs((File)object);
            try (Object object = new FileWriter(new File((File)object, "pom.properties"));){
                ((Writer)object).write("groupId=" + string2 + "\n");
                ((Writer)object).write("artifactId=" + string3 + "\n");
                ((Writer)object).write("version=" + string4 + "\n");
            }
            object = new FileWriter(new File((File)object, "pom.xml"));
            try {
                ((Writer)object).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                ((Writer)object).write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                ((Writer)object).write("    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n");
                ((Writer)object).write("    <modelVersion>4.0.0</modelVersion>\n");
                ((Writer)object).write("    <groupId>" + string2 + "</groupId>\n");
                ((Writer)object).write("    <artifactId>" + string3 + "</artifactId>\n");
                ((Writer)object).write("    <version>" + string4 + "</version>\n");
                ((Writer)object).write("</project>");
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
            object = Optional.ofNullable(System.getenv(GATLING_ENTERPRISE_BUILDER_PACKAGE_PATH_ENV_KEY)).map(string -> Paths.get(string, new String[0])).map(Path::toFile).orElse(file);
            this.logger.info("Generating Gatling Enterprise package " + String.valueOf(object));
            Counter counter = new Counter();
            ZipUtil.pack(file3, (File)object, () -> {
                int n = counter.incrementAndGet();
                if (n % 1000 == 0) {
                    this.logger.debug("Package generation in progress: " + n + " entries added.");
                }
            });
            this.logger.info("Successfully generated Enterprise package " + String.valueOf(object) + " (" + ((File)object).length() + " bytes, " + ZipUtil.zipEntriesCount((File)object) + " entries)");
        }
        finally {
            IOUtil.deleteDirectory(file3);
        }
    }

    private static Set<Dependency> shippedDependencies(Set<Dependency> set) {
        return set.stream().filter(dependency -> !dependency.artifactId.equals("netty-all") && !dependency.groupId.equals("ch.qos.logback") && !dependency.artifactId.equals("slf4j-simple") && !dependency.artifactId.equals("log4j-slf4j-impl") && !dependency.artifactId.equals("log4j-slf4j2-impl")).collect(Collectors.toSet());
    }

    private static boolean excludeJarEntry(String string) {
        String string2 = string.toUpperCase(Locale.ROOT);
        return string2.endsWith("MODULE-INFO.CLASS") || string2.startsWith("LICENSE") || string2.startsWith("META-INF/LICENSE") || string2.startsWith("META-INF/NOTICE") || string2.startsWith("META-INF/DEPENDENCIES") || string2.equals("META-INF/MANIFEST.MF") || string2.equals("META-INF/INDEX.LIST") || string2.startsWith("META-INF/MAVEN/") || string2.endsWith(".SF") || string2.endsWith(".DSA") || string2.endsWith(".RSA") || string2.endsWith(".EXE") || string2.endsWith(".DLL") || string2.endsWith(".DYLIB") || string2.startsWith("IO/GATLING/") || string2.startsWith("IO/NETTY/");
    }

    private static boolean mergeConflictingTextFiles(String string2, File file, InputStream inputStream) {
        if (file.length() > 0L && (string2.startsWith("META-INF/services/") || string2.equals("META-INF/cxf/bus-extensions.txt"))) {
            try {
                List<String> list = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
                List list2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().filter(string -> !string.isEmpty()).collect(Collectors.toList());
                HashSet<String> hashSet = new HashSet<String>(list);
                hashSet.addAll(list2);
                ArrayList<String> arrayList = new ArrayList<String>(hashSet);
                Collections.sort(arrayList);
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, false));){
                    for (String string3 : arrayList) {
                        bufferedWriter.write(string3);
                        bufferedWriter.newLine();
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return false;
    }

    private static void disableBcFipsCheck(File file) throws IOException {
        File file2 = new File(file, "org/bouncycastle/crypto/fips/FipsStatus.class".replace('/', File.separatorChar));
        if (file2.exists()) {
            Object object2;
            Path path = file2.toPath();
            byte[] byArray = Files.readAllBytes(path);
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 589824);
            for (Object object2 : classNode.methods) {
                if (!object2.name.equals("checksumValidate")) continue;
                object2.instructions.clear();
                object2.instructions.add((AbstractInsnNode)new InsnNode(177));
                object2.tryCatchBlocks.clear();
            }
            ClassWriter classWriter = new ClassWriter(589824);
            classNode.accept((ClassVisitor)classWriter);
            object2 = classWriter.toByteArray();
            Files.write(path, (byte[])object2, new OpenOption[0]);
        }
    }

    private static List<File> scannedDependencies(Set<Dependency> set) {
        return set.stream().filter(dependency -> POPULAR_FRAMEWORK_GROUPID_PREFIXES.stream().filter(dependency.groupId::startsWith).findFirst().isEmpty()).map(dependency -> dependency.file).collect(Collectors.toList());
    }

    private static Manifest readManifest(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest;
            block11: {
                InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF"));
                try {
                    manifest = new Manifest(inputStream);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return manifest;
        }
    }

    public static int getJavaVersion(File file) throws IOException {
        Manifest manifest = EnterprisePackager.readManifest(file);
        return Integer.parseInt(manifest.getMainAttributes().getValue(ExtraManifestEntries.JavaVersion));
    }

    private static String gatlingVersion(Set<Dependency> set) {
        return set.stream().filter((Predicate<Dependency>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$gatlingVersion$0(io.gatling.plugin.pkg.Dependency ), (Lio/gatling/plugin/pkg/Dependency;)Z)()).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$gatlingVersion$1(), ()Ljava/lang/IllegalArgumentException;)()).version;
    }

    private static List<String> gatlingExtraProtocols(Set<Dependency> set) {
        return set.stream().filter(dependency -> dependency.groupId.equals("io.gatling") && gatlingExtraProtocolsArtifactIds.contains(dependency.artifactId)).map(dependency -> dependency.artifactId.substring("gatling-".length())).distinct().sorted().collect(Collectors.toList());
    }

    private static IllegalArgumentException newStacklessIllegalArgumentException(String string) {
        return new IllegalArgumentException(string){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    private static void mkdirs(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Failed to create dir " + String.valueOf(file));
        }
    }

    private static /* synthetic */ IllegalArgumentException lambda$gatlingVersion$1() {
        return EnterprisePackager.newStacklessIllegalArgumentException("Can't find Gatling libraries in dependencies");
    }

    private static /* synthetic */ boolean lambda$gatlingVersion$0(Dependency dependency) {
        return dependency.groupId.equals("io.gatling") && dependency.artifactId.equals("gatling-app");
    }

    private static final class Counter {
        private int count;

        private Counter() {
        }

        public int incrementAndGet() {
            return this.count++;
        }
    }
}

