/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;

public final class IOUtil {
    public static void mkdirs(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Unable to create directory: file " + String.valueOf(file) + " exists and is not a directory.");
            }
        } else if (!file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Unable to create directory " + String.valueOf(file));
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        try (Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);){
            stream.forEach(path -> {
                Path path2 = Paths.get(file2.getAbsolutePath(), path.toString().substring(file.getAbsolutePath().length()));
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    return;
                }
                try {
                    Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            });
        }
    }

    public static void deleteDirectory(File file, final Runnable runnable) throws IOException {
        if (!file.exists()) {
            return;
        }
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                if (runnable != null) {
                    runnable.run();
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

