/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.SslContextsHolder;
import io.gatling.http.client.impl.RequestTimeout;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.pool.ChannelPoolKey;
import io.gatling.http.client.util.HttpUtils;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCounted;

public class HttpTx {
    final Request request;
    final HttpListener listener;
    final RequestTimeout requestTimeout;
    final ChannelPoolKey key;
    private final SslContextsHolder sslContextsHolder;
    ChannelState channelState;
    boolean closeConnection;
    WritableRequest pendingRequestExpectingContinue;

    HttpTx(Request request, HttpListener httpListener, RequestTimeout requestTimeout, ChannelPoolKey channelPoolKey, SslContextsHolder sslContextsHolder) {
        this.request = request;
        this.listener = httpListener;
        this.requestTimeout = requestTimeout;
        this.key = channelPoolKey;
        this.channelState = ChannelState.POOLED;
        this.sslContextsHolder = sslContextsHolder;
        this.closeConnection = HttpUtils.isConnectionClose(request.getHeaders());
    }

    SslContext sslContext() {
        if (this.request.getHttp2PriorKnowledge() == Http2PriorKnowledge.HTTP1_ONLY) {
            return this.sslContextsHolder.getSslContext();
        }
        if (this.sslContextsHolder.getAlpnSslContext() == null) {
            throw new UnsupportedOperationException("ALPN is not available (this path shouldn't be possible, please report).");
        }
        return this.sslContextsHolder.getAlpnSslContext();
    }

    void releasePendingRequestExpectingContinue() {
        if (this.pendingRequestExpectingContinue != null) {
            Object object = this.pendingRequestExpectingContinue.getContent();
            if (object instanceof ReferenceCounted) {
                ((ReferenceCounted)object).release();
            }
            this.pendingRequestExpectingContinue = null;
        }
    }

    public static enum ChannelState {
        NEW,
        POOLED,
        RETRY;

    }
}

