/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.form;

import io.gatling.http.client.Param;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.util.Utf8UrlEncoder;
import io.gatling.shared.util.StringBuilderPool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class FormUrlEncodedRequestBody
extends RequestBody.Base<List<Param>> {
    private final Charset charset;
    private final CharSequence patchedContentType;
    private static final StringBuilderPool SB_POOL = new StringBuilderPool();

    public FormUrlEncodedRequestBody(List<Param> list, CharSequence charSequence, Charset charset) {
        super(list);
        this.charset = charset;
        this.patchedContentType = charSequence;
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        StringBuilder stringBuilder = this.encode();
        ByteBuf byteBuf = ByteBufUtil.writeAscii((ByteBufAllocator)byteBufAllocator, (CharSequence)stringBuilder);
        return new WritableContent(byteBuf, byteBuf.readableBytes());
    }

    private StringBuilder encode() {
        StringBuilder stringBuilder = SB_POOL.get();
        for (Param param : (List)this.content) {
            FormUrlEncodedRequestBody.encodeAndAppendFormParam(stringBuilder, param.getName(), param.getValue(), this.charset);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder;
    }

    private static void encodeAndAppendFormParam(StringBuilder stringBuilder, String string, String string2, Charset charset) {
        FormUrlEncodedRequestBody.encodeAndAppendFormField(stringBuilder, string, charset);
        if (string2 != null) {
            stringBuilder.append('=');
            FormUrlEncodedRequestBody.encodeAndAppendFormField(stringBuilder, string2, charset);
        }
        stringBuilder.append('&');
    }

    private static void encodeAndAppendFormField(StringBuilder stringBuilder, String string, Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            Utf8UrlEncoder.encodeAndAppendFormElement(stringBuilder, string);
        } else {
            stringBuilder.append(URLEncoder.encode(string, charset));
        }
    }

    @Override
    public RequestBodyBuilder newBuilder() {
        return new FormUrlEncodedRequestBodyBuilder((List)this.content);
    }

    @Override
    public byte[] getBytes() {
        return this.encode().toString().getBytes(this.charset);
    }

    @Override
    public CharSequence getPatchedContentType() {
        return this.patchedContentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String print(int n) {
        return "FormUrlEncodedRequestBody{patchedContentType='" + String.valueOf(this.patchedContentType) + "', charset=" + String.valueOf(this.charset) + ", content=" + this.truncate(this.encode().toString(), n) + "}";
    }
}

