/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class LocalAddresses {
    private final InetSocketAddress linkLocalIpV4;
    private final InetSocketAddress siteLocalIpV4;
    private final InetSocketAddress publicIpV4;
    private final InetSocketAddress linkLocalIpV6;
    private final InetSocketAddress siteLocalIpV6;
    private final InetSocketAddress publicIpV6;

    public LocalAddresses(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3, InetSocketAddress inetSocketAddress4, InetSocketAddress inetSocketAddress5, InetSocketAddress inetSocketAddress6) {
        this.linkLocalIpV4 = inetSocketAddress;
        this.siteLocalIpV4 = inetSocketAddress2;
        this.publicIpV4 = inetSocketAddress3;
        this.linkLocalIpV6 = inetSocketAddress4;
        this.siteLocalIpV6 = inetSocketAddress5;
        this.publicIpV6 = inetSocketAddress6;
    }

    public InetSocketAddress getLocalAddressForRemote(InetAddress inetAddress) {
        if (inetAddress.isLinkLocalAddress()) {
            return inetAddress instanceof Inet4Address ? this.linkLocalIpV4 : this.linkLocalIpV6;
        }
        if (inetAddress.isSiteLocalAddress()) {
            return inetAddress instanceof Inet4Address ? this.siteLocalIpV4 : this.siteLocalIpV6;
        }
        return inetAddress instanceof Inet4Address ? this.publicIpV4 : this.publicIpV6;
    }

    public String toString() {
        return "LocalAddresses{linkLocalIpV4=" + String.valueOf(this.linkLocalIpV4) + ", siteLocalIpV4=" + String.valueOf(this.siteLocalIpV4) + ", publicIpV4=" + String.valueOf(this.publicIpV4) + ", linkLocalIpV6=" + String.valueOf(this.linkLocalIpV6) + ", siteLocalIpV6=" + String.valueOf(this.siteLocalIpV6) + ", publicIpV6=" + String.valueOf(this.publicIpV6) + "}";
    }
}

