/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.ning.http.client.Request;
import com.ning.http.client.date.RFC2616Date;
import com.ning.http.client.date.RFC2616DateParser;
import com.ning.http.client.uri.Uri;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.NotNothing$;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.core.util.CacheHelper$;
import io.gatling.core.util.NumberHelper$;
import io.gatling.core.util.TimeHelper$;
import io.gatling.core.validation.Validation;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.ahc.ThreeTenBPConverter$;
import io.gatling.http.cache.CacheHandling$;
import io.gatling.http.config.HttpProtocol;
import io.gatling.http.response.Response;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.concurrent.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class CacheHandling$
implements StrictLogging {
    public static final CacheHandling$ MODULE$;
    private final String HttpRedirectMemoizationStoreAttributeName;
    private final String HttpExpireStoreAttributeName;
    private final String HttpLastModifiedStoreAttributeName;
    private final String HttpEtagStoreAttributeName;
    private final String MaxAgePrefix;
    private final String MaxAgeZero;
    private final Function1<Session, Validation<Session>> FlushCache;
    private final Logger logger;

    static {
        new CacheHandling$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String HttpRedirectMemoizationStoreAttributeName() {
        return this.HttpRedirectMemoizationStoreAttributeName;
    }

    public Option<Map<Uri, Uri>> getRedirectMemoizationStore(Session session) {
        return session.apply(this.HttpRedirectMemoizationStoreAttributeName()).asOption(NotNothing$.MODULE$.notNothingEv(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public Map<Uri, Uri> getOrCreateRedirectMemoizationStore(Session session) {
        Map map;
        Option<Map<Uri, Uri>> option = this.getRedirectMemoizationStore(session);
        if (option instanceof Some) {
            Map store;
            Some some = (Some)option;
            map = store = (Map)some.x();
        } else {
            map = CacheHelper$.MODULE$.newCache(GatlingConfiguration$.MODULE$.configuration().http().redirectPerUserCacheMaxCapacity());
        }
        return map;
    }

    public String HttpExpireStoreAttributeName() {
        return this.HttpExpireStoreAttributeName;
    }

    private Option<Map<Uri, Object>> getExpireStore(Session session) {
        return session.apply(this.HttpExpireStoreAttributeName()).asOption(NotNothing$.MODULE$.notNothingEv(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public Map<Uri, Object> getOrCreateExpireStore(Session session) {
        Map map;
        Option<Map<Uri, Object>> option = this.getExpireStore(session);
        if (option instanceof Some) {
            Map store;
            Some some = (Some)option;
            map = store = (Map)some.x();
        } else {
            map = CacheHelper$.MODULE$.newCache(GatlingConfiguration$.MODULE$.configuration().http().expirePerUserCacheMaxCapacity());
        }
        return map;
    }

    public Option<Object> getExpire(HttpProtocol httpProtocol2, Session session, Uri uri2) {
        return httpProtocol2.requestPart().cache() ? this.getExpireStore(session).flatMap((Function1)new Serializable(uri2){
            public static final long serialVersionUID = 0L;
            private final Uri uri$1;

            public final Option<Object> apply(Map<Uri, Object> x$1) {
                return x$1.get((Object)this.uri$1);
            }
            {
                this.uri$1 = uri$1;
            }
        }) : None$.MODULE$;
    }

    public Session clearExpire(Session session, Uri uri2) {
        Session session2;
        Option<Map<Uri, Object>> option;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource ", " caching expired"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri2})));
        }
        if ((option = this.getExpireStore(session)) instanceof Some) {
            Some some = (Some)option;
            Map expireStore = (Map)some.x();
            session2 = session.set(this.HttpExpireStoreAttributeName(), (Object)expireStore.$minus((Object)uri2));
        } else {
            session2 = session;
        }
        return session2;
    }

    public String HttpLastModifiedStoreAttributeName() {
        return this.HttpLastModifiedStoreAttributeName;
    }

    public Option<Map<Uri, String>> getLastModifiedStore(Session session) {
        return session.apply(this.HttpLastModifiedStoreAttributeName()).asOption(NotNothing$.MODULE$.notNothingEv(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public Map<Uri, String> getOrCreateLastModifiedStore(Session session) {
        Map map;
        Option<Map<Uri, String>> option = this.getLastModifiedStore(session);
        if (option instanceof Some) {
            Map store;
            Some some = (Some)option;
            map = store = (Map)some.x();
        } else {
            map = CacheHelper$.MODULE$.newCache(GatlingConfiguration$.MODULE$.configuration().http().lastModifiedPerUserCacheMaxCapacity());
        }
        return map;
    }

    public Option<String> getLastModified(HttpProtocol httpProtocol2, Session session, Uri uri2) {
        return httpProtocol2.requestPart().cache() ? this.getLastModifiedStore(session).flatMap((Function1)new Serializable(uri2){
            public static final long serialVersionUID = 0L;
            private final Uri uri$2;

            public final Option<String> apply(Map<Uri, String> x$2) {
                return x$2.get((Object)this.uri$2);
            }
            {
                this.uri$2 = uri$2;
            }
        }) : None$.MODULE$;
    }

    public String HttpEtagStoreAttributeName() {
        return this.HttpEtagStoreAttributeName;
    }

    public Option<Map<Uri, String>> getEtagStore(Session session) {
        return session.apply(this.HttpEtagStoreAttributeName()).asOption(NotNothing$.MODULE$.notNothingEv(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public Map<Uri, String> getOrCreateEtagStore(Session session) {
        Map map;
        Option<Map<Uri, String>> option = this.getEtagStore(session);
        if (option instanceof Some) {
            Map store;
            Some some = (Some)option;
            map = store = (Map)some.x();
        } else {
            map = CacheHelper$.MODULE$.newCache(GatlingConfiguration$.MODULE$.configuration().http().etagPerUserCacheMaxCapacity());
        }
        return map;
    }

    public Option<String> getEtag(HttpProtocol httpProtocol2, Session session, Uri uri2) {
        return httpProtocol2.requestPart().cache() ? this.getEtagStore(session).flatMap((Function1)new Serializable(uri2){
            public static final long serialVersionUID = 0L;
            private final Uri uri$3;

            public final Option<String> apply(Map<Uri, String> x$3) {
                return x$3.get((Object)this.uri$3);
            }
            {
                this.uri$3 = uri$3;
            }
        }) : None$.MODULE$;
    }

    public String MaxAgePrefix() {
        return this.MaxAgePrefix;
    }

    public String MaxAgeZero() {
        return this.MaxAgeZero;
    }

    public Option<Object> extractExpiresValue(String timestring) {
        String trimmedTimeString = this.removeQuote$1(timestring.trim());
        return Option$.MODULE$.apply((Object)new RFC2616DateParser(trimmedTimeString).parse()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(RFC2616Date date) {
                return ThreeTenBPConverter$.MODULE$.toTime(date);
            }
        });
    }

    public Option<Object> extractMaxAgeValue(String s) {
        None$ none$;
        int index = s.indexOf(this.MaxAgePrefix());
        int start2 = this.MaxAgePrefix().length() + index;
        if (index >= 0 && start2 <= s.length()) {
            char c = s.charAt(start2);
            switch (c) {
                default: {
                    if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)NumberHelper$.MODULE$.extractLongValue(s, start2)));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                case '-': {
                    none$ = new Some((Object)BoxesRunTime.boxToLong((long)-1L));
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> getResponseExpires(HttpProtocol httpProtocol2, Response response) {
        return this.pragmaNoCache$1(response) || this.cacheControlNoCache$1(response) ? None$.MODULE$ : this.maxAgeAsExpiresValue$1(response).orElse((Function0)new Serializable(response){
            public static final long serialVersionUID = 0L;
            private final Response response$1;

            public final Option<Object> apply() {
                return CacheHandling$.MODULE$.io$gatling$http$cache$CacheHandling$$expiresValue$1(this.response$1);
            }
            {
                this.response$1 = response$1;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$6) {
                return this.apply$mcZJ$sp(x$6);
            }

            public boolean apply$mcZJ$sp(long x$6) {
                return x$6 > 0L;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Session, Session> cache(HttpProtocol httpProtocol2, Request request, Response response) {
        Function1 function1;
        if (httpProtocol2.requestPart().cache()) {
            void var22_26;
            void var16_18;
            void var10_10;
            Uri uri2 = request.getUri();
            Option<Object> option = this.getResponseExpires(httpProtocol2, response);
            if (option instanceof Some) {
                Some some = (Some)option;
                long expires = BoxesRunTime.unboxToLong((Object)some.x());
                Serializable serializable = new Serializable(uri2, expires){
                    public static final long serialVersionUID = 0L;
                    private final Uri uri$4;
                    private final long expires$1;

                    public final Session apply(Session session) {
                        if (CacheHandling$.MODULE$.logger().underlying().isDebugEnabled()) {
                            CacheHandling$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting Expires ", " for uri ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expires$1), this.uri$4})));
                        }
                        Map<Uri, Object> expireStore = CacheHandling$.MODULE$.getOrCreateExpireStore(session);
                        return session.set(CacheHandling$.MODULE$.HttpExpireStoreAttributeName(), (Object)expireStore.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.uri$4), (Object)BoxesRunTime.boxToLong((long)this.expires$1))));
                    }
                    {
                        this.uri$4 = uri$4;
                        this.expires$1 = expires$1;
                    }
                };
            } else {
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                Function1 function12 = Session$.MODULE$.Identity();
            }
            void updateExpire = var10_10;
            Option<String> option3 = response.header(HeaderNames$.MODULE$.LastModified());
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                String lastModified = (String)some.x();
                Serializable serializable = new Serializable(uri2, lastModified){
                    public static final long serialVersionUID = 0L;
                    private final Uri uri$4;
                    private final String lastModified$1;

                    public final Session apply(Session session) {
                        if (CacheHandling$.MODULE$.logger().underlying().isDebugEnabled()) {
                            CacheHandling$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting LastModified ", " for uri ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lastModified$1, this.uri$4})));
                        }
                        Map<Uri, String> lastModifiedStore = CacheHandling$.MODULE$.getOrCreateLastModifiedStore(session);
                        return session.set(CacheHandling$.MODULE$.HttpLastModifiedStoreAttributeName(), (Object)lastModifiedStore.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.uri$4), (Object)this.lastModified$1)));
                    }
                    {
                        this.uri$4 = uri$4;
                        this.lastModified$1 = lastModified$1;
                    }
                };
            } else {
                None$ none$ = None$.MODULE$;
                Option<String> option4 = option3;
                if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError(option3);
                Function1 function13 = Session$.MODULE$.Identity();
            }
            void updateLastModified = var16_18;
            Option<String> option5 = response.header(HeaderNames$.MODULE$.ETag());
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                String etag = (String)some.x();
                Serializable serializable = new Serializable(uri2, etag){
                    public static final long serialVersionUID = 0L;
                    private final Uri uri$4;
                    private final String etag$1;

                    public final Session apply(Session session) {
                        if (CacheHandling$.MODULE$.logger().underlying().isDebugEnabled()) {
                            CacheHandling$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting Etag ", " for uri ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.etag$1, this.uri$4})));
                        }
                        Map<Uri, String> etagStore = CacheHandling$.MODULE$.getOrCreateEtagStore(session);
                        return session.set(CacheHandling$.MODULE$.HttpEtagStoreAttributeName(), (Object)etagStore.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.uri$4), (Object)this.etag$1)));
                    }
                    {
                        this.uri$4 = uri$4;
                        this.etag$1 = etag$1;
                    }
                };
            } else {
                None$ none$ = None$.MODULE$;
                Option<String> option6 = option5;
                if (none$ != null ? !none$.equals(option6) : option6 != null) throw new MatchError(option5);
                Function1 function14 = Session$.MODULE$.Identity();
            }
            void updateEtag = var22_26;
            function1 = updateExpire.andThen((Function1)updateEtag).andThen((Function1)updateLastModified);
            return function1;
        } else {
            function1 = Session$.MODULE$.Identity();
        }
        return function1;
    }

    public Function1<Session, Validation<Session>> FlushCache() {
        return this.FlushCache;
    }

    private final String removeQuote$1(String s) {
        String string;
        if (s.isEmpty()) {
            string = s;
        } else {
            int start2 = 0;
            int end = s.length();
            if (s.charAt(0) == '\"') {
                ++start2;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                --end;
            }
            string = s.substring(start2, end);
        }
        return string;
    }

    private final boolean pragmaNoCache$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Pragma()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return x$4.contains(HeaderValues$.MODULE$.NoCache());
            }
        });
    }

    private final boolean cacheControlNoCache$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String h) {
                return h.contains(HeaderValues$.MODULE$.NoCache()) || h.contains(HeaderValues$.MODULE$.NoStore()) || h.contains(CacheHandling$.MODULE$.MaxAgeZero());
            }
        });
    }

    private final Option maxAgeAsExpiresValue$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(String s) {
                return CacheHandling$.MODULE$.extractMaxAgeValue(s);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long maxAge) {
                return this.apply$mcJJ$sp(maxAge);
            }

            public long apply$mcJJ$sp(long maxAge) {
                return maxAge < 0L ? maxAge : maxAge * 1000L + TimeHelper$.MODULE$.nowMillis();
            }
        });
    }

    public final Option io$gatling$http$cache$CacheHandling$$expiresValue$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Expires()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(String timestring) {
                return CacheHandling$.MODULE$.extractExpiresValue(timestring);
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$5) {
                return this.apply$mcZJ$sp(x$5);
            }

            public boolean apply$mcZJ$sp(long x$5) {
                return x$5 > TimeHelper$.MODULE$.nowMillis();
            }
        });
    }

    private CacheHandling$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.HttpRedirectMemoizationStoreAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.redirects").toString();
        this.HttpExpireStoreAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.expireStore").toString();
        this.HttpLastModifiedStoreAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.lastModifiedStore").toString();
        this.HttpEtagStoreAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.etagStore").toString();
        this.MaxAgePrefix = "max-age=";
        this.MaxAgeZero = new StringBuilder().append((Object)this.MaxAgePrefix()).append((Object)"0").toString();
        this.FlushCache = new anonfun.4();
    }
}

