/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import com.ning.http.client.RequestBuilder;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.uri.Uri;
import io.gatling.core.session.Session;
import io.gatling.core.validation.Validation;
import io.gatling.core.validation.package;
import io.gatling.core.validation.package$;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.cache.CacheHandling$;
import io.gatling.http.config.HttpProtocol;
import io.gatling.http.request.Body;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.util.HttpHelper$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u001b\ta\u0002\n\u001e;q%\u0016\fX/Z:u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0011W/\u001b7eKJT!!\u0002\u0004\u0002\u000fI,\u0017/^3ti*\u0011q\u0001C\u0001\u0005QR$\bO\u0003\u0002\n\u0015\u00059q-\u0019;mS:<'\"A\u0006\u0002\u0005%|7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u00031I+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'\u000f\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003A\u0019w.\\7p]\u0006#HO]5ckR,7\u000f\u0005\u0002\u0010+%\u0011aC\u0001\u0002\u0011\u0007>lWn\u001c8BiR\u0014\u0018NY;uKND\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!G\u0001\u000fQR$\b/\u0011;ue&\u0014W\u000f^3t!\ty!$\u0003\u0002\u001c\u0005\tq\u0001\n\u001e;q\u0003R$(/\u001b2vi\u0016\u001c\b\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0011A\u0014x\u000e^8d_2\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0004\u0002\r\r|gNZ5h\u0013\t\u0019\u0003E\u0001\u0007IiR\u0004\bK]8u_\u000e|G\u000eC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0005O!J#\u0006\u0005\u0002\u0010\u0001!)1\u0003\na\u0001)!)\u0001\u0004\na\u00013!)Q\u0004\na\u0001=!)A\u0006\u0001C\u0001[\u0005aQ.Y6f\u0003\n\u001cx\u000e\\;uKR\u0011a\u0006\u0011\t\u0004_Q2T\"\u0001\u0019\u000b\u0005E\u0012\u0014A\u0003<bY&$\u0017\r^5p]*\u00111\u0007C\u0001\u0005G>\u0014X-\u0003\u00026a\tQa+\u00197jI\u0006$\u0018n\u001c8\u0011\u0005]jdB\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ\u0014A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u001d\t\u000b\u0005[\u0003\u0019\u0001\u001c\u0002\u0007U\u0014H\u000eC\u0003D\u0001\u0011\u0005A)A\bd_:4\u0017nZ;sK\u000e\u000b7\r[3t)\r)Ek\u0017\u000b\u0003\rJ\u00032a\f\u001bH!\tA\u0005+D\u0001J\u0015\tQ5*\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000f1S!!\u0014(\u0002\t9Lgn\u001a\u0006\u0002\u001f\u0006\u00191m\\7\n\u0005EK%A\u0004*fcV,7\u000f\u001e\"vS2$WM\u001d\u0005\u0006'\n\u0003\raR\u0001\u000fe\u0016\fX/Z:u\u0005VLG\u000eZ3s\u0011\u0015)&\t1\u0001W\u0003\u001d\u0019Xm]:j_:\u0004\"aV-\u000e\u0003aS!!\u0016\u001a\n\u0005iC&aB*fgNLwN\u001c\u0005\u00069\n\u0003\r!X\u0001\u0004kJL\u0007C\u00010a\u001b\u0005y&B\u0001/J\u0013\t\twLA\u0002Ve&DQa\u0019\u0001\u0005\u0002\u0011\fabY8oM&<WO]3QCJ$8\u000f\u0006\u0002fOR\u0011aI\u001a\u0005\u0006'\n\u0004\ra\u0012\u0005\u0006+\n\u0004\rA\u0016\u0005\u0006S\u0002!\tF[\u0001\u0018G>tg-[4ve\u0016\u0014V-];fgR\u0014U/\u001b7eKJ$BAR6m[\")Q\u000b\u001ba\u0001-\")A\f\u001ba\u0001;\")1\u000b\u001ba\u0001\u000f\u0002")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final CommonAttributes commonAttributes;
    private final HttpAttributes httpAttributes;
    private final HttpProtocol protocol;

    @Override
    public Validation<String> makeAbsolute(String url) {
        Validation validation;
        if (HttpHelper$.MODULE$.isAbsoluteHttpUrl(url)) {
            validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)url));
        } else {
            Validation validation2;
            Option<String> option = this.protocol.baseURL();
            if (option instanceof Some) {
                Some some = (Some)option;
                String baseURL = (String)some.x();
                validation2 = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)new StringBuilder().append((Object)baseURL).append((Object)url).toString()));
            } else {
                validation2 = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No protocol.baseURL defined but provided url is relative : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url}))));
            }
            validation = validation2;
        }
        return validation;
    }

    public Validation<RequestBuilder> configureCaches(Session session, Uri uri2, RequestBuilder requestBuilder) {
        CacheHandling$.MODULE$.getLastModified(this.protocol, session, uri2).foreach((Function1)new Serializable(this, requestBuilder){
            public static final long serialVersionUID = 0L;
            private final RequestBuilder requestBuilder$1;

            public final RequestBuilder apply(String x$1) {
                return this.requestBuilder$1.setHeader(HeaderNames$.MODULE$.IfModifiedSince(), x$1);
            }
            {
                this.requestBuilder$1 = requestBuilder$1;
            }
        });
        CacheHandling$.MODULE$.getEtag(this.protocol, session, uri2).foreach((Function1)new Serializable(this, requestBuilder){
            public static final long serialVersionUID = 0L;
            private final RequestBuilder requestBuilder$1;

            public final RequestBuilder apply(String x$2) {
                return this.requestBuilder$1.setHeader(HeaderNames$.MODULE$.IfNoneMatch(), x$2);
            }
            {
                this.requestBuilder$1 = requestBuilder$1;
            }
        });
        return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)requestBuilder));
    }

    public Validation<RequestBuilder> configureParts(Session session, RequestBuilder requestBuilder) {
        Option<Body> option;
        block7: {
            Validation validation;
            block6: {
                Validation validation2;
                block5: {
                    Predef$.MODULE$.require(!this.httpAttributes.body().isDefined() || this.httpAttributes.bodyParts().isEmpty(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Can't have both a body and body parts!";
                        }
                    });
                    option = this.httpAttributes.body();
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    Body body = (Body)some.x();
                    validation = body.setBody(requestBuilder, session);
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option<Body> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                List<BodyPart> list = this.httpAttributes.bodyParts();
                Nil$ nil$ = Nil$.MODULE$;
                List<BodyPart> list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    validation2 = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)requestBuilder));
                } else {
                    Object object = this.commonAttributes.headers().contains((Object)HeaderNames$.MODULE$.ContentType()) ? BoxedUnit.UNIT : requestBuilder.addHeader(HeaderNames$.MODULE$.ContentType(), HeaderValues$.MODULE$.MultipartFormData());
                    validation2 = (Validation)list.foldLeft((Object)package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)requestBuilder)), (Function2)new Serializable(this, session){
                        public static final long serialVersionUID = 0L;
                        public final Session session$1;

                        public final Validation<RequestBuilder> apply(Validation<RequestBuilder> requestBuilder, BodyPart part) {
                            return requestBuilder.flatMap((Function1)new Serializable(this, part){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$configureParts$2 $outer;
                                private final BodyPart part$1;

                                public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                                    return this.part$1.toMultiPart(this.$outer.session$1).map((Function1)new Serializable(this, requestBuilder){
                                        public static final long serialVersionUID = 0L;
                                        private final RequestBuilder requestBuilder$2;

                                        public final RequestBuilder apply(Part part) {
                                            return this.requestBuilder$2.addBodyPart(part);
                                        }
                                        {
                                            this.requestBuilder$2 = requestBuilder$2;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.part$1 = part$1;
                                }
                            });
                        }
                        {
                            this.session$1 = session$1;
                        }
                    });
                }
                validation = validation2;
            }
            return validation;
        }
        throw new MatchError(option);
    }

    @Override
    public Validation<RequestBuilder> configureRequestBuilder(Session session, Uri uri2, RequestBuilder requestBuilder) {
        return super.configureRequestBuilder(session, uri2, requestBuilder).flatMap((Function1)new Serializable(this, session, uri2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpRequestExpressionBuilder $outer;
            private final Session session$2;
            private final Uri uri$1;

            public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                return this.$outer.configureCaches(this.session$2, this.uri$1, requestBuilder);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.session$2 = session$2;
                this.uri$1 = uri$1;
            }
        }).flatMap((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpRequestExpressionBuilder $outer;
            private final Session session$2;

            public final Validation<RequestBuilder> apply(RequestBuilder requestBuilder) {
                return this.$outer.configureParts(this.session$2, requestBuilder);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.session$2 = session$2;
            }
        });
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpProtocol protocol) {
        this.commonAttributes = commonAttributes;
        this.httpAttributes = httpAttributes;
        this.protocol = protocol;
        super(commonAttributes, protocol);
    }
}

