/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Realm;
import com.ning.http.client.uri.Uri;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.session.Session;
import io.gatling.core.validation.Validation;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.util.HttpHelper$;
import io.gatling.http.util.HttpHelper$$anonfun$buildRealm$1$;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class HttpHelper$
implements StrictLogging {
    public static final HttpHelper$ MODULE$;
    private final String HttpScheme;
    private final String HttpsScheme;
    private final String WsScheme;
    private final String WssScheme;
    private final Vector<Object> OkCodes;
    private final Vector<Object> RedirectStatusCodes;
    private final Logger logger;

    static {
        new HttpHelper$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String HttpScheme() {
        return this.HttpScheme;
    }

    public String HttpsScheme() {
        return this.HttpsScheme;
    }

    public String WsScheme() {
        return this.WsScheme;
    }

    public String WssScheme() {
        return this.WssScheme;
    }

    public Vector<Object> OkCodes() {
        return this.OkCodes;
    }

    public Vector<Object> RedirectStatusCodes() {
        return this.RedirectStatusCodes;
    }

    public List<Tuple2<String, String>> parseFormBody(String body) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])body.split("&")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split("=", 2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String[] pair) {
                String paramName = HttpHelper$.MODULE$.io$gatling$http$util$HttpHelper$$utf8Decode$1(pair[0]);
                String paramValue = pair.length > 1 ? HttpHelper$.MODULE$.io$gatling$http$util$HttpHelper$$utf8Decode$1(pair[1]) : "";
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)paramName), (Object)paramValue);
            }
        }, scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
    }

    public Function1<Session, Validation<Realm>> buildBasicAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return this.buildRealm(username, password, Realm.AuthScheme.BASIC, true);
    }

    public Function1<Session, Validation<Realm>> buildDigestAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return this.buildRealm(username, password, Realm.AuthScheme.DIGEST, false);
    }

    public Function1<Session, Validation<Realm>> buildRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password, Realm.AuthScheme authScheme, boolean preemptive) {
        return new Serializable(username, password, authScheme, preemptive){
            public static final long serialVersionUID = 0L;
            private final Function1 username$1;
            public final Function1 password$1;
            public final Realm.AuthScheme authScheme$1;
            public final boolean preemptive$1;

            public final Validation<Realm> apply(Session session) {
                return ((Validation)this.username$1.apply((Object)session)).flatMap((Function1)new Serializable(this, session){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildRealm.1 $outer;
                    private final Session session$1;

                    public final Validation<Realm> apply(String usernameValue) {
                        return ((Validation)this.$outer.password$1.apply((Object)this.session$1)).map((Function1)new Serializable(this, usernameValue){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$buildRealm$1$$anonfun$apply$1 $outer;
                            private final String usernameValue$1;

                            public final Realm apply(String passwordValue) {
                                return HttpHelper$.MODULE$.buildRealm(this.usernameValue$1, passwordValue, this.$outer.io$gatling$http$util$HttpHelper$$anonfun$$anonfun$$$outer().authScheme$1, this.$outer.io$gatling$http$util$HttpHelper$$anonfun$$anonfun$$$outer().preemptive$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.usernameValue$1 = usernameValue$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.buildRealm.1 io$gatling$http$util$HttpHelper$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.session$1 = session$1;
                    }
                });
            }
            {
                this.username$1 = username$1;
                this.password$1 = password$1;
                this.authScheme$1 = authScheme$1;
                this.preemptive$1 = preemptive$1;
            }
        };
    }

    public Realm buildBasicAuthRealm(String username, String password) {
        return this.buildRealm(username, password, Realm.AuthScheme.BASIC, true);
    }

    public Realm buildRealm(String username, String password, Realm.AuthScheme authScheme, boolean preemptive) {
        return new Realm.RealmBuilder().setPrincipal(username).setPassword(password).setUsePreemptiveAuth(preemptive).setScheme(authScheme).build();
    }

    private boolean headerExists(FluentCaseInsensitiveStringsMap headers2, String headerName, Function1<String, Object> f) {
        return Option$.MODULE$.apply((Object)headers2.getFirstValue(headerName)).exists(f);
    }

    public boolean isCss(FluentCaseInsensitiveStringsMap headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains(HeaderValues$.MODULE$.TextCss());
            }
        });
    }

    public boolean isHtml(FluentCaseInsensitiveStringsMap headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String ct) {
                return ct.contains(HeaderValues$.MODULE$.TextHtml()) || ct.contains(HeaderValues$.MODULE$.ApplicationXhtml());
            }
        });
    }

    public boolean isAjax(FluentCaseInsensitiveStringsMap headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.XRequestedWith(), (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains(HeaderValues$.MODULE$.XmlHttpRequest());
            }
        });
    }

    public boolean isTxt(FluentCaseInsensitiveStringsMap headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String ct) {
                return ct.contains("text") || ct.contains("json") || ct.contains("javascript") || ct.contains("xml");
            }
        });
    }

    public Uri resolveFromUri(Uri rootURI, String relative) {
        return relative.startsWith("//") ? Uri.create((String)new StringBuilder().append((Object)rootURI.getScheme()).append((Object)":").append((Object)relative).toString()) : Uri.create((Uri)rootURI, (String)relative);
    }

    public Option<Uri> resolveFromUriSilently(Uri rootURI, String relative) {
        Some some;
        try {
            some = new Some((Object)this.resolveFromUri(rootURI, relative));
        }
        catch (Exception exception) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to resolve URI rootURI='", "', relative='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootURI, relative})), (Throwable)exception);
            }
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean isRedirect(int statusCode) {
        return this.RedirectStatusCodes().contains((Object)BoxesRunTime.boxToInteger((int)statusCode));
    }

    public boolean isPermanentRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 308;
    }

    public boolean isNotModified(int statusCode) {
        return statusCode == 304;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSecure(Uri uri2) {
        String string = uri2.getScheme();
        String string2 = this.HttpsScheme();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = uri2.getScheme();
        String string4 = this.WssScheme();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public boolean isAbsoluteHttpUrl(String url) {
        return url.startsWith(this.HttpScheme());
    }

    public boolean isAbsoluteWsUrl(String url) {
        return url.startsWith(this.WsScheme());
    }

    public Option<Charset> extractCharsetFromContentType(String contentType) {
        None$ none$;
        int n = contentType.indexOf("charset=");
        switch (n) {
            default: {
                IntRef intRef;
                IntRef start2 = new IntRef(n + "charset=".length());
                int n2 = contentType.indexOf(59, start2.elem);
                switch (n2) {
                    default: {
                        intRef = new IntRef(n2);
                        break;
                    }
                    case -1: {
                        intRef = new IntRef(contentType.length());
                    }
                }
                IntRef end = intRef;
                none$ = Try$.MODULE$.apply((Function0)new Serializable(contentType, start2, end){
                    public static final long serialVersionUID = 0L;
                    private final String contentType$1;
                    private final IntRef start$1;
                    private final IntRef end$1;

                    public final Charset apply() {
                        while (this.contentType$1.charAt(this.start$1.elem) == ' ' && this.start$1.elem < this.end$1.elem) {
                            ++this.start$1.elem;
                        }
                        while (this.contentType$1.charAt(this.end$1.elem - 1) == ' ' && this.end$1.elem > this.start$1.elem) {
                            --this.end$1.elem;
                        }
                        if (this.contentType$1.charAt(this.start$1.elem) == '\"' && this.start$1.elem < this.end$1.elem) {
                            ++this.start$1.elem;
                        }
                        if (this.contentType$1.charAt(this.end$1.elem - 1) == '\"' && this.end$1.elem > this.start$1.elem) {
                            --this.end$1.elem;
                        }
                        String charsetString = this.contentType$1.substring(this.start$1.elem, this.end$1.elem);
                        return Charset.forName(charsetString);
                    }
                    {
                        this.contentType$1 = contentType$1;
                        this.start$1 = start$1;
                        this.end$1 = end$1;
                    }
                }).toOption();
                break;
            }
            case -1: {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public final String io$gatling$http$util$HttpHelper$$utf8Decode$1(String s) {
        return URLDecoder.decode(s, Codec$.MODULE$.UTF8().name());
    }

    private HttpHelper$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.HttpScheme = "http";
        this.HttpsScheme = "https";
        this.WsScheme = "ws";
        this.WssScheme = "wss";
        this.OkCodes = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{200, 304, 201, 202, 203, 204, 205, 206, 207, 208, 209}));
        this.RedirectStatusCodes = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{301, 302, 303, 307, 308}));
    }
}

