/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Clock;
import io.gatling.http.action.ws.fsm.WsFsm;
import io.gatling.http.client.WebSocket;
import io.gatling.http.client.WebSocketListener;
import io.gatling.http.util.HttpHelper$;
import io.gatling.netty.util.ByteBufUtils;
import io.gatling.netty.util.Utf8ByteBufCharsetDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\b\u0010\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)!\b\u0001C\u0001w!9\u0001\t\u0001a\u0001\n\u0013\t\u0005bB/\u0001\u0001\u0004%IA\u0018\u0005\u0007K\u0002\u0001\u000b\u0015\u0002\"\t\u000b\u0019\u0004A\u0011I4\t\u000bM\u0004A\u0011\t;\t\u000bU\u0004A\u0011\t<\t\r}\u0004A\u0011IA\u0001\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002$\u0001!\t%!\n\u0003\u0015]\u001bH*[:uK:,'O\u0003\u0002\u0011#\u0005\u0011qo\u001d\u0006\u0003%M\ta!Y2uS>t'B\u0001\u000b\u0016\u0003\u0011AG\u000f\u001e9\u000b\u0005Y9\u0012aB4bi2Lgn\u001a\u0006\u00021\u0005\u0011\u0011n\\\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0003=M\taa\u00197jK:$\u0018B\u0001\u0011\u001e\u0005E9VMY*pG.,G\u000fT5ti\u0016tWM\u001d\t\u0003E%j\u0011a\t\u0006\u0003I\u0015\nAb]2bY\u0006dwnZ4j]\u001eT!AJ\u0014\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001K\u0001\u0004G>l\u0017B\u0001\u0016$\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0007\u0019\u001cX\u000e\u0005\u0002._5\taF\u0003\u0002,\u001f%\u0011\u0001G\f\u0002\u0006/N45/\\\u0001\u0006G2|7m\u001b\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA!\u001e;jY*\u0011q'F\u0001\bG>lWn\u001c8t\u0013\tIDGA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\u0004yyz\u0004CA\u001f\u0001\u001b\u0005y\u0001\"B\u0016\u0004\u0001\u0004a\u0003\"B\u0019\u0004\u0001\u0004\u0011\u0014aB2p_.LWm]\u000b\u0002\u0005B\u00191)\u0014)\u000f\u0005\u0011SeBA#I\u001b\u00051%BA$\u001a\u0003\u0019a$o\\8u}%\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0019\u00069\u0001/Y2lC\u001e,'\"A%\n\u00059{%\u0001\u0002'jgRT!a\u0013'\u0011\u0005E[V\"\u0001*\u000b\u0005M#\u0016AB2p_.LWM\u0003\u0002\u0015+*\u0011akV\u0001\u0006G>$Wm\u0019\u0006\u00031f\u000bq\u0001[1oI2,'O\u0003\u0002[/\u0005)a.\u001a;us&\u0011AL\u0015\u0002\u0007\u0007>|7.[3\u0002\u0017\r|wn[5fg~#S-\u001d\u000b\u0003?\u000e\u0004\"\u0001Y1\u000e\u00031K!A\u0019'\u0003\tUs\u0017\u000e\u001e\u0005\bI\u0016\t\t\u00111\u0001C\u0003\rAH%M\u0001\tG>|7.[3tA\u0005qqN\u001c%uiB\u0014Vm\u001d9p]N,GcA0i]\")\u0011n\u0002a\u0001U\u0006\u0011\u0002\u000e\u001e;q%\u0016\u001c\bo\u001c8tKN#\u0018\r^;t!\tYG.D\u0001U\u0013\tiGK\u0001\nIiR\u0004(+Z:q_:\u001cXm\u0015;biV\u001c\b\"B8\b\u0001\u0004\u0001\u0018a\u00035uiBDU-\u00193feN\u0004\"a[9\n\u0005I$&a\u0003%uiBDU-\u00193feN\fqb\u001c8XK\n\u001cvnY6fi>\u0003XM\u001c\u000b\u0002?\u0006aqN\\\"m_N,gI]1nKR\u0011ql\u001e\u0005\u0006q&\u0001\r!_\u0001\u0006MJ\fW.\u001a\t\u0003uvl\u0011a\u001f\u0006\u0003yR\u000b!b^3cg>\u001c7.\u001a;y\u0013\tq8PA\nDY>\u001cXmV3c'>\u001c7.\u001a;Ge\u0006lW-A\u0006p]R+\u0007\u0010\u001e$sC6,GcA0\u0002\u0004!1\u0001P\u0003a\u0001\u0003\u000b\u00012A_A\u0004\u0013\r\tIa\u001f\u0002\u0013)\u0016DHoV3c'>\u001c7.\u001a;Ge\u0006lW-A\u0007p]\nKg.\u0019:z\rJ\fW.\u001a\u000b\u0004?\u0006=\u0001B\u0002=\f\u0001\u0004\t\t\u0002E\u0002{\u0003'I1!!\u0006|\u0005Q\u0011\u0015N\\1ss^+'mU8dW\u0016$hI]1nK\u0006YqN\u001c)p]\u001e4%/Y7f)\ry\u00161\u0004\u0005\u0007q2\u0001\r!!\b\u0011\u0007i\fy\"C\u0002\u0002\"m\u0014!\u0003U8oO^+'mU8dW\u0016$hI]1nK\u0006YqN\u001c+ie><\u0018M\u00197f)\ry\u0016q\u0005\u0005\b\u0003Si\u0001\u0019AA\u0016\u0003\u0005!\bcA\"\u0002.%\u0019\u0011qF(\u0003\u0013QC'o\\<bE2,\u0007")
public class WsListener
extends WebSocketListener
implements LazyLogging {
    private final WsFsm fsm;
    private final Clock clock;
    private List<Cookie> cookies;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        WsListener wsListener = this;
        synchronized (wsListener) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private List<Cookie> cookies() {
        return this.cookies;
    }

    private void cookies_$eq(List<Cookie> x$1) {
        this.cookies = x$1;
    }

    public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received response to WebSocket CONNECT: {} {}", new Object[]{httpResponseStatus, httpHeaders});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.cookies_$eq(HttpHelper$.MODULE$.responseCookies(httpHeaders));
    }

    public void onWebSocketOpen() {
        this.fsm.onWebSocketConnected((WebSocket)this, this.cookies(), this.clock.nowMillis());
    }

    public void onCloseFrame(CloseWebSocketFrame frame) {
        this.fsm.onWebSocketClosed(frame.statusCode(), frame.reasonText(), this.clock.nowMillis());
    }

    public void onTextFrame(TextWebSocketFrame frame) {
        this.fsm.onTextFrameReceived(Utf8ByteBufCharsetDecoder.decodeUtf8((ByteBuf)frame.content()), this.clock.nowMillis());
    }

    public void onBinaryFrame(BinaryWebSocketFrame frame) {
        this.fsm.onBinaryFrameReceived(ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content()), this.clock.nowMillis());
    }

    public void onPongFrame(PongWebSocketFrame frame) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received PONG frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onThrowable(Throwable t) {
        this.fsm.onWebSocketCrashed(t, this.clock.nowMillis());
    }

    public WsListener(WsFsm fsm, Clock clock) {
        this.fsm = fsm;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        this.cookies = package$.MODULE$.Nil();
    }
}

