/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsProducerPool;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTrackerPool;
import io.gatling.jms.protocol.JmsMessageMatcher;
import io.gatling.jms.request.JmsDestination;
import io.gatling.jms.request.JmsDestination$TemporaryQueue$;
import io.gatling.jms.request.JmsDestination$TemporaryTopic$;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\f\u0019\u0005\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011)\u0019!C\u0001c!AQ\b\u0001B\u0001B\u0003%!\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011U\u0003!\u0011!Q\u0001\nYCQ\u0001\u0018\u0001\u0005\u0002uCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u001d\tY\u0001\u0001Q\u0001\n9D\u0001\"!\u0004\u0001\u0005\u0004%I!\u001c\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003o\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'A\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0017Bq!a\u0015\u0001\t\u0003\t)\u0006C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l!A\u00111\u000f\u0001!\u0002\u0013\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\ni!*\\:D_:tWm\u0019;j_:T!!\u0007\u000e\u0002\r\rd\u0017.\u001a8u\u0015\tYB$A\u0002k[NT!!\b\u0010\u0002\u000f\u001d\fG\u000f\\5oO*\tq$\u0001\u0002j_\u000e\u00011C\u0001\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005)rS\"A\u0016\u000b\u0005ma#\"A\u0017\u0002\u000f)\f7.\u0019:uC&\u0011qf\u000b\u0002\u000b\u0007>tg.Z2uS>t\u0017aC2sK\u0012,g\u000e^5bYN,\u0012A\r\t\u0004GM*\u0014B\u0001\u001b%\u0005\u0019y\u0005\u000f^5p]B\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0006[>$W\r\u001c\u0006\u0003uq\tqaY8n[>t7/\u0003\u0002=o\tY1I]3eK:$\u0018.\u00197t\u00031\u0019'/\u001a3f]RL\u0017\r\\:!\u0003\u0019\u0019\u0018p\u001d;f[B\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0006C\u000e$xN\u001d\u0006\u0003\tr\tAaY8sK&\u0011a)\u0011\u0002\f\u0003\u000e$xN]*zgR,W.A\u0006ti\u0006$8/\u00128hS:,\u0007CA%M\u001b\u0005Q%BA&D\u0003\u0015\u0019H/\u0019;t\u0013\ti%JA\u0006Ti\u0006$8/\u00128hS:,\u0017!B2m_\u000e\\\u0007C\u0001)T\u001b\u0005\t&B\u0001*:\u0003\u0011)H/\u001b7\n\u0005Q\u000b&!B\"m_\u000e\\\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002X56\t\u0001L\u0003\u0002Z\u0007\u000611m\u001c8gS\u001eL!a\u0017-\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q9a\fY1cG\u0012,\u0007CA0\u0001\u001b\u0005A\u0002\"\u0002\u0015\t\u0001\u0004I\u0003\"\u0002\u0019\t\u0001\u0004\u0011\u0004\"\u0002 \t\u0001\u0004y\u0004\"B$\t\u0001\u0004A\u0005\"\u0002(\t\u0001\u0004y\u0005\"B+\t\u0001\u00041\u0016aC:fgNLwN\u001c)p_2,\u0012\u0001\u001b\t\u0003?&L!A\u001b\r\u0003\u001d)k7oU3tg&|g\u000eU8pY\u0006a1/Z:tS>t\u0007k\\8mA\u0005a1\u000f^1uS\u000e\fV/Z;fgV\ta\u000eE\u0003pk^\f)!D\u0001q\u0015\t\t(/\u0001\u0006d_:\u001cWO\u001d:f]RT!AU:\u000b\u0003Q\fAA[1wC&\u0011a\u000f\u001d\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001=\u0000\u001d\tIX\u0010\u0005\u0002{I5\t1P\u0003\u0002}A\u00051AH]8pizJ!A \u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tqH\u0005E\u0002+\u0003\u000fI1!!\u0003,\u0005-!Um\u001d;j]\u0006$\u0018n\u001c8\u0002\u001bM$\u0018\r^5d#V,W/Z:!\u00031\u0019H/\u0019;jGR{\u0007/[2t\u00035\u0019H/\u0019;jGR{\u0007/[2tA\u0005YA-Z:uS:\fG/[8o)\u0011\t)\"a\u000e\u0011\r\u0005]\u0011\u0011GA\u0003\u001d\u0011\tI\"a\u000b\u000f\t\u0005m\u0011q\u0005\b\u0005\u0003;\t)C\u0004\u0003\u0002 \u0005\rbb\u0001>\u0002\"%\tq$\u0003\u0002\u001e=%\u0011A\tH\u0005\u0004\u0003S\u0019\u0015aB:fgNLwN\\\u0005\u0005\u0003[\ty#A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005%2)\u0003\u0003\u00024\u0005U\"AC#yaJ,7o]5p]*!\u0011QFA\u0018\u0011\u001d\tId\u0004a\u0001\u0003w\taB[7t\t\u0016\u001cH/\u001b8bi&|g\u000e\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\tEG\u0001\be\u0016\fX/Z:u\u0013\u0011\t)%a\u0010\u0003\u001d)k7\u000fR3ti&t\u0017\r^5p]\u0006a\u0001O]8ek\u000e,'\u000fU8pYV\u0011\u00111\n\t\u0004?\u00065\u0013bAA(1\ty!*\\:Qe>$WoY3s!>|G.A\u0007qe>$WoY3s!>|G\u000eI\u0001\taJ|G-^2feR1\u0011qKA/\u0003?\u00022aXA-\u0013\r\tY\u0006\u0007\u0002\f\u00156\u001c\bK]8ek\u000e,'\u000fC\u0004\u0002\u0012I\u0001\r!!\u0002\t\u000f\u0005\u0005$\u00031\u0001\u0002d\u0005aA-\u001a7jm\u0016\u0014\u00180T8eKB\u00191%!\u001a\n\u0007\u0005\u001dDEA\u0002J]R\f1\u0002\u001e:bG.,'\u000fU8pYV\u0011\u0011Q\u000e\t\u0004?\u0006=\u0014bAA91\tq!*\\:Ue\u0006\u001c7.\u001a:Q_>d\u0017\u0001\u0004;sC\u000e\\WM\u001d)p_2\u0004\u0013a\u0002;sC\u000e\\WM\u001d\u000b\u000b\u0003s\ni)a$\u0002\u0016\u0006e\u0005#\u0002!\u0002|\u0005}\u0014bAA?\u0003\nA\u0011i\u0019;peJ+g\r\u0005\u0003\u0002\u0002\u0006\u001debA0\u0002\u0004&\u0019\u0011Q\u0011\r\u0002\u0015)k7\u000f\u0016:bG.,'/\u0003\u0003\u0002\n\u0006-%aB\"p[6\fg\u000e\u001a\u0006\u0004\u0003\u000bC\u0002bBA\t+\u0001\u0007\u0011Q\u0001\u0005\b\u0003#+\u0002\u0019AAJ\u0003!\u0019X\r\\3di>\u0014\bcA\u00124o\"9\u0011qS\u000bA\u0002\u0005\r\u0014a\u00057jgR,g.\u001a:UQJ,\u0017\rZ\"pk:$\bbBAN+\u0001\u0007\u0011QT\u0001\u000f[\u0016\u001c8/Y4f\u001b\u0006$8\r[3s!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR5\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002(\u0006\u0005&!\u0005&ng6+7o]1hK6\u000bGo\u00195fe\u0006)1\r\\8tKR\u0011\u0011Q\u0016\t\u0004G\u0005=\u0016bAAYI\t!QK\\5u\u0001")
public final class JmsConnection {
    private final Connection connection;
    private final Option<Credentials> credentials;
    private final JmsSessionPool sessionPool;
    private final ConcurrentHashMap<String, Destination> staticQueues;
    private final ConcurrentHashMap<String, Destination> staticTopics;
    private final JmsProducerPool producerPool;
    private final JmsTrackerPool trackerPool;

    public Option<Credentials> credentials() {
        return this.credentials;
    }

    private JmsSessionPool sessionPool() {
        return this.sessionPool;
    }

    private ConcurrentHashMap<String, Destination> staticQueues() {
        return this.staticQueues;
    }

    private ConcurrentHashMap<String, Destination> staticTopics() {
        return this.staticTopics;
    }

    public Function1<Session, Validation<Destination>> destination(JmsDestination jmsDestination) {
        jakarta.jms.Session jmsSession = this.sessionPool().jmsSession();
        JmsDestination jmsDestination2 = jmsDestination;
        if (JmsDestination$TemporaryQueue$.MODULE$.equals(jmsDestination2)) {
            return package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryQueue()));
        }
        if (JmsDestination$TemporaryTopic$.MODULE$.equals(jmsDestination2)) {
            return package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryTopic()));
        }
        if (jmsDestination2 instanceof JmsDestination.Queue) {
            JmsDestination.Queue queue = (JmsDestination.Queue)jmsDestination2;
            Function1<Session, Validation<String>> name = queue.name();
            return package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable)n -> (Destination)this.staticQueues().computeIfAbsent((String)n, x$1 -> jmsSession.createQueue(x$1)));
        }
        if (jmsDestination2 instanceof JmsDestination.Topic) {
            JmsDestination.Topic topic = (JmsDestination.Topic)jmsDestination2;
            Function1<Session, Validation<String>> name = topic.name();
            return package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable)n -> (Destination)this.staticTopics().computeIfAbsent((String)n, x$1 -> jmsSession.createTopic(x$1)));
        }
        throw new MatchError((Object)jmsDestination2);
    }

    private JmsProducerPool producerPool() {
        return this.producerPool;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return this.producerPool().producer(destination, deliveryMode);
    }

    private JmsTrackerPool trackerPool() {
        return this.trackerPool;
    }

    public ActorRef<JmsTracker.Command> tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackerPool().tracker(destination, selector, listenerThreadCount, messageMatcher);
    }

    public void close() {
        this.producerPool().close();
        this.sessionPool().close();
        this.connection.close();
    }

    public JmsConnection(Connection connection, Option<Credentials> credentials, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.connection = connection;
        this.credentials = credentials;
        this.sessionPool = new JmsSessionPool(connection);
        this.staticQueues = new ConcurrentHashMap();
        this.staticTopics = new ConcurrentHashMap();
        this.producerPool = new JmsProducerPool(this.sessionPool());
        this.trackerPool = new JmsTrackerPool(this.sessionPool(), system, statsEngine, clock, configuration);
    }
}

