/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterpriseMojo;
import io.gatling.mojo.MojoUtils;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.pkg.Dependency;
import io.gatling.plugin.pkg.EnterprisePackager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;

@Execute(phase=LifecyclePhase.TEST_COMPILE)
@Mojo(name="enterprisePackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class EnterprisePackageMojo
extends AbstractEnterpriseMojo {
    private static final String MAVEN_PACKAGER_NAME = "maven";
    private static final Set<String> GATLING_GROUP_IDS = Set.of("io.gatling", "io.gatling.highcharts");
    private final PluginLogger pluginLogger = this.newPluginLogger();
    @Inject
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        Set<Artifact> allArtifacts = this.getAllArtifacts();
        this.pluginLogger.debug("allArtifacts=" + String.valueOf(allArtifacts));
        List<Artifact> gatlingArtifacts = allArtifacts.stream().filter(artifact -> GATLING_GROUP_IDS.contains(artifact.getGroupId())).collect(Collectors.toList());
        this.pluginLogger.debug("gatlingArtifacts=" + String.valueOf(gatlingArtifacts));
        Set gatlingDependencies = gatlingArtifacts.stream().map(EnterprisePackageMojo::artifactToDependency).collect(Collectors.toSet());
        this.pluginLogger.debug("gatlingDependencies=" + String.valueOf(gatlingDependencies));
        Set<Dependency> extraDependencies = this.getExtraDependencies(allArtifacts, gatlingArtifacts);
        this.pluginLogger.debug("extraDependencies=" + String.valueOf(extraDependencies));
        List<File> classDirectories = List.of(new File(this.mavenProject.getBuild().getOutputDirectory()), new File(this.mavenProject.getBuild().getTestOutputDirectory()));
        File enterprisePackage = this.enterprisePackage();
        try {
            new EnterprisePackager(this.pluginLogger).createEnterprisePackage(classDirectories, gatlingDependencies, extraDependencies, this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), MAVEN_PACKAGER_NAME, ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), enterprisePackage, this.mavenProject.getBasedir());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate Enterprise package", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.mavenProject, "jar", "shaded", enterprisePackage);
    }

    private Set<Dependency> getExtraDependencies(Set<Artifact> allDeps, List<Artifact> gatlingArtifacts) {
        Set<Artifact> gatlingAndTransitiveDependencies = this.gatlingAndTransitiveDependencies(gatlingArtifacts);
        this.pluginLogger.debug("gatlingAndTransitiveDependencies=" + String.valueOf(gatlingAndTransitiveDependencies));
        return allDeps.stream().filter(artifact -> MojoUtils.artifactNotIn(artifact, gatlingAndTransitiveDependencies)).map(EnterprisePackageMojo::artifactToDependency).collect(Collectors.toSet());
    }

    private Set<Artifact> getAllArtifacts() {
        return this.mavenProject.getArtifacts().stream().filter(artifact -> !artifact.getType().equals("pom")).collect(Collectors.toSet());
    }

    private Set<Artifact> gatlingAndTransitiveDependencies(List<Artifact> artifacts) {
        return artifacts.stream().flatMap(artifact -> this.resolveTransitively((Artifact)artifact).stream()).collect(Collectors.toSet());
    }

    private Set<Artifact> resolveTransitively(Artifact artifact) {
        this.pluginLogger.debug("Resolving artifact=" + String.valueOf(artifact));
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(true).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        this.pluginLogger.debug("Resolved artifact=" + String.valueOf(artifact));
        return this.repository.resolve(request).getArtifacts();
    }

    private static Dependency artifactToDependency(Artifact artifact) {
        return new Dependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getFile());
    }
}

