/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.cms.jcajce;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1OctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.gatling.recorder.internal.bouncycastle.cms.CMSException;
import io.gatling.recorder.internal.bouncycastle.cms.RecipientOperator;
import io.gatling.recorder.internal.bouncycastle.cms.jcajce.CMSInputAEADDecryptor;
import io.gatling.recorder.internal.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;

public class JceKeyAgreeAuthEnvelopedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeAuthEnvelopedRecipient(PrivateKey privateKey) {
        super(privateKey);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, subjectPublicKeyInfo, aSN1OctetString, byArray);
        Cipher cipher = this.contentHelper.createContentCipher(key, algorithmIdentifier2);
        return new RecipientOperator(new CMSInputAEADDecryptor(algorithmIdentifier2, cipher));
    }
}

