/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.crypto.engines;

import io.gatling.recorder.internal.bouncycastle.crypto.engines.AsconBaseEngine;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import io.gatling.recorder.internal.bouncycastle.util.Pack;

public class AsconAEAD128
extends AsconBaseEngine {
    public AsconAEAD128() {
        this.KEY_SIZE = 16;
        this.IV_SIZE = 16;
        this.MAC_SIZE = 16;
        this.ASCON_AEAD_RATE = 16;
        this.ASCON_IV = 17594342703105L;
        this.algorithmName = "Ascon-AEAD128";
        this.nr = 8;
        this.m_bufferSizeDecrypt = this.ASCON_AEAD_RATE + this.MAC_SIZE;
        this.m_buf = new byte[this.m_bufferSizeDecrypt];
        this.dsep = Long.MIN_VALUE;
    }

    @Override
    protected long pad(int n) {
        return 1L << (n << 3);
    }

    @Override
    protected long loadBytes(byte[] byArray, int n) {
        return Pack.littleEndianToLong(byArray, n);
    }

    @Override
    protected void setBytes(long l, byte[] byArray, int n) {
        Pack.longToLittleEndian(l, byArray, n);
    }

    @Override
    protected void ascon_aeadinit() {
        this.x0 = this.ASCON_IV;
        this.x1 = this.K0;
        this.x2 = this.K1;
        this.x3 = this.N0;
        this.x4 = this.N1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
    }

    @Override
    protected void processFinalAadBlock() {
        Arrays.fill(this.m_buf, this.m_bufPos, this.m_buf.length, (byte)0);
        if (this.m_bufPos >= 8) {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0);
            this.x1 ^= Pack.littleEndianToLong(this.m_buf, 8) ^ this.pad(this.m_bufPos);
        } else {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0) ^ this.pad(this.m_bufPos);
        }
    }

    @Override
    protected void processFinalDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n >= 8) {
            long l = Pack.littleEndianToLong(byArray, 0);
            long l2 = Pack.littleEndianToLong(byArray, 8, n -= 8);
            Pack.longToLittleEndian(this.x0 ^ l, byArray2, n2);
            Pack.longToLittleEndian(this.x1 ^ l2, byArray2, n2 + 8, n);
            this.x0 = l;
            this.x1 &= -(1L << (n << 3));
            this.x1 |= l2;
            this.x1 ^= this.pad(n);
        } else {
            if (n != 0) {
                long l = Pack.littleEndianToLong(byArray, 0, n);
                Pack.longToLittleEndian(this.x0 ^ l, byArray2, n2, n);
                this.x0 &= -(1L << (n << 3));
                this.x0 |= l;
            }
            this.x0 ^= this.pad(n);
        }
        this.finishData(AsconBaseEngine.State.DecFinal);
    }

    @Override
    protected void processFinalEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n >= 8) {
            this.x0 ^= Pack.littleEndianToLong(byArray, 0);
            this.x1 ^= Pack.littleEndianToLong(byArray, 8, n -= 8);
            Pack.longToLittleEndian(this.x0, byArray2, n2);
            Pack.longToLittleEndian(this.x1, byArray2, n2 + 8);
            this.x1 ^= this.pad(n);
        } else {
            if (n != 0) {
                this.x0 ^= Pack.littleEndianToLong(byArray, 0, n);
                Pack.longToLittleEndian(this.x0, byArray2, n2, n);
            }
            this.x0 ^= this.pad(n);
        }
        this.finishData(AsconBaseEngine.State.EncFinal);
    }

    private void finishData(AsconBaseEngine.State state) {
        this.x2 ^= this.K0;
        this.x3 ^= this.K1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
        this.m_state = state;
    }

    @Override
    protected void init(byte[] byArray, byte[] byArray2) throws IllegalArgumentException {
        this.K0 = Pack.littleEndianToLong(byArray, 0);
        this.K1 = Pack.littleEndianToLong(byArray, 8);
        this.N0 = Pack.littleEndianToLong(byArray2, 0);
        this.N1 = Pack.littleEndianToLong(byArray2, 8);
        this.m_state = this.forEncryption ? AsconBaseEngine.State.EncInit : AsconBaseEngine.State.DecInit;
        this.reset(true);
    }

    @Override
    public String getAlgorithmVersion() {
        return "v1.3";
    }
}

