/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.mitm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.recorder.http.mitm.TrafficLogger;
import io.gatling.recorder.http.mitm.controller.Controller;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u000554Q!\u0003\u0006\u0003\u0015QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015a\u0006\u0001\"\u0011^\u00055\u0019E.[3oi\"\u000bg\u000e\u001a7fe*\u00111\u0002D\u0001\u0005[&$XN\u0003\u0002\u000e\u001d\u0005!\u0001\u000e\u001e;q\u0015\ty\u0001#\u0001\u0005sK\u000e|'\u000fZ3s\u0015\t\t\"#A\u0004hCRd\u0017N\\4\u000b\u0003M\t!![8\u0014\u0007\u0001)R\u0004\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u000591\r[1o]\u0016d'B\u0001\u000e\u0013\u0003\u0015qW\r\u001e;z\u0013\tarC\u0001\u000fDQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:BI\u0006\u0004H/\u001a:\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\ti1\u000b\u001e:jGRdunZ4j]\u001e\f!bY8oiJ|G\u000e\\3s\u0007\u0001\u0001\"A\u000b\u0017\u000e\u0003-R!a\n\u0006\n\u00055Z#AC\"p]R\u0014x\u000e\u001c7fe\u0006y1/\u001a:wKJ\u001c\u0005.\u00198oK2LE\r\u0005\u0002\u0017a%\u0011\u0011g\u0006\u0002\n\u0007\"\fgN\\3m\u0013\u0012\fQ\u0002\u001e:bM\u001aL7\rT8hO\u0016\u0014\bC\u0001\u001b6\u001b\u0005Q\u0011B\u0001\u001c\u000b\u00055!&/\u00194gS\u000edunZ4fe\u0006)1\r\\8dWB\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005kRLGN\u0003\u0002>!\u000591m\\7n_:\u001c\u0018BA ;\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q)!i\u0011#F\rB\u0011A\u0007\u0001\u0005\u0006O\u0015\u0001\r!\u000b\u0005\u0006]\u0015\u0001\ra\f\u0005\u0006e\u0015\u0001\ra\r\u0005\u0006o\u0015\u0001\r\u0001O\u0001\fG\"\fgN\\3m%\u0016\fG\rF\u0002J\u001fR\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013A!\u00168ji\")\u0001K\u0002a\u0001#\u0006\u00191\r\u001e=\u0011\u0005Y\u0011\u0016BA*\u0018\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ!\u0016\u0004A\u0002Y\u000b1!\\:h!\tQu+\u0003\u0002Y\u0017\n1\u0011I\\=SK\u001a\fqb\u00195b]:,G.\u00138bGRLg/\u001a\u000b\u0003\u0013nCQ\u0001U\u0004A\u0002E\u000bq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0004\u0013z{\u0006\"\u0002)\t\u0001\u0004\t\u0006\"\u00021\t\u0001\u0004\t\u0017!B2bkN,\u0007C\u00012k\u001d\t\u0019\u0007N\u0004\u0002eO6\tQM\u0003\u0002gQ\u00051AH]8pizJ\u0011\u0001T\u0005\u0003S.\u000bq\u0001]1dW\u0006<W-\u0003\u0002lY\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003S.\u0003")
public final class ClientHandler
extends ChannelInboundHandlerAdapter
implements StrictLogging {
    private final Controller controller;
    private final ChannelId serverChannelId;
    private final TrafficLogger trafficLogger;
    private final Clock clock;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        long receiveTimestamp = this.clock.nowMillis();
        Object object = msg;
        if (object instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
            this.trafficLogger.logResponse(this.serverChannelId, fullHttpResponse, receiveTimestamp);
            this.controller.$bang(new Controller.Message.ResponseReceived(fullHttpResponse));
            return;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Received unknown message: {}", object);
            return;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.controller.$bang(new Controller.Message.ClientChannelInactive(ctx.channel().id()));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.controller.$bang(new Controller.Message.ClientChannelException(cause));
    }

    public ClientHandler(Controller controller, ChannelId serverChannelId, TrafficLogger trafficLogger, Clock clock) {
        this.controller = controller;
        this.serverChannelId = serverChannelId;
        this.trafficLogger = trafficLogger;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

