/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.component;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.highcharts.component.AllUsersComponent;
import io.gatling.charts.highcharts.component.HighchartsComponent;
import io.gatling.charts.highcharts.series.CountsPerSecSeries;
import io.gatling.charts.highcharts.series.NumberPerSecondSeries;
import io.gatling.charts.highcharts.series.PercentilesSeries;
import io.gatling.charts.highcharts.series.PieSeries;
import io.gatling.charts.highcharts.series.ScatterSeries;
import io.gatling.charts.highcharts.series.StackedColumnSeries;
import io.gatling.charts.highcharts.template.ActiveUsersTemplate;
import io.gatling.charts.highcharts.template.CountsPerSecTemplate;
import io.gatling.charts.highcharts.template.DistributionTemplate;
import io.gatling.charts.highcharts.template.PercentilesOverTimeTemplate;
import io.gatling.charts.highcharts.template.RangesTemplate;
import io.gatling.charts.highcharts.template.RequestCountPolarTemplate;
import io.gatling.charts.highcharts.template.ResponseTimeScatterTemplate;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import io.gatling.charts.stats.PieSlice;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.Series;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u0006\r\u0005]AQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005B!BQ\u0001\u0012\u0001\u0005B\u0015CQ\u0001\u0016\u0001\u0005BUCQ\u0001\u001a\u0001\u0005B\u0015DQA\u001c\u0001\u0005B=DQ\u0001 \u0001\u0005BuDq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\t!2i\\7q_:,g\u000e\u001e'jEJ\f'/_%na2T!!\u0004\b\u0002\u0013\r|W\u000e]8oK:$(BA\b\u0011\u0003)A\u0017n\u001a5dQ\u0006\u0014Ho\u001d\u0006\u0003#I\taa\u00195beR\u001c(BA\n\u0015\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!F\u0001\u0003S>\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010\"\u001b\u0005\u0001#BA\u0007\u0011\u0013\t\u0011\u0003E\u0001\tD_6\u0004xN\\3oi2K'M]1ss\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011\u0001D\u0001\u000eO\u0016$\u0018\t\u001c7Vg\u0016\u00148OS:\u0015\u0007%\"\u0014\b\u0005\u0002+c9\u00111f\f\t\u0003Yii\u0011!\f\u0006\u0003]Y\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005AR\u0002\"B\u001b\u0003\u0001\u00041\u0014\u0001\u0003:v]N#\u0018M\u001d;\u0011\u0005e9\u0014B\u0001\u001d\u001b\u0005\u0011auN\\4\t\u000bi\u0012\u0001\u0019A\u001e\u0002\rM,'/[3t!\rat(Q\u0007\u0002{)\u0011a\bE\u0001\u0006gR\fGo]\u0005\u0003\u0001v\u0012aaU3sS\u0016\u001c\bC\u0001\u001fC\u0013\t\u0019UHA\u0007J]R46\u000fV5nKBcw\u000e^\u0001\u001bO\u0016$\u0018i\u0019;jm\u0016\u001cVm]:j_:\u001c8i\\7q_:,g\u000e\u001e\u000b\u0004\r&S\u0005CA\u0010H\u0013\tA\u0005EA\u0005D_6\u0004xN\\3oi\")Qg\u0001a\u0001m!)!h\u0001a\u0001\u0017B\u0019A*U\u001e\u000f\u00055{eB\u0001\u0017O\u0013\u0005Y\u0012B\u0001)\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0007M+\u0017O\u0003\u0002Q5\u0005\u0011r-\u001a;SC:<Wm]\"p[B|g.\u001a8u)\u00151e\u000b\u0017.`\u0011\u00159F\u00011\u0001*\u0003)\u0019\u0007.\u0019:u)&$H.\u001a\u0005\u00063\u0012\u0001\r!K\u0001\nKZ,g\u000e\u001e(b[\u0016DQa\u0017\u0003A\u0002q\u000baA]1oO\u0016\u001c\bC\u0001\u001f^\u0013\tqVH\u0001\u0004SC:<Wm\u001d\u0005\u0006A\u0012\u0001\r!Y\u0001\u0006Y\u0006\u0014x-\u001a\t\u00033\tL!a\u0019\u000e\u0003\u000f\t{w\u000e\\3b]\u0006ir-\u001a;SKF,Xm\u001d;D_VtG\u000fU8mCJ\u001cu.\u001c9p]\u0016tG\u000f\u0006\u0002GM\")q-\u0002a\u0001Q\u0006i!o\\8u\u0007>tG/Y5oKJ\u0004\"!\u001b7\u000e\u0003)T!a\u001b\t\u0002\rI,\u0007o\u001c:u\u0013\ti'N\u0001\bHe>,\boQ8oi\u0006Lg.\u001a:\u00021\u001d,G\u000fR5tiJL'-\u001e;j_:\u001cu.\u001c9p]\u0016tG\u000fF\u0003GaJ$(\u0010C\u0003r\r\u0001\u0007\u0011&A\u0003uSRdW\rC\u0003t\r\u0001\u0007\u0011&A\u0005z\u0003bL7OT1nK\")QO\u0002a\u0001m\u0006!\"/Z:q_:\u001cX\rV5nKN\u001cVoY2fgN\u00042\u0001P x!\ta\u00040\u0003\u0002z{\t\t\u0002+\u001a:dK:$hk\u001d+j[\u0016\u0004Fn\u001c;\t\u000bm4\u0001\u0019\u0001<\u0002+I,7\u000f]8og\u0016$\u0016.\\3t\r\u0006LG.\u001e:fg\u0006yr-\u001a;QKJ\u001cWM\u001c;jY\u0016\u001cxJ^3s)&lWmQ8na>tWM\u001c;\u0015\u000b\u0019sx0!\u0001\t\u000bM<\u0001\u0019A\u0015\t\u000bU:\u0001\u0019\u0001\u001c\t\u000f\u0005\rq\u00011\u0001\u0002\u0006\u0005\u0001B-\u001e:bi&|gn]*vG\u000e,7o\u001d\t\u0005y}\n9\u0001E\u0002=\u0003\u0013I1!a\u0003>\u0005U\u0001VM]2f]RLG.Z:WgRKW.\u001a)m_R\fAcZ3u%\u0016\fX/Z:ug\u000e{W\u000e]8oK:$Hc\u0002$\u0002\u0012\u0005M\u0011q\u0004\u0005\u0006k!\u0001\rA\u000e\u0005\b\u0003+A\u0001\u0019AA\f\u0003\u0019\u0019w.\u001e8ugB!AhPA\r!\ra\u00141D\u0005\u0004\u0003;i$\u0001E\"pk:$8OV:US6,\u0007\u000b\\8u\u0011\u001d\t\t\u0003\u0003a\u0001\u0003G\t\u0011\u0002]5f'\u0016\u0014\u0018.Z:\u0011\tqz\u0014Q\u0005\t\u0004y\u0005\u001d\u0012bAA\u0015{\tA\u0001+[3TY&\u001cW-A\u000bhKR\u0014Vm\u001d9p]N,7oQ8na>tWM\u001c;\u0015\u000f\u0019\u000by#!\r\u00024!)Q'\u0003a\u0001m!9\u0011QC\u0005A\u0002\u0005]\u0001bBA\u0011\u0013\u0001\u0007\u00111E\u0001 O\u0016$(+Z:q_:\u001cX\rV5nKN\u001b\u0017\r\u001e;fe\u000e{W\u000e]8oK:$H#\u0002$\u0002:\u0005u\u0002BBA\u001e\u0015\u0001\u00071(A\u0005tk\u000e\u001cWm]:fg\"1\u0011q\b\u0006A\u0002m\n\u0001BZ1jYV\u0014Xm\u001d")
public final class ComponentLibraryImpl
implements ComponentLibrary {
    public String getAllUsersJs(long runStart, Series<IntVsTimePlot> series) {
        return new AllUsersComponent(runStart, series).getJavascript();
    }

    public Component getActiveSessionsComponent(long runStart, Seq<Series<IntVsTimePlot>> series) {
        return new HighchartsComponent(new ActiveUsersTemplate(runStart, (Seq<NumberPerSecondSeries>)((Seq)series.map((Function1 & Serializable)s -> new NumberPerSecondSeries(s.name(), (Iterable<IntVsTimePlot>)s.data(), (Color)s.colors().head())))));
    }

    public Component getRangesComponent(String chartTitle, String eventName, Ranges ranges, boolean large) {
        return new HighchartsComponent(new RangesTemplate(chartTitle, eventName, ranges, large));
    }

    public Component getRequestCountPolarComponent(GroupContainer rootContainer) {
        return new HighchartsComponent(new RequestCountPolarTemplate(rootContainer));
    }

    public Component getDistributionComponent(String title, String yAxisName, Series<PercentVsTimePlot> responseTimesSuccess, Series<PercentVsTimePlot> responseTimesFailures) {
        return new HighchartsComponent(new DistributionTemplate(title, yAxisName, new StackedColumnSeries(responseTimesSuccess.name(), (Iterable<PieSlice>)((Iterable)responseTimesSuccess.data().map((Function1 & Serializable)plot -> new PieSlice(Integer.toString(plot.time()), plot.roundedUpValue()))), (Color)responseTimesSuccess.colors().head()), new StackedColumnSeries(responseTimesFailures.name(), (Iterable<PieSlice>)((Iterable)responseTimesFailures.data().map((Function1 & Serializable)plot -> new PieSlice(Integer.toString(plot.time()), plot.roundedUpValue()))), (Color)responseTimesFailures.colors().head())));
    }

    public Component getPercentilesOverTimeComponent(String yAxisName, long runStart, Series<PercentilesVsTimePlot> durationsSuccess) {
        return new HighchartsComponent(new PercentilesOverTimeTemplate(yAxisName, new PercentilesSeries(durationsSuccess.name(), runStart, (Iterable<PercentilesVsTimePlot>)durationsSuccess.data(), (List<Color>)durationsSuccess.colors())));
    }

    public Component getRequestsComponent(long runStart, Series<CountsVsTimePlot> counts, Series<PieSlice> pieSeries) {
        return new HighchartsComponent(new CountsPerSecTemplate("Number of requests per second", "Number of requests", "requests", new CountsPerSecSeries(runStart, (Iterable<CountsVsTimePlot>)counts.data(), (List<Color>)counts.colors()), new PieSeries(pieSeries.name(), (Iterable<PieSlice>)pieSeries.data(), (List<Color>)pieSeries.colors()), 760, true));
    }

    public Component getResponsesComponent(long runStart, Series<CountsVsTimePlot> counts, Series<PieSlice> pieSeries) {
        return new HighchartsComponent(new CountsPerSecTemplate("Number of responses per second", "Number of responses", "responses", new CountsPerSecSeries(runStart, (Iterable<CountsVsTimePlot>)counts.data(), (List<Color>)counts.colors()), new PieSeries(pieSeries.name(), (Iterable<PieSlice>)pieSeries.data(), (List<Color>)pieSeries.colors()), 775, false));
    }

    public Component getResponseTimeScatterComponent(Series<IntVsTimePlot> successes, Series<IntVsTimePlot> failures) {
        return new HighchartsComponent(new ResponseTimeScatterTemplate(new ScatterSeries(successes.name(), (Iterable<IntVsTimePlot>)successes.data(), (Color)successes.colors().head()), new ScatterSeries(failures.name(), (Iterable<IntVsTimePlot>)failures.data(), (Color)failures.colors().head()), "container_response_time_dispersion", "Response Time against Global Throughput", "Response Time (ms)"));
    }
}

